/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.async.ResultCallbackTemplate;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.LocalDirectorySSLConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.util.CertificateUtils;
import com.github.dockerjava.okhttp.OkDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentContainerImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentDeploymentImpl;
import com.intellij.docker.agent.DockerAgentImageBuilderImpl;
import com.intellij.docker.agent.DockerAgentImageImpl;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.PullImageResultCallbackImpl;
import com.intellij.docker.agent.auth.DockerClientConfigWithCustomAuth;
import com.intellij.docker.agent.cli.communicator.DockerCliFacade;
import com.intellij.docker.agent.event.DockerEventImpl;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.docker.agent.fix.DockerClientConfigWithFixedObjectMapper;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.PromisingSerializedItemsCallback;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DockerAgentImpl
implements DockerAgent {
    private static final String HTTPS_ERROR_MESSAGE = "https protocol is not supported";
    private static final String REGISTRY_AUTH_SUCCESS = "Login Succeeded";
    private static final String HTTPS_ERROR_MESSAGE_HINT = "<br/>Please check if path to certificates folder is specified and correct.<br/>Please also note, you don't need to specify path to certificates folder if use unsecured http connection on Linux.";
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final String TCP_PROTOCOL_PREFIX = "tcp://";
    private DockerAgentContext.DockerClientExt myClient;
    private CloudAgentLogger myLogger;
    private DockerCliFacade myCliFacade;
    private CloudAgentErrorHandler myErrorHandler;
    private volatile boolean myIsConnected;
    private AgentEventsListener myEventsListener;
    private static final RemoteApiVersion MAX_DOCKER_JAVA_SUPPORTED = RemoteApiVersion.VERSION_1_40;

    public DockerAgentImpl() {
        Logger.getLogger(ResultCallbackTemplate.class).setLevel(Level.OFF);
    }

    public void connect(final DockerAgentConfig config, final DockerCliFacade cliFacade, CloudAgentLogger logger2, CloudAgentErrorHandler errorHandler) {
        this.myLogger = logger2;
        this.myErrorHandler = errorHandler;
        this.myCliFacade = cliFacade;
        new ApiTaskBase<Void>(errorHandler){

            @Override
            protected Void doPerform() throws ApiTaskException {
                RemoteApiVersion remoteApiVersion = RemoteApiVersion.VERSION_1_24;
                try (DockerAgentContext.DockerClientExt clientExtWithOldVersion = DockerClientExtImpl.buildClient(cliFacade, config, remoteApiVersion);){
                    DockerClient realClient = clientExtWithOldVersion.getDockerClient();
                    realClient.pingCmd().exec();
                    Version actualVersion = (Version)realClient.versionCmd().exec();
                    remoteApiVersion = RemoteApiVersion.parseConfig((String)actualVersion.getApiVersion());
                    if (remoteApiVersion.isGreaterOrEqual(MAX_DOCKER_JAVA_SUPPORTED)) {
                        remoteApiVersion = MAX_DOCKER_JAVA_SUPPORTED;
                    }
                }
                catch (ConnectException e) {
                    DockerAgentImpl.this.myLogger.debugEx((Exception)e);
                    throw this.userFriendlyConnectException();
                }
                catch (UncheckedIOException e) {
                    String message;
                    IOException checked = e.getCause();
                    String string = message = checked.getMessage() != null ? checked.getMessage() : "";
                    if (checked.getCause() instanceof FileNotFoundException || checked.getCause() instanceof FileSystemException || message.contains("native socket() failed") || message.contains("native connect() failed")) {
                        DockerAgentImpl.this.myLogger.debugEx((Exception)e);
                        throw this.userFriendlyConnectException();
                    }
                    throw new ApiTaskException((Exception)checked);
                }
                catch (IOException e) {
                    throw new ApiTaskException((Exception)e);
                }
                DockerAgentContext.DockerClientExt clientExt = DockerClientExtImpl.buildClient(cliFacade, config, remoteApiVersion);
                clientExt.getDockerClient().pingCmd().exec();
                DockerAgentImpl.this.myClient = clientExt;
                DockerAgentImpl.this.myIsConnected = true;
                return null;
            }

            @Override
            protected void onError(String error) {
                if (((String)error).contains(DockerAgentImpl.HTTPS_ERROR_MESSAGE)) {
                    error = (String)error + DockerAgentImpl.HTTPS_ERROR_MESSAGE_HINT;
                }
                super.onError((String)error);
            }

            private ApiTaskException userFriendlyConnectException() {
                return new ApiTaskException(DockerAgentBundle.message((String)"DockerAgentImpl.cannot.connect.to.the.docker", (Object[])new Object[]{DockerAgentImpl.getDockerHost(config.getApiUrl())}));
            }
        }.perform();
    }

    private static String getDockerHost(String url) {
        if (url == null) {
            return null;
        }
        for (String prefix : new String[]{HTTP_PROTOCOL_PREFIX, HTTPS_PROTOCOL_PREFIX}) {
            if (!url.startsWith(prefix)) continue;
            return TCP_PROTOCOL_PREFIX + url.substring(prefix.length());
        }
        return url;
    }

    private static boolean isTlsVerifyEnabled(String url) {
        return url != null && url.startsWith(HTTPS_PROTOCOL_PREFIX);
    }

    public void disconnect() {
        this.myIsConnected = false;
        if (this.myEventsListener != null) {
            this.myEventsListener.close();
            this.myEventsListener = null;
        }
        try {
            this.myClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DockerClient getDockerClient() {
        return this.myClient.getDockerClient();
    }

    public boolean isConnected() {
        return this.myIsConnected;
    }

    public void attachEventListener(@NotNull DockerEvent.Listener listener) {
        if (listener == null) {
            DockerAgentImpl.$$$reportNull$$$0(0);
        }
        assert (this.myEventsListener == null);
        this.myEventsListener = new AgentEventsListener(this.myLogger, listener);
        this.getDockerClient().eventsCmd().exec((ResultCallback)this.myEventsListener);
    }

    public DockerCliFacade getCliFacade() {
        return this.myCliFacade;
    }

    public DockerAgentApplication[] getApplications() {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectContainers(result);
                DockerAgentImpl.this.collectImages(result, null);
            }
        }.perform();
    }

    public DockerAgentApplication[] getImages(final String label) {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectImages(result, label);
            }
        }.perform();
    }

    private void collectImages(List<DockerAgentApplication> result, String label) {
        ListImagesCmd listImagesCmd = this.getDockerClient().listImagesCmd();
        if (label != null) {
            listImagesCmd.withLabelFilter(new String[]{label});
        }
        List images = (List)listImagesCmd.exec();
        for (Image image : images) {
            result.add(new DockerAgentImageImpl(new DockerAgentContextImpl(), image));
        }
    }

    public DockerAgentApplication[] getContainers() {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectContainers(result);
            }
        }.perform();
    }

    public DockerAgentApplication findContainer(final @NotNull String containerId) {
        if (containerId == null) {
            DockerAgentImpl.$$$reportNull$$$0(1);
        }
        return (DockerAgentApplication)new ApiTaskBase<DockerAgentApplication>(this.myErrorHandler){

            @Override
            protected DockerAgentApplication doPerform() {
                List containers = (List)DockerAgentImpl.this.getDockerClient().listContainersCmd().withShowAll(Boolean.TRUE).withIdFilter(Collections.singletonList(containerId)).withLimit(Integer.valueOf(1)).exec();
                return containers.isEmpty() ? null : new DockerAgentContainerImpl(new DockerAgentContextImpl(), (Container)containers.get(0));
            }
        }.perform();
    }

    private void collectContainers(List<DockerAgentApplication> result) {
        List containers = (List)this.getDockerClient().listContainersCmd().withShowAll(Boolean.TRUE).exec();
        for (Container container : containers) {
            result.add(new DockerAgentContainerImpl(new DockerAgentContextImpl(), container));
        }
    }

    public void removeVolume(final String volumeName) {
        new ApiTaskBase<Void>(this.myErrorHandler){

            @Override
            protected Void doPerform() {
                DockerAgentImpl.this.getDockerClient().removeVolumeCmd(volumeName).exec();
                return null;
            }
        }.perform();
    }

    static StringBuilder appendAll(StringBuilder builder, String ... items) {
        if (items == null) {
            builder.append("<unknown>");
            return builder;
        }
        boolean first = true;
        TreeSet<String> sortedItems = new TreeSet<String>(Arrays.asList(items));
        for (String item : sortedItems) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(item);
        }
        return builder;
    }

    public OngoingProcess pullImage(final DockerAgentRepositoryConfig repositoryConfig, final DockerAgentProgressCallback progressCallback) {
        return (OngoingProcess)new ApiTaskBase<PullImageResultCallbackImpl>(this.myErrorHandler){

            @Override
            protected PullImageResultCallbackImpl doPerform() {
                PullImageCmd pullImageCmd = DockerAgentImpl.this.preparePullImageCmd(repositoryConfig);
                return (PullImageResultCallbackImpl)pullImageCmd.exec((ResultCallback)new PullImageResultCallbackImpl(progressCallback, DockerAgentImpl.this.myLogger));
            }
        }.perform();
    }

    @NotNull
    public CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(DockerAgentRepositoryConfig repositoryConfig) {
        CompletableFuture<BlockingQueue<byte[]>> result = new CompletableFuture<BlockingQueue<byte[]>>();
        try (PullImageCmd pullImageCmd = this.preparePullImageCmd(repositoryConfig);){
            pullImageCmd.exec(new PromisingSerializedItemsCallback(result));
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        CompletableFuture<BlockingQueue<byte[]>> completableFuture = result;
        if (completableFuture == null) {
            DockerAgentImpl.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    @NotNull
    public DockerAgent.DockerImageBuilder createImageBuilder() {
        return new DockerAgentImageBuilderImpl(this.getDockerClient());
    }

    PullImageCmd preparePullImageCmd(DockerAgentRepositoryConfig repositoryConfig) {
        String tag;
        PullImageCmd pullImageCmd = this.getDockerClient().pullImageCmd(repositoryConfig.getQualifiedRepository());
        DockerAuthConfig customAuthConfig = repositoryConfig.getAuthConfig();
        if (customAuthConfig != null) {
            pullImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(customAuthConfig));
        }
        if ((tag = repositoryConfig.getTag()) == null) {
            tag = "latest";
        }
        pullImageCmd.withTag(tag);
        return pullImageCmd;
    }

    public void imageRegistryAuth(final DockerAuthConfig authConfig) {
        new ApiTaskBase<Void>(this.myErrorHandler){

            @Override
            protected Void doPerform() throws ApiTaskException {
                AuthResponse authResponse = DockerAgentImpl.this.getDockerClient().authCmd().withAuthConfig((AuthConfig)new AuthConfigEx(authConfig)).exec();
                @NonNls String status = authResponse.getStatus();
                if (!DockerAgentImpl.REGISTRY_AUTH_SUCCESS.equals(status)) {
                    throw new ApiTaskException(status);
                }
                return null;
            }
        }.perform();
    }

    public DockerAgentDeployment createDeployment(@NotNull DockerAgentDeploymentConfig config, @NotNull DockerAgentPathMapper pathMapper) {
        if (config == null) {
            DockerAgentImpl.$$$reportNull$$$0(3);
        }
        if (pathMapper == null) {
            DockerAgentImpl.$$$reportNull$$$0(4);
        }
        return new DockerAgentDeploymentImpl(new DockerAgentContextImpl(), config, pathMapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/DockerAgentImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/DockerAgentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncPullImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachEventListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findContainer";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDeployment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AgentEventsListener
    implements ResultCallback<Event> {
        private final CloudAgentLogger myLogger;
        private final DockerEvent.Listener myListener;
        private Closeable myCloseable;

        AgentEventsListener(CloudAgentLogger logger2, DockerEvent.Listener realListener) {
            this.myLogger = logger2;
            this.myListener = realListener;
        }

        public void onStart(Closeable closeable) {
            this.myCloseable = closeable;
        }

        public void onNext(Event event) {
            if (event != null) {
                this.myListener.onDockerEvent((DockerEvent)new DockerEventImpl(event));
            }
        }

        public void onComplete() {
        }

        public void onError(Throwable throwable) {
            this.myLogger.debugEx(throwable instanceof Exception ? (Exception)throwable : new Exception(throwable));
        }

        public void close() {
            this.closeNettyChannel();
        }

        void closeNettyChannel() {
            if (this.myCloseable != null) {
                try {
                    this.myCloseable.close();
                }
                catch (IOException e) {
                    this.myLogger.debugEx((Exception)e);
                }
            }
            this.myCloseable = null;
        }
    }

    private abstract class ApplicationsApiTaskBase
    extends ApiTaskBase<DockerAgentApplication[]> {
        ApplicationsApiTaskBase() {
            super(DockerAgentImpl.this.myErrorHandler);
        }

        @Override
        protected DockerAgentApplication[] doPerform() throws IOException, ApiTaskException {
            ArrayList<DockerAgentApplication> result = new ArrayList<DockerAgentApplication>();
            this.collectApplications(result);
            return result.toArray(DockerAgentApplication.EMPTY_ARRAY);
        }

        protected abstract void collectApplications(List<DockerAgentApplication> var1);
    }

    private static final class DockerClientExtImpl
    implements DockerAgentContext.DockerClientExt {
        private final DockerClient myDockerClient;
        private final ObjectMapper myObjectMapper;

        private static DockerAgentContext.DockerClientExt buildClient(@NotNull DockerCliFacade cliFacade, @NotNull DockerAgentConfig config, @NotNull RemoteApiVersion remoteApiVersion) throws ApiTaskException {
            DefaultDockerClientConfig.Builder builder;
            if (cliFacade == null) {
                DockerClientExtImpl.$$$reportNull$$$0(0);
            }
            if (config == null) {
                DockerClientExtImpl.$$$reportNull$$$0(1);
            }
            if (remoteApiVersion == null) {
                DockerClientExtImpl.$$$reportNull$$$0(2);
            }
            try {
                builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
            }
            catch (IllegalArgumentException | NullPointerException e) {
                builder = new DefaultDockerClientConfig.Builder();
            }
            DefaultDockerClientConfig defaultConfig = builder.withDockerHost(DockerAgentImpl.getDockerHost(config.getApiUrl())).withDockerTlsVerify(Boolean.valueOf(DockerAgentImpl.isTlsVerifyEnabled(config.getApiUrl()))).withDockerCertPath(config.getCertificatesPath()).withApiVersion(remoteApiVersion).build();
            DockerClientExtImpl.validateConfig((DockerClientConfig)defaultConfig);
            DockerClientConfigWithCustomAuth withCustomAuth = new DockerClientConfigWithCustomAuth(cliFacade, defaultConfig);
            DockerClientConfigWithFixedObjectMapper withFixedVolumes = new DockerClientConfigWithFixedObjectMapper(withCustomAuth);
            return new DockerClientExtImpl(withFixedVolumes);
        }

        private static void validateConfig(DockerClientConfig dockerClientConfig) throws ApiTaskException {
            URI targetUri = dockerClientConfig.getDockerHost();
            if (targetUri == null) {
                throw new ApiTaskException(DockerAgentBundle.message((String)"DockerAgentImpl.docker.host.is.not.specified", (Object[])new Object[0]));
            }
            if ("tcp".equals(targetUri.getScheme()) && dockerClientConfig.getSSLConfig() instanceof LocalDirectorySSLConfig) {
                LocalDirectorySSLConfig sslConfigImpl = (LocalDirectorySSLConfig)dockerClientConfig.getSSLConfig();
                @NonNls String certificatesPath = sslConfigImpl.getDockerCertPath();
                if (certificatesPath == null) {
                    throw new ApiTaskException(DockerAgentBundle.message((String)"DockerAgentImpl.certificates.path.is.not.specified", (Object[])new Object[0]));
                }
                if (!CertificateUtils.verifyCertificatesExist((String)certificatesPath)) {
                    throw new ApiTaskException(DockerAgentBundle.message((String)"DockerAgentImpl.cant.locate.certificate.files", (Object[])new Object[]{certificatesPath}));
                }
            }
        }

        private DockerClientExtImpl(@NotNull DockerClientConfig config) {
            if (config == null) {
                DockerClientExtImpl.$$$reportNull$$$0(3);
            }
            this.myObjectMapper = config.getObjectMapper().copy();
            OkDockerHttpClient httpClient = new OkDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig((SSLConfig)config.getSSLConfig()).build();
            this.myDockerClient = DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
        }

        @Override
        @NotNull
        public ObjectMapper getObjectMapper() {
            ObjectMapper objectMapper2 = this.myObjectMapper.copy();
            if (objectMapper2 == null) {
                DockerClientExtImpl.$$$reportNull$$$0(4);
            }
            return objectMapper2;
        }

        @Override
        @NotNull
        public DockerClient getDockerClient() {
            DockerClient dockerClient = this.myDockerClient;
            if (dockerClient == null) {
                DockerClientExtImpl.$$$reportNull$$$0(5);
            }
            return dockerClient;
        }

        @Override
        public void close() throws IOException {
            this.myDockerClient.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cliFacade";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteApiVersion";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/DockerAgentImpl$DockerClientExtImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/DockerAgentImpl$DockerClientExtImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectMapper";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDockerClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildClient";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DockerAgentContextImpl
    implements DockerAgentContext {
        private DockerAgentContextImpl() {
        }

        @Override
        public DockerAgent getAgent() {
            return DockerAgentImpl.this;
        }

        @Override
        public DockerAgentContext.DockerClientExt getClientExt() {
            return DockerAgentImpl.this.myClient;
        }

        @Override
        public DockerClient getClient() {
            return DockerAgentImpl.this.myClient.getDockerClient();
        }

        @Override
        public CloudAgentErrorHandler getErrorHandler() {
            return DockerAgentImpl.this.myErrorHandler;
        }

        @Override
        public DockerCliFacade getCliFacade() {
            return DockerAgentImpl.this.myCliFacade;
        }

        @Override
        public CloudAgentLogger getLogger() {
            return DockerAgentImpl.this.myLogger;
        }
    }

    public static class FactoryImpl
    implements DockerAgent.Factory {
        @NotNull
        public DockerAgent createAgent() {
            return new DockerAgentImpl();
        }
    }
}

