/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.BuildImageCmdWithCleanup;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.PromisingSerializedItemsCallback;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/agent/DockerAgentImageBuilderImpl;", "Lcom/intellij/docker/agent/DockerAgent$DockerImageBuilder;", "client", "Lcom/github/dockerjava/api/DockerClient;", "(Lcom/github/dockerjava/api/DockerClient;)V", "asyncBuildImage", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/BlockingQueue;", "", "buildConfig", "Lcom/intellij/docker/agent/DockerAgentDeploymentConfig;", "BuildImageCallback", "intellij.clouds.docker.agent.impl"})
public final class DockerAgentImageBuilderImpl
implements DockerAgent.DockerImageBuilder {
    private final DockerClient client;

    @NotNull
    public CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig buildConfig) {
        Intrinsics.checkNotNullParameter((Object)buildConfig, (String)"buildConfig");
        CompletableFuture<BlockingQueue<byte[]>> result = new CompletableFuture<BlockingQueue<byte[]>>();
        try {
            BuildImageCmdWithCleanup cmdWithCleanup = BuildImageCmdWithCleanup.forConfig(this.client, buildConfig);
            cmdWithCleanup.asyncBuildImage(new BuildImageCallback(result));
        }
        catch (IOException e) {
            result.completeExceptionally(e);
        }
        catch (ApiTaskException e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    public DockerAgentImageBuilderImpl(@NotNull DockerClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/agent/DockerAgentImageBuilderImpl$BuildImageCallback;", "Lcom/intellij/docker/agent/progress/PromisingSerializedItemsCallback;", "Lcom/github/dockerjava/api/model/BuildResponseItem;", "promise", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/BlockingQueue;", "", "(Ljava/util/concurrent/CompletableFuture;)V", "wrapAgentItem", "Lcom/intellij/docker/agent/progress/DockerResponseItem$Builder;", "agentItem", "intellij.clouds.docker.agent.impl"})
    private static final class BuildImageCallback
    extends PromisingSerializedItemsCallback<BuildResponseItem> {
        @Override
        @NotNull
        protected DockerResponseItem.Builder wrapAgentItem(@NotNull BuildResponseItem agentItem) {
            Intrinsics.checkNotNullParameter((Object)agentItem, (String)"agentItem");
            return DockerResponseItem.Companion.fromAgentBuildItem(agentItem);
        }

        public BuildImageCallback(@NotNull CompletableFuture<BlockingQueue<byte[]>> promise) {
            Intrinsics.checkNotNullParameter(promise, (String)"promise");
            super(promise);
        }
    }
}

