/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdValueTransfers;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentApplicationBase;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImpl;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.DockerDefaultImageBuilder;
import com.intellij.docker.agent.DockerErrorUtilKt;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.DockerRunCliParser;
import com.intellij.docker.agent.VolumeMapper;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.DockerCallbackWithTtySink;
import com.intellij.docker.agent.progress.DockerImageBuilder;
import com.intellij.docker.agent.progress.DockerImageBuilderResult;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.TtySink;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerAgentDeploymentImpl
extends DockerAgentApplicationBase
implements DockerAgentDeployment {
    private static final String[] NO_TAGS = new String[0];
    private final DockerAgentDeploymentConfig myConfig;
    private final VolumeMapper myVolumeMapper;
    private Runnable myStopDeployFunction;
    private volatile String myImageId;
    private volatile String myImageTag;

    public DockerAgentDeploymentImpl(@NotNull DockerAgentContext context, @NotNull DockerAgentDeploymentConfig config, @NotNull DockerAgentPathMapper pathMapper) {
        if (context == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(0);
        }
        if (config == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(2);
        }
        super(context);
        this.myStopDeployFunction = () -> {};
        this.myConfig = config;
        context.getLogger().debug("DockerAgentDeploymentImpl:<init>: " + this);
        this.myVolumeMapper = new VolumeMapper(pathMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerAgentApplication.ContainerUpdateResult deploy(@Nls @NotNull String displayName, @Nullable DockerTerminalPipe deployPipe, @Nullable DockerImageBuilder imageBuilder) {
        if (displayName == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(3);
        }
        Object ttySink = deployPipe instanceof DockerTerminalPipe.WithTty ? ((DockerTerminalPipe.WithTty)deployPipe).asTtySink() : TtySink.NULL.INSTANCE;
        CloudAgentErrorHandler ttySinkBeforeReporting = arg_0 -> this.lambda$deploy$1((TtySink)ttySink, displayName, arg_0);
        try {
            ttySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.deploying", (Object[])new Object[]{displayName}), TtySink.Colors.BLUE);
            DockerAgentApplication.ContainerUpdateResult result = this.doDeploy(ttySinkBeforeReporting, (TtySink)ttySink, imageBuilder);
            if (result != null) {
                ttySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.deployed.successfully", (Object[])new Object[]{displayName}), TtySink.Colors.GREEN);
            }
            DockerAgentApplication.ContainerUpdateResult containerUpdateResult = result;
            return containerUpdateResult;
        }
        finally {
            if (deployPipe != null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)e);
                }
                deployPipe.close();
            }
        }
    }

    public void stopDeploy() {
        this.myStopDeployFunction.run();
    }

    private DockerAgentApplication.ContainerUpdateResult doDeploy(CloudAgentErrorHandler errorHandler, final TtySink ttySink, final DockerImageBuilder imageBuilder) {
        return (DockerAgentApplication.ContainerUpdateResult)new ApiTaskBase<DockerAgentApplication.ContainerUpdateResult>(errorHandler){

            @Override
            protected DockerAgentApplication.ContainerUpdateResult doPerform() throws IOException, ApiTaskException {
                DockerAgentSourceType sourceType = DockerAgentSourceType.valueOf((String)DockerAgentDeploymentImpl.this.myConfig.sourceType());
                return new SingleDeployTask(sourceType, ttySink, imageBuilder).deploy(ttySink != TtySink.NULL.INSTANCE);
            }
        }.perform();
    }

    @Override
    protected Bind[] prepareBinds(Bind[] binds) {
        return this.myVolumeMapper.expandPath(binds);
    }

    public String getContainerName() {
        return null;
    }

    public String getImageName() {
        throw new UnsupportedOperationException();
    }

    public String getImageId() {
        return this.myImageId;
    }

    public String[] getImageRepoTags() {
        String[] stringArray;
        if (this.myImageTag == null) {
            stringArray = NO_TAGS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.myImageTag;
        }
        return stringArray;
    }

    public String[] getContainerNames() {
        return null;
    }

    public String getImageParentId() {
        return null;
    }

    @Nullable
    public String getPresentableName() {
        return null;
    }

    @NotNull
    public String getUniqueName() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getAgentApplicationStatus() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "$" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    protected void setupContainerConfig(CreateContainerCmd target) {
        super.setupContainerConfig(target);
        if (this.myImageId != null) {
            target.withImage(this.myImageId);
        }
    }

    private static Predicate<Container> withContainerName(@NotNull String name) {
        if (name == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(4);
        }
        Object searchPattern = name.startsWith("/") ? name : "/" + name;
        return arg_0 -> DockerAgentDeploymentImpl.lambda$withContainerName$2((String)searchPattern, arg_0);
    }

    private static Predicate<Container> withLabel(@NotNull String label, @NotNull String value) {
        if (label == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(5);
        }
        if (value == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(6);
        }
        return container -> {
            Map allLabels = container.getLabels();
            return allLabels != null && value.equals(allLabels.get(label));
        };
    }

    private static Predicate<Image> idStartsWith(@NotNull String idOrTag) {
        if (idOrTag == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(7);
        }
        return img -> img.getId() != null && DockerAgentDeploymentImpl.trimShaPrefix(img.getId()).startsWith(DockerAgentDeploymentImpl.trimShaPrefix(idOrTag));
    }

    private static String trimShaPrefix(@NotNull String imageId) {
        if (imageId == null) {
            DockerAgentDeploymentImpl.$$$reportNull$$$0(8);
        }
        return imageId.startsWith("sha256:") ? imageId.substring("sha256:".length()) : imageId;
    }

    private static boolean safeValueOf(@Nullable Boolean bool) {
        return bool != null && bool != false;
    }

    private static /* synthetic */ boolean lambda$withContainerName$2(String searchPattern, Container container) {
        String[] containerNames = container.getNames();
        return containerNames != null && Arrays.asList(containerNames).contains(searchPattern);
    }

    private /* synthetic */ void lambda$deploy$1(@NonNls TtySink ttySink, String displayName, String error) {
        ttySink.coloredTtyPrint(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.failed.to.deploy", (Object[])new Object[]{displayName, error}), TtySink.Colors.RED);
        this.getErrorHandler().onError(error);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idOrTag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/agent/DockerAgentDeploymentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deploy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withContainerName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "withLabel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "idStartsWith";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "trimShaPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SingleDeployTask
    extends DeployTask {
        private CreateContainerCmdConfig myContainerCmdConfig;
        private final DockerAgentSourceType mySourceType;
        private final DockerImageBuilder myImageBuilder;

        SingleDeployTask(DockerAgentSourceType sourceType, TtySink ttySink, DockerImageBuilder imageBuilder) {
            super(ttySink);
            this.mySourceType = sourceType;
            this.myImageBuilder = Objects.requireNonNullElseGet(imageBuilder, () -> new DockerDefaultImageBuilder(this.myTtySink, DockerAgentDeploymentImpl.this.getClient(), DockerAgentDeploymentImpl.this.myConfig, DockerAgentDeploymentImpl.this.getAgent()));
        }

        @Override
        protected String doPrepareDeploy() throws ApiTaskException {
            CreateContainerCmdConfig cmdConfig = new CreateContainerCmdConfig();
            this.applyCustomRunCliOptions((CreateContainerCmd)cmdConfig);
            this.myContainerCmdConfig = cmdConfig;
            if (this.mySourceType == DockerAgentSourceType.IMAGE) {
                String[] allTags = DockerAgentDeploymentImpl.this.myConfig.getImageTags();
                if (allTags == null || allTags.length == 0) {
                    throw new ApiTaskException(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.either.image.tag.or.id.is.required", (Object[])new Object[0]));
                }
                DockerAgentDeploymentImpl.this.myImageId = this.pullImageIfNeeded(allTags[0]);
                CharSequence[] implicitlyRequired = DockerAgentDeploymentImpl.this.myConfig.getImplicitlyRequiredImages();
                if (implicitlyRequired != null) {
                    this.myTtySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.checking.implicitly.required.image.dependencies", (Object[])new Object[]{String.join((CharSequence)", ", implicitlyRequired)}), TtySink.Colors.BLUE);
                    for (CharSequence next : implicitlyRequired) {
                        this.pullImageIfNeeded((String)next);
                    }
                }
            } else {
                DockerAgentDeploymentImpl.this.myStopDeployFunction = () -> this.myImageBuilder.terminate();
                CompletableFuture promise = this.myImageBuilder.build();
                try {
                    DockerImageBuilderResult result = (DockerImageBuilderResult)promise.get();
                    DockerAgentDeploymentImpl.this.myImageId = result.getImageId();
                    DockerAgentDeploymentImpl.this.myImageTag = result.getImageTag();
                    if (DockerAgentDeploymentImpl.this.myImageId == null) {
                        throw new ApiTaskException(DockerAgentBundle.message((String)"DockerAgentApplication.cant.retrieve.image.id", (Object[])new Object[0]));
                    }
                }
                catch (InterruptedException e) {
                    throw new ApiTaskException(e.getMessage());
                }
                catch (ExecutionException e) {
                    String message = Optional.ofNullable(e.getCause()).map(DockerErrorUtilKt::dockerUserFriendlyMessage).orElseGet(e::getMessage);
                    throw new ApiTaskException(message);
                }
                catch (CancellationException e) {
                    throw new ApiTaskException(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.interrupted.by.user", (Object[])new Object[0]));
                }
            }
            return DockerAgentDeploymentImpl.this.myConfig.getContainerName();
        }

        private void applyCustomRunCliOptions(CreateContainerCmd cmd) throws ApiTaskException {
            String[] cliOptions = DockerAgentDeploymentImpl.this.myConfig.getCustomRunOptions();
            if (cliOptions == null) {
                return;
            }
            File context = DockerAgentDeploymentImpl.this.myConfig.getCustomContextFolder();
            if (context == null && DockerAgentDeploymentImpl.this.myConfig.getFile() != null) {
                context = DockerAgentDeploymentImpl.this.myConfig.getFile().getParentFile();
            }
            DockerRunCliParser parser = new DockerRunCliParser();
            if (context != null) {
                parser.setContextFolder(context);
            }
            parser.parse(cmd, cliOptions);
        }

        @Override
        protected CreateContainerCmdConfig getContainerCmdConfig() {
            return this.myContainerCmdConfig;
        }

        @Override
        protected DockerAgentContainerConfigImpl getPriorityConfig() {
            return new DockerAgentContainerConfigImpl((DockerAgentContainerConfig)DockerAgentDeploymentImpl.this.myConfig);
        }

        @Override
        protected void setContainerId(String containerId) {
            DockerAgentDeploymentImpl.this.setContainerId(containerId);
        }

        private String pullImageIfNeeded(@NotNull String imageTagOrId) throws ApiTaskException {
            DockerRepoTag tag;
            if (imageTagOrId == null) {
                SingleDeployTask.$$$reportNull$$$0(0);
            }
            Predicate<Image> filter = DockerAgentDeploymentImpl.idStartsWith(imageTagOrId);
            if (imageTagOrId.startsWith("sha256:")) {
                tag = null;
            } else {
                tag = DockerRepoTag.fromString((String)imageTagOrId);
                filter = filter.or(img -> tag.matchesOneOfRepoTags(img.getRepoTags()));
            }
            Image localImage = this.findImageLocally(filter);
            if (localImage != null) {
                return localImage.getId();
            }
            if (tag == null) {
                return imageTagOrId;
            }
            this.myTtySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.unable.to.find.image.locally", (Object[])new Object[]{tag.getFullyQualifiedReference()}), TtySink.Colors.BLUE);
            DockerAgentRepositoryConfig endpoint = tag.toAgentRepositoryConfig();
            class PullCallback
            extends DockerCallbackWithTtySink<PullResponseItem> {
                PullCallback(TtySink ttySink) {
                    super(ttySink);
                }

                public void onNext(PullResponseItem agentItem) {
                    DockerResponseItem.Impl wrappedItem = DockerResponseItem.fromAgentItem((ResponseItem)agentItem).build();
                    this.getTtyHandler().handleItem((DockerResponseItem)wrappedItem);
                }
            }
            try (PullCallback callback = new PullCallback(this.myTtySink);){
                DockerAgentImpl agentImpl = (DockerAgentImpl)DockerAgentDeploymentImpl.this.getAgent();
                agentImpl.preparePullImageCmd(endpoint).exec((ResultCallback)callback);
                callback.awaitCompletion();
            }
            catch (IOException | InterruptedException e) {
                throw new ApiTaskException(e);
            }
            localImage = this.findImageLocally(filter);
            if (localImage == null) {
                throw new ApiTaskException(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.no.such.image", (Object[])new Object[]{tag.getFullyQualifiedReference()}));
            }
            return localImage.getId();
        }

        private Image findImageLocally(Predicate<Image> filter) {
            List images = (List)DockerAgentDeploymentImpl.this.getClient().listImagesCmd().withShowAll(Boolean.TRUE).exec();
            if (images == null || images.isEmpty()) {
                return null;
            }
            return images.stream().filter(filter).findAny().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageTagOrId", "com/intellij/docker/agent/DockerAgentDeploymentImpl$SingleDeployTask", "pullImageIfNeeded"));
        }
    }

    private abstract class DeployTask {
        protected final TtySink myTtySink;

        DeployTask(TtySink ttySink) {
            this.myTtySink = ttySink;
        }

        public DockerAgentApplication.ContainerUpdateResult deploy(boolean withTty) throws IOException, ApiTaskException {
            String containerName = this.doPrepareDeploy();
            DockerAgentApplicationBase.ContainerUpdateResultImpl deployResult = new DockerAgentApplicationBase.ContainerUpdateResultImpl(DockerAgentDeploymentImpl.this.myImageId);
            if (DockerAgentDeploymentImpl.this.myConfig.isBuildImageOnly()) {
                return deployResult;
            }
            if (!DockerAgentDeploymentImpl.this.getAgent().isConnected()) {
                return deployResult;
            }
            @NonNls String oldContainerId = this.findPreviousContainer();
            if (oldContainerId != null) {
                this.myTtySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.existing.container.found.removing", (Object[])new Object[]{oldContainerId}), TtySink.Colors.BLUE);
                DockerAgentDeploymentImpl.this.getClient().removeContainerCmd(oldContainerId).withForce(Boolean.TRUE).exec();
                deployResult.setRemovedContainerId(oldContainerId);
            }
            this.myTtySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.creating.container", (Object[])new Object[0]), TtySink.Colors.BLUE);
            CreateContainerCmd createContainerCmd = DockerAgentDeploymentImpl.this.getClient().createContainerCmd(DockerAgentDeploymentImpl.this.myImageId);
            if (containerName != null) {
                createContainerCmd.withName(containerName);
            }
            CreateContainerCmdConfig cmdConfig = this.getContainerCmdConfig();
            CreateContainerCmdValueTransfers.createMergeForDeploy(binds -> DockerAgentDeploymentImpl.this.prepareBinds((Bind[])binds)).mergeWithPriority(this.getPriorityConfig(), cmdConfig, createContainerCmd);
            DockerAgentDeploymentImpl.this.setupContainerConfig(createContainerCmd);
            if (withTty) {
                createContainerCmd.withTty(Boolean.TRUE);
            }
            CreateContainerResponse createContainerResponse = createContainerCmd.exec();
            String containerId = createContainerResponse.getId();
            this.setContainerId(containerId);
            String[] warnings = createContainerResponse.getWarnings();
            if (warnings != null) {
                for (String warning : warnings) {
                    this.myTtySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.warning", (Object[])new Object[]{warning}), TtySink.Colors.ORANGE);
                }
            }
            if (DockerAgentDeploymentImpl.this.getAgent().isConnected() && !DockerAgentDeploymentImpl.this.myConfig.isCreateContainerOnly()) {
                boolean attach = DockerAgentDeploymentImpl.safeValueOf(cmdConfig.isAttachStdin()) && DockerAgentDeploymentImpl.safeValueOf(cmdConfig.isStdinOpen());
                this.startContainer(containerId, containerName);
            }
            return deployResult;
        }

        private void startContainer(@NotNull String containerId, @Nullable @NonNls String containerName) {
            InspectContainerResponse inspectResponse;
            if (containerId == null) {
                DeployTask.$$$reportNull$$$0(0);
            }
            this.myTtySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.container.id", (Object[])new Object[]{containerId}), TtySink.Colors.BLUE);
            if ((containerName == null || containerName.isEmpty()) && (inspectResponse = DockerAgentDeploymentImpl.this.getClient().inspectContainerCmd(containerId).exec()) != null && inspectResponse.getName() != null) {
                containerName = inspectResponse.getName();
            }
            @NonNls String containerMessageSuffix = this.safeQuote(containerName);
            this.myTtySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.container.name", (Object[])new Object[]{containerMessageSuffix}), TtySink.Colors.BLUE);
            this.myTtySink.coloredTtyPrintln(DockerAgentBundle.message((String)"DockerAgentDeploymentImpl.starting.container", (Object[])new Object[]{containerMessageSuffix}), TtySink.Colors.BLUE);
            StartContainerCmd startContainerCmd = DockerAgentDeploymentImpl.this.getClient().startContainerCmd(containerId);
            startContainerCmd.exec();
        }

        @Nullable
        private String findPreviousContainer() {
            Predicate condition = null;
            String containerName = DockerAgentDeploymentImpl.this.myConfig.getContainerName();
            if (containerName != null && containerName.length() > 0) {
                condition = DockerAgentDeploymentImpl.withContainerName(containerName);
            } else if (DockerAgentDeploymentImpl.this.myConfig.getLabels() != null) {
                condition = Stream.of(DockerAgentDeploymentImpl.this.myConfig.getLabels()).filter(l -> "com.intellij.docker.source.run.configuration".equals(l.getKey())).findAny().map(label -> DockerAgentDeploymentImpl.withLabel("com.intellij.docker.source.run.configuration", label.getValue())).orElse(null);
            }
            if (condition == null) {
                return null;
            }
            return ((List)DockerAgentDeploymentImpl.this.getClient().listContainersCmd().withShowAll(Boolean.TRUE).exec()).stream().filter(condition).findAny().map(Container::getId).orElse(null);
        }

        protected abstract void setContainerId(String var1);

        protected abstract String doPrepareDeploy() throws IOException, ApiTaskException;

        protected abstract CreateContainerCmdConfig getContainerCmdConfig();

        protected abstract DockerAgentContainerConfigImpl getPriorityConfig();

        private String safeQuote(String text) {
            return text == null ? "" : "'" + text + "'";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerId", "com/intellij/docker/agent/DockerAgentDeploymentImpl$DeployTask", "startContainer"));
        }
    }
}

