/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.HealthState;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import java.util.Optional;

public class DockerAgentContainerInspectionImpl
extends DockerAgentContainerConfigImpl
implements DockerAgentContainerInspection {
    private final InspectContainerResponse.ContainerState myContainerState;

    public DockerAgentContainerInspectionImpl(CreateContainerCmd cmd, InspectContainerResponse.ContainerState state) {
        super(cmd);
        this.myContainerState = state;
    }

    public boolean isRunning() {
        return DockerAgentContainerInspectionImpl.valueOrFalse(this.myContainerState.getRunning());
    }

    public String getHealthStatus() {
        return Optional.ofNullable(this.myContainerState.getHealth()).map(HealthState::getStatus).orElse(null);
    }

    private static boolean valueOrFalse(Boolean booleanFromApi) {
        return booleanFromApi != null && booleanFromApi != false;
    }
}

