/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.PushImageCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.TagImageCmd;
import com.github.dockerjava.api.command.TopContainerResponse;
import com.github.dockerjava.api.command.WaitContainerResultCallback;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import com.intellij.docker.agent.CreateContainerCmdInspection;
import com.intellij.docker.agent.CreateContainerCmdValueTransfers;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentContainerConfigImpl;
import com.intellij.docker.agent.DockerAgentContainerImpl;
import com.intellij.docker.agent.DockerAgentContainerInspectionImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.PushImageResultCallbackImpl;
import com.intellij.docker.agent.pipe.DockerAttachPipe;
import com.intellij.docker.agent.pipe.DockerExecPipe;
import com.intellij.docker.agent.pipe.DockerLogPipe;
import com.intellij.docker.agent.pipe.DockerLogUtilsKt;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.settings.DockerSystemInfo;
import com.intellij.docker.agent.terminal.pipe.DockerConsolePipe;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DockerAgentApplicationBase
implements DockerAgentApplication {
    static final Logger LOG = Logger.getLogger((String)"#com.intellij.docker.DockerServerRuntimeInstance");
    private final DockerAgentContext myContext;
    private static final Map<String, ZonedDateTime> ourContainerLastMessageTimestampMap = new LinkedHashMap<String, ZonedDateTime>(10, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ZonedDateTime> eldest) {
            return this.size() > 10;
        }
    };
    private String myContainerId;
    private Map<String, String> myContainerLabels;

    public DockerAgentApplicationBase(DockerAgentContext context) {
        this.myContext = context;
    }

    protected final DockerClient getClient() {
        return this.myContext.getClient();
    }

    protected final ObjectMapper getObjectMapper() {
        return this.myContext.getObjectMapper();
    }

    protected final CloudAgentErrorHandler getErrorHandler() {
        return this.myContext.getErrorHandler();
    }

    protected final CloudAgentLogger getLogger() {
        return this.myContext.getLogger();
    }

    protected final DockerAgent getAgent() {
        return this.myContext.getAgent();
    }

    public String getContainerId() {
        return this.myContainerId;
    }

    protected void setContainerId(String containerId) {
        this.myContainerId = containerId;
    }

    public final Map<String, String> getContainerLabels() {
        return this.myContainerLabels;
    }

    protected void setContainerLabels(@Nullable Map<String, String> containerLabels) {
        this.myContainerLabels = containerLabels == null ? null : new HashMap<String, String>(containerLabels);
    }

    public void startContainer() {
        new StateChangeTaskBase(this.getErrorHandler()){

            @Override
            protected void doPerformStateChange() throws IOException, ApiTaskException {
                ourContainerLastMessageTimestampMap.put(DockerAgentApplicationBase.this.getContainerId(), DockerLogUtilsKt.lastMessageTimestamp(DockerAgentApplicationBase.this.getClient(), DockerAgentApplicationBase.this.getContainerId()));
                DockerAgentApplicationBase.this.getClient().startContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void stopContainer() {
        this.stopContainerImmediate(this.getErrorHandler());
    }

    public void stopContainerImmediate(CloudAgentErrorHandler errorHandler) {
        new StateChangeTaskBase(errorHandler){

            @Override
            protected void doPerformStateChange() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().stopContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void killContainer(CloudAgentErrorHandler errorHandler) {
        new StateChangeTaskBase(errorHandler){

            @Override
            protected void doPerformStateChange() {
                DockerAgentApplicationBase.this.getClient().killContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
            }
        }.perform();
    }

    public void deleteContainer() {
        new ApiTaskBase<Void>(this.getErrorHandler()){

            @Override
            protected Void doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public void deleteContainerWithVolumes() {
        new ApiTaskBase<Void>(this.getErrorHandler()){

            @Override
            protected Void doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withForce(Boolean.valueOf(true)).withRemoveVolumes(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public void deleteImage() {
        new ApiTaskBase<Void>(this.getErrorHandler()){

            @Override
            protected Void doPerform() throws IOException, ApiTaskException {
                DockerAgentApplicationBase.this.getClient().removeImageCmd(DockerAgentApplicationBase.this.getImageId()).withForce(Boolean.valueOf(true)).exec();
                return null;
            }
        }.perform();
    }

    public String createContainer() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                CreateContainerCmd createContainerCmd = DockerAgentApplicationBase.this.getClient().createContainerCmd(DockerAgentApplicationBase.this.getImageId());
                CreateContainerResponse createContainerResponse = createContainerCmd.exec();
                String containerId = createContainerResponse.getId();
                StartContainerCmd startContainerCmd = DockerAgentApplicationBase.this.getClient().startContainerCmd(containerId);
                startContainerCmd.exec();
                return containerId;
            }
        }.perform();
    }

    public String getWebUrl() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DockerConsolePipe> showLog() {
        return (CompletableFuture)new ApiTaskBase<CompletableFuture<DockerConsolePipe>>(this.getErrorHandler()){

            @Override
            protected CompletableFuture<DockerConsolePipe> doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.doShowLog(DockerAgentApplicationBase.this.getContainerId());
            }
        }.perform();
    }

    protected CompletableFuture<DockerConsolePipe> doShowLog(String containerId) throws IOException, ApiTaskException {
        if (!this.myContext.getAgent().isConnected()) {
            return null;
        }
        return new DockerLogPipe(ourContainerLastMessageTimestampMap.get(containerId), this.myContext, containerId).invoke();
    }

    public DockerSystemInfo getSystemInfo() {
        if (this.getImageId() == null) {
            return null;
        }
        return (DockerSystemInfo)new ApiTaskBase<DockerSystemInfo>(this.getErrorHandler()){

            @Override
            protected DockerSystemInfo doPerform() throws IOException, ApiTaskException, InterruptedException {
                InspectImageResponse inspect = DockerAgentApplicationBase.this.getClient().inspectImageCmd(DockerAgentApplicationBase.this.getImageId()).exec();
                return new DockerSystemInfo.Impl(inspect.getOs(), inspect.getOsVersion(), inspect.getArch());
            }
        }.perform();
    }

    public String computeInspectJson() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                InspectContainerResponse response;
                if (DockerAgentApplicationBase.this.getContainerId() != null) {
                    response = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                } else if (DockerAgentApplicationBase.this.getImageId() != null) {
                    response = DockerAgentApplicationBase.this.getClient().inspectImageCmd(DockerAgentApplicationBase.this.getImageId()).exec();
                } else {
                    throw new ApiTaskException((Exception)new IllegalStateException("Can't inspect, neither image nor container"));
                }
                ObjectMapper objectMapper2 = DockerAgentApplicationBase.this.getObjectMapper();
                String responseJson = objectMapper2.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
                assert (responseJson != null);
                return responseJson;
            }
        }.perform();
    }

    public DockerAgentContainerInspection inspect() {
        return (DockerAgentContainerInspection)new ApiTaskBase<DockerAgentContainerInspection>(this.getErrorHandler()){

            @Override
            protected DockerAgentContainerInspection doPerform() throws IOException, ApiTaskException {
                InspectContainerResponse inspectResponse = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmdConfig cmdConfig = new CreateContainerCmdConfig();
                String containerName = inspectResponse.getName();
                if (containerName != null) {
                    cmdConfig.withName(containerName);
                }
                CreateContainerCmdValueTransfers.createContainerCmdValueTransfer(binds -> DockerAgentApplicationBase.this.prepareBinds((Bind[])binds)).transferFromTo(inspection, (CreateContainerCmd)cmdConfig);
                return new DockerAgentContainerInspectionImpl((CreateContainerCmd)cmdConfig, inspectResponse.getState());
            }
        }.perform();
    }

    public String computeProcessesJson() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                TopContainerResponse response = DockerAgentApplicationBase.this.getClient().topContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                ObjectMapper objectMapper2 = DockerAgentApplicationBase.this.getObjectMapper();
                return objectMapper2.writerWithDefaultPrettyPrinter().writeValueAsString((Object)response);
            }
        }.perform();
    }

    public CompletableFuture<DockerTerminalPipe> attach(final boolean allowSystemPrint) {
        return (CompletableFuture)new ApiTaskBase<CompletableFuture<DockerTerminalPipe>>(this.getErrorHandler()){

            @Override
            protected CompletableFuture<DockerTerminalPipe> doPerform() throws IOException, ApiTaskException, InterruptedException {
                return new DockerAttachPipe(allowSystemPrint, DockerAgentApplicationBase.this.getContainerId(), DockerAgentApplicationBase.this.myContext).start();
            }
        }.perform();
    }

    public CompletableFuture<DockerTerminalPipe> exec(final String[] command, final boolean allowSystemPrint) {
        return (CompletableFuture)new ApiTaskBase<CompletableFuture<DockerTerminalPipe>>(this.getErrorHandler()){

            @Override
            protected CompletableFuture<DockerTerminalPipe> doPerform() throws IOException, ApiTaskException, InterruptedException {
                return new DockerExecPipe(allowSystemPrint, DockerAgentApplicationBase.this.createExec(true, command), DockerAgentApplicationBase.this.myContext).start();
            }
        }.perform();
    }

    public CompletableFuture<byte[]> captureExecOutput(String[] command, boolean includeErr) {
        String newExecId = this.createExec(false, command);
        final CompletableFuture<byte[]> promise = new CompletableFuture<byte[]>();
        try (ExecStartCmd execStartCmd = this.myContext.getClient().execStartCmd(newExecId);){
            final ByteArrayOutputStream capturedOut = new ByteArrayOutputStream();
            ByteArrayOutputStream capturedErr = includeErr ? capturedOut : new ByteArrayOutputStream();
            execStartCmd.withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback(capturedOut, capturedErr){

                public void onError(Throwable throwable) {
                    promise.completeExceptionally(throwable);
                    super.onError(throwable);
                }

                public void onComplete() {
                    if (!promise.isDone()) {
                        promise.complete(capturedOut.toByteArray());
                    }
                    super.onComplete();
                }
            });
        }
        catch (DockerException e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }

    public OngoingProcess pushImage(final DockerAgentRepositoryConfig repositoryConfig, final DockerAgentProgressCallback progressCallback) {
        return (OngoingProcess)new ApiTaskBase<OngoingProcess>(this.getErrorHandler()){

            @Override
            protected OngoingProcess doPerform() throws IOException, ApiTaskException {
                String repository = repositoryConfig.getQualifiedRepository();
                String tag = repositoryConfig.getTag();
                if (!this.hasImageTag()) {
                    TagImageCmd tagImageCmd = DockerAgentApplicationBase.this.getClient().tagImageCmd(DockerAgentApplicationBase.this.getImageId(), repository, tag);
                    tagImageCmd.exec();
                }
                PushImageCmd pushImageCmd = DockerAgentApplicationBase.this.getClient().pushImageCmd(repository);
                DockerAuthConfig customAuthConfig = repositoryConfig.getAuthConfig();
                if (customAuthConfig != null) {
                    pushImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(customAuthConfig));
                }
                if (tag != null) {
                    pushImageCmd.withTag(tag);
                }
                return (OngoingProcess)pushImageCmd.exec((ResultCallback)new PushImageResultCallbackImpl(progressCallback, DockerAgentApplicationBase.this.getLogger(), repositoryConfig.getQualifiedTag()));
            }

            private boolean hasImageTag() {
                return Arrays.asList(DockerAgentApplicationBase.this.getImageRepoTags()).contains(repositoryConfig.getQualifiedTag());
            }
        }.perform();
    }

    public DockerAgentApplication.ContainerUpdateResult updateContainer(final DockerAgentContainerConfig config) {
        return (DockerAgentApplication.ContainerUpdateResult)new ApiTaskBase<DockerAgentApplication.ContainerUpdateResult>(this.getErrorHandler()){

            @Override
            protected DockerAgentApplication.ContainerUpdateResult doPerform() throws IOException, ApiTaskException {
                DockerAgentApplication newAgentApplication;
                InspectContainerResponse inspectResponse = DockerAgentApplicationBase.this.getClient().inspectContainerCmd(DockerAgentApplicationBase.this.getContainerId()).exec();
                ContainerUpdateResultImpl result = new ContainerUpdateResultImpl(DockerAgentApplicationBase.this.getImageId());
                String oldContainerId = DockerAgentApplicationBase.this.getContainerId();
                result.setRemovedContainerId(oldContainerId);
                DockerAgentApplicationBase.this.getClient().removeContainerCmd(oldContainerId).withForce(Boolean.TRUE).exec();
                CreateContainerCmdInspection inspection = new CreateContainerCmdInspection(inspectResponse);
                CreateContainerCmd createContainerCmd = DockerAgentApplicationBase.this.getClient().createContainerCmd(DockerAgentApplicationBase.this.getImageId());
                String containerName = inspectResponse.getName();
                if (containerName != null) {
                    createContainerCmd.withName(containerName);
                }
                CreateContainerCmdValueTransfers.createMergeForUpdate(binds -> DockerAgentApplicationBase.this.prepareBinds((Bind[])binds)).mergeWithPriority(new DockerAgentContainerConfigImpl(config), inspection, createContainerCmd);
                DockerAgentApplicationBase.this.setupContainerConfig(createContainerCmd);
                this.removeUnboundExposedPorts(createContainerCmd);
                CreateContainerResponse createContainerResponse = createContainerCmd.exec();
                String containerId = createContainerResponse.getId();
                DockerAgentApplicationBase.this.setContainerId(containerId);
                if (!DockerUtil.isStoppedStatus((String)DockerAgentApplicationBase.this.getAgentApplicationStatus())) {
                    DockerAgentApplicationBase.this.getClient().startContainerCmd(containerId).exec();
                }
                if ((newAgentApplication = DockerAgentApplicationBase.this.findContainer(containerId)) != null) {
                    result.setNewAgentApplication(newAgentApplication);
                }
                return result;
            }

            private void removeUnboundExposedPorts(CreateContainerCmd createContainerCmd) {
                Ports oldPorts = createContainerCmd.getHostConfig().getPortBindings();
                Ports newPorts = new Ports();
                for (Map.Entry next : oldPorts.getBindings().entrySet()) {
                    if (next.getValue() == null) continue;
                    for (Ports.Binding nextBinding : (Ports.Binding[])next.getValue()) {
                        newPorts.bind((ExposedPort)next.getKey(), nextBinding);
                    }
                }
                createContainerCmd.getHostConfig().withPortBindings(newPorts);
            }
        }.perform();
    }

    protected void setupContainerConfig(CreateContainerCmd target) {
        if (target.getHostConfig() != null && target.getHostConfig().getOomScoreAdj() != null) {
            target.getHostConfig().withOomScoreAdj(null);
        }
        DockerAgentApplicationBase.exposeAllBoundPorts(target);
    }

    protected Bind[] prepareBinds(Bind[] binds) {
        return binds;
    }

    public String getImageUser() {
        return (String)new ApiTaskBase<String>(this.getErrorHandler()){

            @Override
            protected String doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().inspectImageCmd(DockerAgentApplicationBase.this.getImageId()).exec().getConfig().getUser();
            }
        }.perform();
    }

    public InputStream copyArchiveFromContainer(final String sourceDirPath) {
        return (InputStream)new ApiTaskBase<InputStream>(this.getErrorHandler()){

            @Override
            protected InputStream doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().copyArchiveFromContainerCmd(DockerAgentApplicationBase.this.getContainerId(), sourceDirPath).exec();
            }
        }.perform();
    }

    public void copyArchiveToContainer(final String remoteDirPath, final String localDirPath) {
        new ApiTaskBase<Void>(this.getErrorHandler()){

            @Override
            protected Void doPerform() throws IOException, ApiTaskException {
                return DockerAgentApplicationBase.this.getClient().copyArchiveToContainerCmd(DockerAgentApplicationBase.this.getContainerId()).withHostResource(localDirPath).withRemotePath(remoteDirPath).exec();
            }
        }.perform();
    }

    public int waitForExit() {
        return this.waitForExitImmediate(this.getErrorHandler());
    }

    protected final DockerAgentApplication findContainer(@NotNull String containerId) {
        List containers;
        if (containerId == null) {
            DockerAgentApplicationBase.$$$reportNull$$$0(0);
        }
        return (containers = (List)this.getClient().listContainersCmd().withIdFilter(Collections.singletonList(containerId)).exec()).isEmpty() ? null : new DockerAgentContainerImpl(this.myContext, (Container)containers.get(0));
    }

    public int waitForExitImmediate(CloudAgentErrorHandler errorHandler) {
        int UNKNOWN = -1;
        Integer result = (Integer)new ApiTaskBase<Integer>(errorHandler){

            @Override
            protected Integer doPerform() throws IOException, ApiTaskException {
                try {
                    return ((WaitContainerResultCallback)DockerAgentApplicationBase.this.getClient().waitContainerCmd(DockerAgentApplicationBase.this.myContainerId).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
                }
                catch (NotFoundException e) {
                    return -1;
                }
            }
        }.perform();
        return result == null ? -1 : result;
    }

    protected static void exposeAllBoundPorts(CreateContainerCmd cmd) {
        ExposedPort[] allExposed = Optional.ofNullable(cmd.getExposedPorts()).orElseGet(() -> new ExposedPort[0]);
        Map exposedByPort = Stream.of(allExposed).collect(Collectors.toMap(p -> p.getPort(), Function.identity(), (oldValue, newValue) -> newValue, LinkedHashMap::new));
        List notExposedWithBindings = Optional.ofNullable(cmd.getHostConfig()).map(HostConfig::getPortBindings).map(Ports::getBindings).orElse(Collections.emptyMap()).keySet().stream().filter(ep -> !exposedByPort.containsKey(ep.getPort())).collect(Collectors.toList());
        if (notExposedWithBindings.isEmpty()) {
            return;
        }
        ArrayList<Object> fixedExposed = new ArrayList<Object>();
        fixedExposed.addAll(exposedByPort.values());
        fixedExposed.addAll(notExposedWithBindings);
        cmd.withExposedPorts(fixedExposed);
    }

    private String createExec(boolean withStdIn, String[] command) {
        try (ExecCreateCmd execCreateCmd = this.myContext.getClient().execCreateCmd(this.getContainerId());){
            execCreateCmd.withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(withStdIn)).withTty(Boolean.valueOf(withStdIn)).withCmd(command);
            String string = ((ExecCreateCmdResponse)execCreateCmd.exec()).getId();
            return string;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerId", "com/intellij/docker/agent/DockerAgentApplicationBase", "findContainer"));
    }

    protected static class ContainerUpdateResultImpl
    implements DockerAgentApplication.ContainerUpdateResult {
        private final String myImageId;
        private String myNewId;
        private String myOldId;
        private DockerAgentApplication myNewAgentApplication;

        ContainerUpdateResultImpl(@NotNull String imageId) {
            if (imageId == null) {
                ContainerUpdateResultImpl.$$$reportNull$$$0(0);
            }
            this.myImageId = imageId;
        }

        void setNewAgentApplication(@NotNull DockerAgentApplication newContainer) {
            if (newContainer == null) {
                ContainerUpdateResultImpl.$$$reportNull$$$0(1);
            }
            this.myNewAgentApplication = newContainer;
            this.myNewId = newContainer.getContainerId();
        }

        void setRemovedContainerId(@NotNull String oldContainerId) {
            if (oldContainerId == null) {
                ContainerUpdateResultImpl.$$$reportNull$$$0(2);
            }
            this.myOldId = oldContainerId;
        }

        @NotNull
        public String getImageId() {
            String string = this.myImageId;
            if (string == null) {
                ContainerUpdateResultImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public String getCreatedContainerId() {
            return this.myNewId;
        }

        @Nullable
        public DockerAgentApplication getCreatedAgentApplication() {
            return this.myNewAgentApplication;
        }

        @Nullable
        public String getRemovedContainerId() {
            return this.myOldId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newContainer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldContainerId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/DockerAgentApplicationBase$ContainerUpdateResultImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/DockerAgentApplicationBase$ContainerUpdateResultImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImageId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewAgentApplication";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setRemovedContainerId";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class StateChangeTaskBase
    extends ApiTaskBase<Void> {
        StateChangeTaskBase(CloudAgentErrorHandler errorHandler) {
            super(errorHandler);
        }

        @Override
        protected Void doPerform() throws IOException, ApiTaskException {
            try {
                this.doPerformStateChange();
            }
            catch (NotModifiedException e) {
                String message = e.getMessage();
                throw new NotModifiedException(message == null ? "Possibly, container is in the target state already" : message, (Throwable)e);
            }
            return null;
        }

        protected abstract void doPerformStateChange() throws IOException, ApiTaskException;
    }
}

