/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.exception.DockerException;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.DockerErrorUtilKt;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class ApiTask<T> {
    private static final Logger LOG = Logger.getLogger(ApiTask.class);

    public T perform() {
        try {
            return this.doPerform();
        }
        catch (IOException | Error e) {
            this.logException(e, (Priority)Level.ERROR);
            this.onError(e);
        }
        catch (DockerException ex) {
            this.logException(ex, (Priority)Level.DEBUG);
            this.onError(DockerErrorUtilKt.dockerUserFriendlyMessage((Throwable)ex));
        }
        catch (InterruptedException | RuntimeException ex) {
            this.logException(ex, (Priority)Level.DEBUG);
            this.onError(ex);
        }
        catch (ApiTaskException ex) {
            this.logException(ex, (Priority)Level.DEBUG);
            this.onError(ex.getMessage());
        }
        return null;
    }

    private void onError(Throwable e) {
        StringBuilder errorBuilder = new StringBuilder(e.toString());
        Throwable cause = e.getCause();
        if (cause != null) {
            errorBuilder.append("<br/>caused by: ").append(cause.toString());
        }
        this.onError(errorBuilder.toString());
    }

    protected void logException(Throwable e, Priority level) {
        LOG.log(level, (Object)this, e);
    }

    protected abstract T doPerform() throws IOException, ApiTaskException, InterruptedException;

    protected abstract void onError(String var1);
}

