/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeSubstitutor {
    public static final JSTypeSubstitutor EMPTY = new JSTypeSubstitutor(){

        @Override
        public void put(@Nullable JSTypeGenericId id, @Nullable JSType type) {
            throw new RuntimeException("Empty substitutor must be immutable");
        }
    };
    @NotNull
    private final Map<JSTypeGenericId, JSType> myMap;

    public JSTypeSubstitutor() {
        this.myMap = new HashMap<JSTypeGenericId, JSType>();
    }

    public JSTypeSubstitutor(@NotNull JSTypeSubstitutor substitutor) {
        if (substitutor == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(0);
        }
        this.myMap = new HashMap<JSTypeGenericId, JSType>();
        this.myMap.putAll(substitutor.myMap);
    }

    public JSTypeSubstitutor(@NotNull Map<String, JSType> map) {
        if (map == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(1);
        }
        this.myMap = new HashMap<JSTypeGenericId, JSType>();
        map.forEach(this::putForJSGenerics);
    }

    public boolean containsId(@NotNull JSTypeGenericId id) {
        if (id == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(2);
        }
        return this.myMap.containsKey(id);
    }

    public void put(@Nullable JSTypeGenericId key, JSType value) {
        if (key == null) {
            return;
        }
        this.myMap.put(key, value);
    }

    public final void putForJSGenerics(@Nullable String key, JSType value) {
        if (key == null) {
            return;
        }
        this.put(new StringGenericId(key), value);
    }

    public final void putAll(@NotNull JSTypeSubstitutor first) {
        if (first == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(3);
        }
        this.putAll(first, (Condition<? super JSType>)Conditions.alwaysTrue());
    }

    public final void putAll(@NotNull JSTypeSubstitutor first, Condition<? super JSType> include) {
        if (first == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(4);
        }
        first.myMap.forEach((key, value) -> {
            if (include.value(value)) {
                this.put((JSTypeGenericId)key, (JSType)value);
            }
        });
    }

    @Nullable
    public final JSType getForJSGenerics(@Nullable String key) {
        return key == null ? null : this.get(new StringGenericId(key));
    }

    @Nullable
    public JSType get(@Nullable JSTypeGenericId key) {
        return key == null ? null : this.myMap.get(key);
    }

    @NotNull
    public final JSTypeSubstitutor transformValues(@NotNull Function<? super JSType, ? extends JSType> transformation) {
        if (transformation == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(5);
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        boolean hasNewOuters = false;
        for (Map.Entry<JSTypeGenericId, JSType> entry : this.myMap.entrySet()) {
            JSType oldOuterArgType = entry.getValue();
            JSType newOuterArgType = (JSType)transformation.fun((Object)oldOuterArgType);
            if (newOuterArgType != oldOuterArgType) {
                hasNewOuters = true;
            }
            substitutor.put(entry.getKey(), newOuterArgType);
        }
        JSTypeSubstitutor jSTypeSubstitutor = hasNewOuters ? substitutor : this;
        if (jSTypeSubstitutor == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(6);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor combine(@Nullable JSTypeSubstitutor second) {
        return JSTypeSubstitutor.combine(this, second);
    }

    @NotNull
    public static JSTypeSubstitutor combine(@Nullable JSTypeSubstitutor first, @Nullable JSTypeSubstitutor second) {
        first = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)first, (Object)EMPTY);
        second = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)second, (Object)EMPTY);
        if (first.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = second;
            if (jSTypeSubstitutor == null) {
                JSTypeSubstitutor.$$$reportNull$$$0(7);
            }
            return jSTypeSubstitutor;
        }
        if (second.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = first;
            if (jSTypeSubstitutor == null) {
                JSTypeSubstitutor.$$$reportNull$$$0(8);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor result = new JSTypeSubstitutor();
        result.putAll(first);
        result.putAll(second);
        JSTypeSubstitutor jSTypeSubstitutor = result;
        if (jSTypeSubstitutor == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(9);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor combineWithApplying(@Nullable JSTypeSubstitutor toApply, @Nullable JSTypeSubstitutor substitutor, @NotNull BiFunction<? super JSType, ? super JSTypeSubstitutor, ? extends JSType> applier) {
        if (applier == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(10);
        }
        if (toApply == null || toApply.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)substitutor, (Object)EMPTY);
            if (jSTypeSubstitutor == null) {
                JSTypeSubstitutor.$$$reportNull$$$0(11);
            }
            return jSTypeSubstitutor;
        }
        if (substitutor == null || substitutor.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)toApply, (Object)EMPTY);
            if (jSTypeSubstitutor == null) {
                JSTypeSubstitutor.$$$reportNull$$$0(12);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor combinedSubstitutor = new JSTypeSubstitutor();
        for (Map.Entry<JSTypeGenericId, JSType> entry : substitutor.myMap.entrySet()) {
            combinedSubstitutor.put(entry.getKey(), applier.apply(entry.getValue(), toApply));
        }
        JSTypeSubstitutor jSTypeSubstitutor = combinedSubstitutor;
        if (jSTypeSubstitutor == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(13);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public Collection<JSTypeGenericId> keys() {
        Set<JSTypeGenericId> set = this.myMap.keySet();
        if (set == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    public Collection<JSType> types() {
        Collection<JSType> collection = this.myMap.values();
        if (collection == null) {
            JSTypeSubstitutor.$$$reportNull$$$0(15);
        }
        return collection;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeSubstitutor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeSubstitutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "transformValues";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "combineWithApplying";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsId";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "transformValues";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "combineWithApplying";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class StringGenericId
    implements JSTypeGenericId {
        private final String myText;

        public StringGenericId(@NotNull String text) {
            if (text == null) {
                StringGenericId.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringGenericId id = (StringGenericId)o;
            return Objects.equals(this.myText, id.myText);
        }

        @Override
        public int hashCode() {
            return this.myText.hashCode();
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myText;
            if (string == null) {
                StringGenericId.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return this.getClass().getName() + "<" + this.myText + ">";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeSubstitutor$StringGenericId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeSubstitutor$StringGenericId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface JSTypeGenericId {
        public boolean equals(Object var1);

        public int hashCode();

        @NotNull
        public String getName();
    }
}

