/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils.errors;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J#\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/performancePlugin/utils/errors/ToDirectoryWritingErrorCollector;", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "presentableName", "", "directory", "Ljava/nio/file/Path;", "limitOfErrors", "", "(Ljava/lang/String;Ljava/nio/file/Path;I)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "nextErrorId", "Ljava/util/concurrent/atomic/AtomicInteger;", "numberOfErrors", "getNumberOfErrors", "()I", "addError", "", "error", "", "runCatchingError", "T", "computation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.performanceTesting"})
public final class ToDirectoryWritingErrorCollector
implements ErrorCollector {
    private final Logger logger;
    private final AtomicInteger nextErrorId;
    private final String presentableName;
    private final Path directory;
    private final int limitOfErrors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(@NotNull Throwable error) {
        Path errorHome;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        int errorId = this.nextErrorId.incrementAndGet();
        if (errorId > this.limitOfErrors) {
            throw (Throwable)new RuntimeException("Too many errors reported for " + this.presentableName);
        }
        Path path = errorHome = this.directory.resolve("error-" + errorId);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"errorHome");
        PathKt.createDirectories((Path)path);
        StringBuilder stringBuilder = new StringBuilder().append("Error #").append(errorId).append(" has been collected. Details will be saved to ").append(errorHome).append(". Message: ");
        String string = error.getMessage();
        if (string == null) {
            string = error.getClass().getName();
        }
        this.logger.warn(stringBuilder.append(string).toString());
        Path path2 = errorHome.resolve("stacktrace.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"errorHome.resolve(\"stacktrace.txt\")");
        String string2 = ExceptionUtil.getThrowableText((Throwable)error);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ExceptionUtil.getThrowableText(error)");
        PathKt.write$default((Path)path2, (CharSequence)string2, null, (boolean)false, (int)6, null);
        if (error instanceof ExceptionWithAttachments) {
            Attachment[] attachmentArray = ((ExceptionWithAttachments)error).getAttachments();
            int n = attachmentArray.length;
            for (int i = 0; i < n; ++i) {
                Path attachmentPath;
                Attachment attachment;
                Attachment attachment2 = attachment = attachmentArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)attachment2, (String)"attachment");
                Path path3 = attachmentPath = errorHome.resolve(attachment2.getPath());
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"attachmentPath");
                Closeable closeable = PathKt.outputStream((Path)path3);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    OutputStream os = (OutputStream)closeable;
                    boolean bl3 = false;
                    InputStream inputStream = attachment.openContentStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"attachment.openContentStream()");
                    long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)os, (int)0, (int)2, null);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
    }

    @Override
    @Nullable
    public <T> T runCatchingError(@NotNull Function0<? extends T> computation) {
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter(computation, (String)"computation");
        boolean bl3 = false;
        try {
            object = Result.Companion;
            Object object2 = computation.invoke();
            bl2 = false;
            object = Result.constructor-impl((Object)object2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object3 = object;
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl6 = false;
            Throwable it = throwable3;
            boolean bl7 = false;
            this.addError(it);
        }
        bl4 = false;
        return (T)(Result.isFailure-impl((Object)object3) ? null : object3);
    }

    @Override
    public int getNumberOfErrors() {
        return this.nextErrorId.get();
    }

    public ToDirectoryWritingErrorCollector(@NotNull String presentableName, @NotNull Path directory, int limitOfErrors) {
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.presentableName = presentableName;
        this.directory = directory;
        this.limitOfErrors = limitOfErrors;
        Logger logger = Logger.getInstance((String)("error-collector-" + this.presentableName));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"erro\u2026lector-$presentableName\")");
        this.logger = logger;
        this.nextErrorId = new AtomicInteger();
    }
}

