/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.agent;

import com.jetbrains.performancePlugin.tracing.agent.AgentLogger;
import com.jetbrains.performancePlugin.tracing.agent.Config;
import com.jetbrains.performancePlugin.tracing.agent.TracingTransformer;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;

public final class TracingAgent {
    static final String tracerClassName = "com.intellij.diagnostic.tracing.MethodTracer";

    private static Config readConfig(String arg) {
        throw new RuntimeException("Implement 'Tracing.readConfig' to be able to use it as a regular java agent");
    }

    public static void premain(String arg, Instrumentation inst) {
        Config config = TracingAgent.readConfig(arg);
        TracingAgent.instrument(inst, config, AgentLogger.consoleLogger());
    }

    public static void instrument(Instrumentation inst, Config config, AgentLogger logger) {
        inst.addTransformer(new TracingTransformer(config, logger), true);
        Class[] classes = (Class[])Arrays.stream(inst.getAllLoadedClasses()).filter(c -> !c.isSynthetic() && inst.isModifiableClass((Class<?>)c) && TracingAgent.mayMatch(c, config)).toArray(Class[]::new);
        try {
            inst.retransformClasses(classes);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    private static boolean mayMatch(Class<?> clazz, Config config) {
        boolean classMatch = config.shouldTransform(clazz.getName());
        return classMatch && TracingAgent.hasMethodMatch(clazz, config);
    }

    private static boolean hasMethodMatch(Class<?> clazz, Config config) {
        return Arrays.stream(clazz.getDeclaredMethods()).anyMatch(m -> config.shouldTransform(clazz.getName(), m.getName()));
    }
}

