/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.Compressor;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.Timer;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.utils.AsyncProfilerCommandBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AsyncProfilerHandler
implements Profiler {
    private static final String AGENT_FILE_NAME = "libasyncProfiler.so";
    private static long lastModified = -1L;
    private static File extractedFile = null;
    private static AsyncProfilerHandler instance;
    private boolean profilingStarted = false;
    private final ProfilersController myProfilersController = ProfilersController.getInstance();
    private AsyncProfilerCommandBuilder myAsyncProfilerCommandBuilder;

    private AsyncProfilerHandler() {
    }

    public static synchronized AsyncProfilerHandler getInstance() {
        if (instance == null) {
            instance = new AsyncProfilerHandler();
        }
        return instance;
    }

    @Override
    public void startProfiling(@NotNull String activityName, @NotNull List<String> options) {
        if (activityName == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(0);
        }
        if (options == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(1);
        }
        try {
            if (SystemInfo.isWindows) {
                throw new RuntimeException("Only Linux and MacOS are supported by Async Profiler");
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProfilersController.isProfilingStarted()) {
                    throw new RuntimeException(PerformanceTestingBundle.message("executor.started", new Object[0]));
                }
                try {
                    this.myAsyncProfilerCommandBuilder = new AsyncProfilerCommandBuilder();
                    AsyncProfilerHandler.getAsyncProfilerInstance().execute(this.myAsyncProfilerCommandBuilder.buildStartCommand(options));
                    Timer.instance.start(activityName);
                    this.myProfilersController.setCurrentProfiler(this);
                    this.setProfilingStarted(true);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static File getAsyncLib() throws IOException {
        if (extractedFile == null || !extractedFile.exists() || extractedFile.lastModified() != lastModified) {
            File extracted = FileUtil.createTempFile((String)"extracted_libasyncProfiler.so", null, (boolean)true);
            String osName = SystemInfo.isLinux ? "linux" : "macos";
            InputStream inputStream = AsyncProfiler.class.getResourceAsStream("/binaries/" + osName + "/libasyncProfiler.so");
            Files.copy(inputStream, extracted.toPath(), StandardCopyOption.REPLACE_EXISTING);
            extractedFile = extracted;
            lastModified = extractedFile.lastModified();
        }
        return extractedFile;
    }

    private static AsyncProfiler getAsyncProfilerInstance() throws IOException {
        return (AsyncProfiler)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<AsyncProfiler, IOException>(null, PerformanceTestingBundle.message("starting.async.profiler", new Object[0]), false){

            public AsyncProfiler compute(@NotNull ProgressIndicator indicator) throws IOException {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return AsyncProfiler.getInstance((String)AsyncProfilerHandler.getAsyncLib().getAbsolutePath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/performancePlugin/profilers/AsyncProfilerHandler$1", "compute"));
            }
        });
    }

    @Override
    @NotNull
    public String stopProfiling(@NotNull List<String> options) throws Exception {
        if (options == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(2);
        }
        this.myProfilersController.setCurrentProfiler(this);
        Timer timer = Timer.instance;
        if (timer.isStarted()) {
            timer.stop();
            timer.reportToTeamCity();
            ArrayList<String> combinedOptions = new ArrayList<String>(options);
            List<String> stopAndDumpCommands = this.myAsyncProfilerCommandBuilder.buildStopAndDumpCommands(combinedOptions);
            this.myProfilersController.setReportsPath(this.myAsyncProfilerCommandBuilder.getSnapshotsPath());
            this.myAsyncProfilerCommandBuilder = null;
            ApplicationManager.getApplication().invokeLater(() -> {
                try {
                    AsyncProfiler asyncProfiler = AsyncProfilerHandler.getAsyncProfilerInstance();
                    for (String stopCommand : stopAndDumpCommands) {
                        asyncProfiler.execute(stopCommand);
                    }
                    this.setProfilingStarted(false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            String string = this.myProfilersController.getReportsPath();
            if (string == null) {
                AsyncProfilerHandler.$$$reportNull$$$0(3);
            }
            return string;
        }
        throw new RuntimeException("Profiler hasn't been started");
    }

    @Override
    public File compressResults(@NotNull String pathToResult, @NotNull String archiveName) throws IOException {
        File dumpFolder;
        if (pathToResult == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(4);
        }
        if (archiveName == null) {
            AsyncProfilerHandler.$$$reportNull$$$0(5);
        }
        if (!(dumpFolder = new File(pathToResult)).exists()) {
            return null;
        }
        if (ApplicationManager.getApplication().isInternal() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            File snapshotFolder = new File(SystemProperties.getUserHome(), archiveName);
            FileUtil.copyDir((File)dumpFolder, (File)snapshotFolder);
            return snapshotFolder;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(PerformanceTestingBundle.message("async.profiling.compress.results.progress", new Object[0]));
        }
        File snapshotFile = new File(SystemProperties.getUserHome(), archiveName + ".zip");
        try (Compressor.Zip zip = new Compressor.Zip(snapshotFile);){
            zip.addDirectory(dumpFolder);
        }
        FileUtil.delete((File)dumpFolder);
        return snapshotFile;
    }

    public void showCompleteNotification() {
        this.showCompleteNotification(null);
    }

    public void showCompleteNotification(@Nullable Project project) {
        final Notification completeNotification = new Notification("PerformancePlugin", PerformanceTestingBundle.message("async.profile.report.ready", new Object[0]), "", NotificationType.INFORMATION);
        completeNotification.addAction((AnAction)new DumbAwareAction(PerformanceTestingBundle.message("action.text.show.profile", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                RevealFileAction.openDirectory((File)new File(ProfilersController.getInstance().getReportsPath()));
                completeNotification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/profilers/AsyncProfilerHandler$2", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)completeNotification, (Project)project);
    }

    private void setProfilingStarted(boolean started) {
        this.profilingStarted = started;
    }

    public boolean isProfilingStarted() {
        return this.profilingStarted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/profilers/AsyncProfilerHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/profilers/AsyncProfilerHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stopProfiling";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startProfiling";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stopProfiling";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compressResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

