/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.lang.doc;

import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ResourceUtil;
import com.jetbrains.performancePlugin.CommandProvider;
import com.jetbrains.performancePlugin.lang.psi.IJPerfCommandName;
import com.jetbrains.performancePlugin.lang.psi.IJPerfPsiImplUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IJPerfDocumentationProvider
extends AbstractDocumentationProvider {
    @Nullable
    public String generateHoverDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            IJPerfDocumentationProvider.$$$reportNull$$$0(0);
        }
        Object title = null;
        if (!(element instanceof IJPerfCommandName)) {
            return null;
        }
        try {
            String commandDescriptionFileName = IJPerfDocumentationProvider.getCommandDescriptionFileName(IJPerfPsiImplUtil.getName((IJPerfCommandName)element));
            InputStream inputStream = IJPerfDocumentationProvider.getDocumentationStream(commandDescriptionFileName);
            if (inputStream != null) {
                title = ResourceUtil.loadText((InputStream)inputStream);
                title = ((String)title).substring(((String)title).indexOf("<title>") + "<title>".length(), ((String)title).indexOf("</title>"));
            }
        }
        catch (IOException ex) {
            Logger.getInstance(((Object)((Object)this)).getClass()).error(ex.getMessage());
        }
        if (title != null) {
            title = "<div class='definition'><pre>" + StringUtil.escapeXmlEntities(title) + "</pre></div>";
        }
        return title;
    }

    private static InputStream getDocumentationStream(@NotNull String commandDescriptionFileName) {
        if (commandDescriptionFileName == null) {
            IJPerfDocumentationProvider.$$$reportNull$$$0(1);
        }
        return CommandProvider.EP_NAME.extensions().map(commandProvider -> ResourceUtil.getResourceAsStream((ClassLoader)commandProvider.getClass().getClassLoader(), (String)"commandDescriptions", (String)commandDescriptionFileName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private static String getCommandDescriptionFileName(@Nullable String commandName) {
        return commandName != null ? commandName.replaceAll("%", "") + "Command.html" : null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (!(element instanceof IJPerfCommandName)) {
            return null;
        }
        try {
            String commandName = IJPerfPsiImplUtil.getName((IJPerfCommandName)element);
            String commandDescriptionFileName = IJPerfDocumentationProvider.getCommandDescriptionFileName(commandName);
            InputStream inputStream = IJPerfDocumentationProvider.getDocumentationStream(commandDescriptionFileName);
            if (inputStream != null) {
                String description = ResourceUtil.loadText((InputStream)inputStream);
                return "<div class='definition'><pre>" + StringUtil.escapeXmlEntities((String)commandName) + "</pre></div><div class='content'>" + description + "</div>";
            }
        }
        catch (IOException ex) {
            Logger.getInstance(((Object)((Object)this)).getClass()).error(ex.getMessage());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandDescriptionFileName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/lang/doc/IJPerfDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateHoverDoc";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDocumentationStream";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

