/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class UnloadDynamicPluginCommand
extends AbstractCommand {
    public static final String PREFIX = "%unloadDynamicPlugin";
    private static final Logger LOG = Logger.getInstance(UnloadDynamicPluginCommand.class);

    public UnloadDynamicPluginCommand(@NotNull String text, int line) {
        if (text == null) {
            UnloadDynamicPluginCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String pluginIdString = this.getText().substring(PREFIX.length()).trim();
        PluginId pluginId = PluginId.getId((String)pluginIdString);
        final IdeaPluginDescriptorImpl pluginDescriptor = PluginDescriptorLoader.loadFullDescriptor((IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)pluginId))));
        final Project project = context.getProject();
        DumbService.getInstance((Project)project).waitForSmartMode();
        if (DisabledPluginsState.isDisabled((PluginId)pluginId)) {
            actionCallback.reject("Plugin " + pluginIdString + " is disabled. Unload can not be performed");
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        for (IdeaPluginDescriptor loadedPlugin : PluginManagerCore.getLoadedPlugins()) {
            if (loadedPlugin.getPluginId().equals(pluginId)) continue;
            List dependencies = ((IdeaPluginDescriptorImpl)loadedPlugin).getPluginDependencies();
            for (PluginDependency dependency : dependencies) {
                if (dependency.isOptional || !dependency.id.equals(pluginId)) continue;
                actionCallback.reject("Plugin " + pluginIdString + " can't be unloaded because it's a non-optional dependency of " + loadedPlugin.getPluginId());
                return Promises.toPromise((ActionCallback)actionCallback);
            }
        }
        if (DynamicPlugins.allowLoadUnloadWithoutRestart((IdeaPluginDescriptorImpl)pluginDescriptor)) {
            pluginDescriptor.setEnabled(false);
            final MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
            appConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

                public void pluginUnloaded(@NotNull IdeaPluginDescriptor descriptor, boolean isUpdate) {
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (descriptor.equals(pluginDescriptor)) {
                        final MessageBusConnection projectConnection = project.getMessageBus().connect();
                        projectConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                            public void exitDumbMode() {
                                appConnection.disconnect();
                                projectConnection.disconnect();
                                actionCallback.setDone();
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/performancePlugin/commands/UnloadDynamicPluginCommand$1", "pluginUnloaded"));
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeEventQueue.getInstance().flushQueue();
                boolean pluginUnloaded = DynamicPlugins.unloadPlugin((IdeaPluginDescriptorImpl)pluginDescriptor, (DynamicPlugins.UnloadPluginOptions)new DynamicPlugins.UnloadPluginOptions().withDisable(true).withRequireMemorySnapshot(true));
                if (!pluginUnloaded) {
                    actionCallback.reject("Plugin " + pluginIdString + " was not unloaded");
                } else {
                    LOG.info("Plugin " + pluginIdString + " was unloaded");
                }
            });
        } else {
            actionCallback.reject("Plugin " + pluginIdString + " is not dynamic");
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/UnloadDynamicPluginCommand", "<init>"));
    }
}

