/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class TakeScreenshotCommand
extends AbstractCommand {
    public static final String PREFIX = "%takeScreenshot";
    private static final Logger LOG = Logger.getInstance(TakeScreenshotCommand.class);

    public TakeScreenshotCommand(@NotNull String text, int line) {
        if (text == null) {
            TakeScreenshotCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    public Promise<Object> _execute(PlaybackContext context) {
        AsyncPromise result = new AsyncPromise();
        String fullPathToFile = this.getText().substring(PREFIX.length()).trim();
        ApplicationManager.getApplication().executeOnPooledThread(() -> TakeScreenshotCommand.takeScreenshot(fullPathToFile));
        result.setResult(null);
        return result;
    }

    public static void takeScreenshot(String fullPathToFile) {
        Rectangle rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        Robot robot = null;
        try {
            robot = new Robot();
        }
        catch (AWTException e) {
            LOG.info("Exceptions occurs at attempt to create Robot for taking screenshot");
            LOG.info((Throwable)e);
        }
        BufferedImage img = robot.createScreenCapture(rectangle);
        try {
            File screenshotFile = new File(fullPathToFile);
            ImageIO.write((RenderedImage)img, "jpg", screenshotFile);
            if (screenshotFile.exists()) {
                LOG.info("Screenshot saved:" + fullPathToFile);
            }
        }
        catch (IOException e) {
            LOG.info("Exceptions occurs at attempt to write screenshot to file");
            LOG.info((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/TakeScreenshotCommand", "<init>"));
    }
}

