/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.indexing.FileBasedIndexSwitcher;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.commands.StoreIndices$sam$java_lang_Runnable$0;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/performancePlugin/commands/StoreIndices;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "storeIndexesTo", "", "storedIndexDir", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.performanceTesting"})
public final class StoreIndices
extends AbstractCommand {
    @NotNull
    public static final String PREFIX = "%storeIndices";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        Project project2 = project;
        LOG.info("dynamic.classpath: " + PropertiesComponent.getInstance((Project)project2).getValue("dynamic.classpath"));
        Path storedIndexDir = StoreIndices.Companion.getOrCreateDirectoryToStoreIndex();
        LOG.info("Index will be stored to " + storedIndexDir);
        DumbService.getInstance((Project)project2).smartInvokeLater(new Runnable(this, storedIndexDir, project2, actionCallback){
            final /* synthetic */ StoreIndices this$0;
            final /* synthetic */ Path $storedIndexDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void error;
                Function0 storeIndexesAction2;
                FileBasedIndexSwitcher switcher = new FileBasedIndexSwitcher();
                switcher.turnOff();
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                Function0 function0 = storeIndexesAction2 = (Function0)new Function0<Unit>(this, (Ref.ObjectRef)error){
                    final /* synthetic */ _execute.1 this$0;
                    final /* synthetic */ Ref.ObjectRef $error;

                    public final void invoke() {
                        try {
                            StoreIndices storeIndices = this.this$0.this$0;
                            Path path = this.this$0.$storedIndexDir;
                            ProgressManager progressManager = ProgressManager.getInstance();
                            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                            ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"ProgressManager.getInstance().progressIndicator");
                            StoreIndices.access$storeIndexesTo(storeIndices, path, progressIndicator, this.this$0.$project);
                            StoreIndices.access$getLOG$cp().info("Indices have been successfully stored to " + this.this$0.$storedIndexDir);
                        }
                        catch (Throwable e) {
                            this.$error.element = e;
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$error = objectRef;
                        super(0);
                    }
                };
                ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)new StoreIndices$sam$java_lang_Runnable$0(function0), PerformanceTestingBundle.message("storing.indexes", new Object[0]), false, this.$project);
                switcher.turnOn();
                if ((Throwable)error.element != null) {
                    StoreIndices.access$getLOG$cp().error((Object)((Throwable)error.element));
                    Throwable throwable = (Throwable)error.element;
                    Intrinsics.checkNotNull((Object)throwable);
                    Intrinsics.checkNotNullExpressionValue((Object)this.$actionCallback.reject(throwable.getMessage()), (String)"actionCallback.reject(error!!.message)");
                } else {
                    this.$actionCallback.setDone();
                }
            }
            {
                this.this$0 = storeIndices;
                this.$storedIndexDir = path;
                this.$project = project;
                this.$actionCallback = actionCallbackProfilerStopper;
            }
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final void storeIndexesTo(Path storedIndexDir, ProgressIndicator indicator, Project project) {
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable<T>(){

            public final T compute() {
                boolean bl = false;
                SerializationManagerEx.getInstanceEx().flushNameStorage();
                return (T)Unit.INSTANCE;
            }
        });
        indicator.setIndeterminate(true);
        indicator.setText(PerformanceTestingBundle.message("storing.indexes.copying", new Object[0]));
        Path path = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getIndexRoot()");
        Path indexRoot = path;
        try {
            FileUtil.delete((Path)storedIndexDir);
            FileUtil.copyDir((File)indexRoot.toFile(), (File)storedIndexDir.toFile());
            LOG.info("Stored index directory contains: " + Companion.dumpDirectory(storedIndexDir));
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        IndexContentDiagnostic contentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.getIndexContentDiagnosticForProject(project, indicator);
        IndexContentDiagnosticDumper.INSTANCE.writeTo(Companion.getFileForDiagnostic(storedIndexDir), contentDiagnostic);
    }

    public StoreIndices(@Nullable String text, int line) {
        super(text, line);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StoreIndices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$storeIndexesTo(StoreIndices $this, Path storedIndexDir, ProgressIndicator indicator, Project project) {
        $this.storeIndexesTo(storedIndexDir, indicator, project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/commands/StoreIndices$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX", "", "dumpDirectory", "", "dir", "Ljava/nio/file/Path;", "getFileForDiagnostic", "indexesHomeDirectory", "getOrCreateDirectoryToStoreIndex", "intellij.performanceTesting"})
    public static final class Companion {
        private final Path getOrCreateDirectoryToStoreIndex() {
            Path path;
            String property = System.getProperty("store.indices.command.stored.indexes.dump.directory");
            if (property != null) {
                Path path2 = Paths.get(property, new String[0]);
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(property)");
            } else {
                Path path3;
                try {
                    path3 = FileUtil.createTempDirectory((String)"stored_index", null).toPath();
                }
                catch (IOException e) {
                    throw (Throwable)new RuntimeException(e);
                }
                Path path4 = path3;
                path = path4;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"try {\n          FileUtil\u2026imeException(e)\n        }");
            }
            return path;
        }

        @NotNull
        public final Path getFileForDiagnostic(@NotNull Path indexesHomeDirectory) {
            Intrinsics.checkNotNullParameter((Object)indexesHomeDirectory, (String)"indexesHomeDirectory");
            Path path = indexesHomeDirectory.resolve("indexedFilePaths.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"indexesHomeDirectory.res\u2026(\"indexedFilePaths.json\")");
            return path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<String> dumpDirectory(@NotNull Path dir) {
            List list;
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            dumpDirectory.1 $fun$dumpFileInfo$1 = dumpDirectory.1.INSTANCE;
            AutoCloseable autoCloseable = Files.list(dir);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl3 = false;
                Stream stream = it.map(dumpDirectory.2.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(stream, (String)"it.map { p -> dumpFileInfo(p) }");
                list = StreamsKt.toList(stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return list;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

