/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class OpenFileCommand
extends AbstractCommand {
    public static final String PREFIX = "%openFile";

    public OpenFileCommand(@NotNull String text, int line) {
        if (text == null) {
            OpenFileCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            OpenFileCommand.$$$reportNull$$$0(1);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String filePath = this.getText().substring(PREFIX.length()).trim();
        Project project = context.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            final VirtualFile file = OpenFileCommand.findFile(project, filePath);
            if (file == null) {
                actionCallback.reject(PerformanceTestingBundle.message("command.open.nofile", filePath));
            } else {
                FileEditorManager.getInstance((Project)project).openFile(file, true);
                final MessageBusConnection busConnection = project.getMessageBus().connect();
                busConnection.subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

                    public void daemonFinished() {
                        busConnection.disconnect();
                        context.message(PerformanceTestingBundle.message("command.open.finish", file.getName()), OpenFileCommand.this.getLine());
                        actionCallback.setDone();
                    }
                });
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            OpenFileCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @Nullable
    static VirtualFile findFile(@NotNull Project project, @NotNull String filePath) {
        if (project == null) {
            OpenFileCommand.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            OpenFileCommand.$$$reportNull$$$0(4);
        }
        if (filePath.contains("!/")) {
            return JarFileSystem.getInstance().findFileByPath(filePath);
        }
        if (FileUtil.isAbsolute((String)filePath)) {
            return LocalFileSystem.getInstance().findFileByPath(filePath);
        }
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            return projectDir.findFileByRelativePath(filePath);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/OpenFileCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/OpenFileCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

