/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.marketplace.PluginModulesHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FindPluginDependenciesCommand
extends AbstractCommand {
    public static final String PREFIX = "%findDependencies";
    private static final Logger LOG = Logger.getInstance(FindPluginDependenciesCommand.class);

    public FindPluginDependenciesCommand(@NotNull String text, int line) {
        if (text == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String argsString = this.getText().substring(PREFIX.length()).trim();
        String[] args = argsString.split(",");
        String pluginIdString = args[0].trim();
        String fileToStoreDependenciesOnPlugin = args[1].trim();
        String fileToStorePluginsDependencies = args[2].trim();
        PluginId pluginId = PluginId.getId((String)pluginIdString);
        ArrayList<String> foundDependenciesOnPlugin = new ArrayList<String>();
        ArrayList<String> foundPluginsDependencies = new ArrayList<String>();
        List loadedPlugins = PluginManagerCore.getLoadedPlugins();
        for (IdeaPluginDescriptor loadedPlugin : loadedPlugins) {
            if (loadedPlugin.getPluginId().equals(pluginId)) {
                List pluginsDependencies = ContainerUtil.filter((Collection)((IdeaPluginDescriptorImpl)loadedPlugin).getPluginDependencies(), it -> !it.isOptional());
                for (PluginDependency dependency : pluginsDependencies) {
                    if (PluginManagerCore.isModuleDependency((PluginId)dependency.id)) {
                        PluginId pluginIdByModule = PluginModulesHelper.getInstance().getInstalledPluginIdByModule(dependency.id);
                        if (pluginIdByModule == null || Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)pluginIdByModule)).isBundled()) continue;
                        foundPluginsDependencies.add(pluginIdByModule.getIdString());
                        continue;
                    }
                    IdeaPluginDescriptorImpl pluginDescriptor = PluginDescriptorLoader.loadFullDescriptor((IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)dependency.id))));
                    if (pluginDescriptor.isBundled()) continue;
                    foundPluginsDependencies.add(dependency.getPluginId().getIdString());
                }
                continue;
            }
            List dependencies = ((IdeaPluginDescriptorImpl)loadedPlugin).getPluginDependencies();
            for (PluginDependency dependency : dependencies) {
                if (dependency.isOptional || !dependency.id.equals(pluginId)) continue;
                foundDependenciesOnPlugin.add(loadedPlugin.getPluginId().getIdString());
            }
        }
        try {
            FileUtil.writeToFile((File)new File(fileToStoreDependenciesOnPlugin), (String)String.join((CharSequence)"\n", foundDependenciesOnPlugin));
            FileUtil.writeToFile((File)new File(fileToStorePluginsDependencies), (String)String.join((CharSequence)"\n", foundPluginsDependencies));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        actionCallback.setDone();
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/FindPluginDependenciesCommand", "<init>"));
    }
}

