/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnableDisableAction;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class EnableDisablePluginPerProjectCommand
extends AbstractCommand {
    public static final String PREFIX = "%enableDisablePluginPerProject";

    public EnableDisablePluginPerProjectCommand(@NotNull String text, int line) {
        if (text == null) {
            EnableDisablePluginPerProjectCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String input = this.getText().substring(PREFIX.length()).trim();
        int index = input.lastIndexOf(" ");
        String pluginId = input.substring(0, index);
        PluginEnableDisableAction action = Boolean.parseBoolean(input.substring(index + 1)) ? PluginEnableDisableAction.ENABLE_FOR_PROJECT : PluginEnableDisableAction.DISABLE_FOR_PROJECT;
        @NotNull Project project = context.getProject();
        if (!InstalledPluginsState.getInstance().isRestartRequired()) {
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                MyPluginModel model = new MyPluginModel(context.getProject());
                IdeaPluginDescriptor descriptor = Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId)));
                model.changeEnableDisable(Set.of(descriptor), action);
                try {
                    if (model.apply(null)) {
                        actionCallback.setDone();
                    } else {
                        actionCallback.reject("Failed to load/unload: " + pluginId);
                    }
                }
                catch (ConfigurationException e) {
                    actionCallback.reject(e.getMessage());
                }
            });
        } else {
            actionCallback.reject("Not allowing load/unload without restart because of pending restart operation");
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/EnableDisablePluginPerProjectCommand", "<init>"));
    }
}

