/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.DumpProjectFiles;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/performancePlugin/commands/DumpProjectFiles;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "dumpProjectFiles", "", "dumpDir", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.performanceTesting"})
public final class DumpProjectFiles
extends AbstractCommand {
    @NotNull
    public static final String PREFIX = "%dumpProjectFiles";
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Path dumpProjectFilesDir = DumpProjectFiles.Companion.getOrCreateDirectoryToDumpFiles();
        LOG.info("DumpFiles will be stored to " + dumpProjectFilesDir);
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        Project project2 = project;
        DumbService.getInstance((Project)project2).smartInvokeLater(new Runnable(this, dumpProjectFilesDir, project2, actionCallback){
            final /* synthetic */ DumpProjectFiles this$0;
            final /* synthetic */ Path $dumpProjectFilesDir;
            final /* synthetic */ Project $project;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;

            public final void run() {
                new Task.Modal(this, this.$project, PerformanceTestingBundle.message("dumping.project.files", new Object[0]), false){
                    final /* synthetic */ _execute.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        try {
                            DumpProjectFiles.access$dumpProjectFiles(this.this$0.this$0, this.this$0.$dumpProjectFilesDir, indicator, this.this$0.$project);
                            DumpProjectFiles.access$getLOG$cp().info("Project files has been successfully stored to " + this.this$0.$dumpProjectFilesDir);
                            this.this$0.$actionCallback.setDone();
                        }
                        catch (Throwable e) {
                            Intrinsics.checkNotNullExpressionValue((Object)this.this$0.$actionCallback.reject(e.getMessage()), (String)"actionCallback.reject(e.message)");
                        }
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }
                }.queue();
            }
            {
                this.this$0 = dumpProjectFiles;
                this.$dumpProjectFilesDir = path;
                this.$project = project;
                this.$actionCallback = actionCallbackProfilerStopper;
            }
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final void dumpProjectFiles(Path dumpDir, ProgressIndicator indicator, Project project) {
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable<T>(){

            public final T compute() {
                boolean bl = false;
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (fileBasedIndex == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                }
                ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
                return (T)Unit.INSTANCE;
            }
        });
        indicator.setIndeterminate(true);
        IndexContentDiagnostic contentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.getIndexContentDiagnosticForProject(project, indicator);
        IndexContentDiagnosticDumper.INSTANCE.writeTo(StoreIndices.Companion.getFileForDiagnostic(dumpDir), contentDiagnostic);
    }

    public DumpProjectFiles(@Nullable String text, int line) {
        super(text, line);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DumpProjectFiles.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(DumpProjectFiles::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$dumpProjectFiles(DumpProjectFiles $this, Path dumpDir, ProgressIndicator indicator, Project project) {
        $this.dumpProjectFiles(dumpDir, indicator, project);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/performancePlugin/commands/DumpProjectFiles$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX", "", "getOrCreateDirectoryToDumpFiles", "Ljava/nio/file/Path;", "intellij.performanceTesting"})
    public static final class Companion {
        private final Path getOrCreateDirectoryToDumpFiles() {
            Path path;
            String property = System.getProperty("dump.project.files.directory");
            if (property != null) {
                Path path2 = Paths.get(property, new String[0]);
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(property)");
            } else {
                Path path3;
                try {
                    path3 = FileUtil.createTempDirectory((String)"projectFiles_dumps", null).toPath();
                }
                catch (IOException e) {
                    throw (Throwable)new RuntimeException(e);
                }
                Path path4 = path3;
                path = path4;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"try {\n          FileUtil\u2026imeException(e)\n        }");
            }
            return path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

