/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class DoLocalInspection
extends AbstractCommand
implements Disposable {
    public static final String PREFIX = "%doLocalInspection";

    public DoLocalInspection(@NotNull String text, int line) {
        if (text == null) {
            DoLocalInspection.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            DoLocalInspection.$$$reportNull$$$0(1);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        final Project project = context.getProject();
        DumbService.getInstance((Project)project).waitForSmartMode();
        final MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

            public void daemonFinished() {
                DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                assert (editor != null);
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                assert (psiFile != null);
                if (myDaemonCodeAnalyzer.isErrorAnalyzingFinished(psiFile)) {
                    List errorsOnHighlighting = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)project);
                    List warningsOnHighlighting = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.WARNING, (Project)project);
                    List weakWarningsOnHighlighting = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.WEAK_WARNING, (Project)project);
                    StringBuilder finishMessage = new StringBuilder("Local inspections have been finished with: ");
                    if (errorsOnHighlighting.size() > 0) {
                        finishMessage.append("\n").append(new String("Errors: " + errorsOnHighlighting.size()));
                    }
                    for (HighlightInfo error : errorsOnHighlighting) {
                        finishMessage.append("\n").append(new String(error.getText() + ": " + error.getDescription()));
                    }
                    if (warningsOnHighlighting.size() > 0) {
                        finishMessage.append("\n").append(new String("Warnings: " + warningsOnHighlighting.size()));
                    }
                    for (HighlightInfo warning : warningsOnHighlighting) {
                        finishMessage.append("\n").append(new String(warning.getText() + ": " + warning.getDescription()));
                    }
                    if (weakWarningsOnHighlighting.size() > 0) {
                        finishMessage.append("\n").append(new String("Weak Warnings: " + weakWarningsOnHighlighting.size()));
                    }
                    for (HighlightInfo weakWarning : weakWarningsOnHighlighting) {
                        finishMessage.append("\n").append(new String(weakWarning.getText() + ": " + weakWarning.getDescription()));
                    }
                    busConnection.disconnect();
                    context.message(finishMessage.toString(), DoLocalInspection.this.getLine());
                    actionCallback.setDone();
                }
            }
        });
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            PsiManager.getInstance((Project)project).dropPsiCaches();
            context.message("Local inspections have been started", this.getLine());
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            DoLocalInspection.$$$reportNull$$$0(2);
        }
        return promise;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/DoLocalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/DoLocalInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

