/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.performancePlugin.CommandProvider;
import com.jetbrains.performancePlugin.CreateCommand;
import com.jetbrains.performancePlugin.commands.BuildCommand;
import com.jetbrains.performancePlugin.commands.CheckOnRedCodeCommand;
import com.jetbrains.performancePlugin.commands.CheckPluginStateCommand;
import com.jetbrains.performancePlugin.commands.CleanCaches;
import com.jetbrains.performancePlugin.commands.CompareIndices;
import com.jetbrains.performancePlugin.commands.CompareProjectFiles;
import com.jetbrains.performancePlugin.commands.CompletionCommand;
import com.jetbrains.performancePlugin.commands.DelayTypeCommand;
import com.jetbrains.performancePlugin.commands.DoLocalInspection;
import com.jetbrains.performancePlugin.commands.DumpProjectFiles;
import com.jetbrains.performancePlugin.commands.EnableDisablePluginPerProjectCommand;
import com.jetbrains.performancePlugin.commands.EnterCommand;
import com.jetbrains.performancePlugin.commands.ExitAppCommand;
import com.jetbrains.performancePlugin.commands.FindPluginDependenciesCommand;
import com.jetbrains.performancePlugin.commands.FindUsagesCommand;
import com.jetbrains.performancePlugin.commands.GitCheckoutCommand;
import com.jetbrains.performancePlugin.commands.GoToCommand;
import com.jetbrains.performancePlugin.commands.InspectionCommand;
import com.jetbrains.performancePlugin.commands.InspectionCommandEx;
import com.jetbrains.performancePlugin.commands.LoadDynamicPluginCommand;
import com.jetbrains.performancePlugin.commands.MemoryDumpCommand;
import com.jetbrains.performancePlugin.commands.MoveDirectoryCommand;
import com.jetbrains.performancePlugin.commands.OpenFileCommand;
import com.jetbrains.performancePlugin.commands.OpenProjectCommand;
import com.jetbrains.performancePlugin.commands.OpenProjectView;
import com.jetbrains.performancePlugin.commands.RecordCounterCollectorBaselinesCommand;
import com.jetbrains.performancePlugin.commands.RecordStateCollectorsCommand;
import com.jetbrains.performancePlugin.commands.ReformatCommand;
import com.jetbrains.performancePlugin.commands.ReplaceTextCommand;
import com.jetbrains.performancePlugin.commands.RunClassInPlugin;
import com.jetbrains.performancePlugin.commands.SelectCommand;
import com.jetbrains.performancePlugin.commands.SetupProjectSdkCommand;
import com.jetbrains.performancePlugin.commands.ShowAltEnter;
import com.jetbrains.performancePlugin.commands.SingleInspectionCommand;
import com.jetbrains.performancePlugin.commands.StartPowerSave;
import com.jetbrains.performancePlugin.commands.StartProfileCommand;
import com.jetbrains.performancePlugin.commands.StopPowerSave;
import com.jetbrains.performancePlugin.commands.StopProfileCommand;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.commands.TakeScreenshotCommand;
import com.jetbrains.performancePlugin.commands.UnloadDynamicPluginCommand;
import com.jetbrains.performancePlugin.commands.WaitForSmartCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class BaseCommandProvider
implements CommandProvider {
    @Override
    public List<Pair<String, CreateCommand>> getCommands() {
        HashMap<String, CreateCommand> map = new HashMap<String, CreateCommand>();
        BaseCommandProvider.initCommands(map);
        return ContainerUtil.map(map.entrySet(), entry -> new Pair((Object)((String)entry.getKey()), (Object)((CreateCommand)entry.getValue())));
    }

    private static void initCommands(@NotNull Map<String, CreateCommand> map) {
        if (map == null) {
            BaseCommandProvider.$$$reportNull$$$0(0);
        }
        map.put("%takeScreenshot", (command, line) -> new TakeScreenshotCommand(command, line));
        map.put("%openFile", (command, line) -> new OpenFileCommand(command, line));
        map.put("%startProfile", (command, line) -> new StartProfileCommand(command, line));
        map.put("%stopProfile", (command, line) -> new StopProfileCommand(command, line));
        map.put("%inspectCode", (command, line) -> new InspectionCommand(command, line));
        map.put("%InspectCodeEx", (command, line) -> new InspectionCommandEx(command, line));
        map.put("%reformat", (command, line) -> new ReformatCommand(command, line));
        map.put("%goto", (command, line) -> new GoToCommand(command, line));
        map.put("%doLocalInspection", (command, line) -> new DoLocalInspection(command, line));
        map.put("%doComplete", (command, line) -> new CompletionCommand(command, line));
        map.put("%delayType", (command, line) -> new DelayTypeCommand(command, line));
        map.put("%replaceText", (command, line) -> new ReplaceTextCommand(command, line));
        map.put("%exitApp", (command, line) -> new ExitAppCommand(command, line));
        map.put("%waitForSmart", (command, line) -> new WaitForSmartCommand(command, line));
        map.put("%runSingleInspection", (command, line) -> new SingleInspectionCommand(command, line));
        map.put("%startPowerSave", (command, line) -> new StartPowerSave(command, line));
        map.put("%stopPowerSave", (command, line) -> new StopPowerSave(command, line));
        map.put("%memoryDump", (command, line) -> new MemoryDumpCommand(command, line));
        map.put("%cleanCaches", (command, line) -> new CleanCaches(command, line));
        map.put("%findUsages", (command, line) -> new FindUsagesCommand(command, line));
        map.put("%pressKey", (command, line) -> new EnterCommand(command, line));
        map.put("%buildProject", (command, line) -> new BuildCommand(command, line));
        map.put("%altEnter", (command, line) -> new ShowAltEnter(command, line));
        map.put("%selectText", (command, line) -> new SelectCommand(command, line));
        map.put("%loadDynamicPlugin", (command, line) -> new LoadDynamicPluginCommand(command, line));
        map.put("%unloadDynamicPlugin", (command, line) -> new UnloadDynamicPluginCommand(command, line));
        map.put("%compareIndices", (command, line) -> new CompareIndices(command, line));
        map.put("%storeIndices", (command, line) -> new StoreIndices(command, line));
        map.put("%gitCheckout", (command, line) -> new GitCheckoutCommand(command, line));
        map.put("%openProjectView", (command, line) -> new OpenProjectView(command, line));
        map.put("%moveDirectory", (command, line) -> new MoveDirectoryCommand(command, line));
        map.put("%runClassInPlugin", (command, line) -> new RunClassInPlugin(command, line));
        map.put("%setupSDK", (command, line) -> new SetupProjectSdkCommand(command, line));
        map.put("%findDependencies", (command, line) -> new FindPluginDependenciesCommand(command, line));
        map.put("%checkPluginState", (command, line) -> new CheckPluginStateCommand(command, line));
        map.put("%openProject", (command, line) -> new OpenProjectCommand(command, line));
        map.put("%checkOnRedCode", (command, line) -> new CheckOnRedCodeCommand(command, line));
        map.put("%enableDisablePluginPerProject", (command, line) -> new EnableDisablePluginPerProjectCommand(command, line));
        map.put("%dumpProjectFiles", (command, line) -> new DumpProjectFiles(command, line));
        map.put("%compareProjectFiles", (command, line) -> new CompareProjectFiles(command, line));
        map.put("%recordRegisteredCounterGroups", (command, line) -> new RecordCounterCollectorBaselinesCommand(command, line));
        map.put("%recordStateCollectors", (command, line) -> new RecordStateCollectorsCommand(command, line));
    }

    private static boolean isGitPluginEnabled() {
        PluginId id = PluginId.getId((String)"Git4Idea");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)id);
        return PluginManagerCore.isPluginInstalled((PluginId)id) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/performancePlugin/BaseCommandProvider", "initCommands"));
    }
}

