/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class NavigationHelper {
    NavigationHelper() {
    }

    @Nullable
    public static NavigationHelper getInstance() {
        return (NavigationHelper)ServiceManager.getService(NavigationHelper.class);
    }

    @Nullable
    public abstract Navigatable getNavigatable(@NotNull Project var1, @NotNull StackTraceElement var2);

    static class Impl
    extends NavigationHelper {
        Impl() {
        }

        @Override
        @Nullable
        public Navigatable getNavigatable(@NotNull Project project, @NotNull StackTraceElement place) {
            Object file;
            if (project == null) {
                Impl.$$$reportNull$$$0(0);
            }
            if (place == null) {
                Impl.$$$reportNull$$$0(1);
            }
            if (DumbService.isDumb((Project)project)) {
                return null;
            }
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            String fileName = place.getFileName();
            int line = place.getLineNumber();
            int offset = 0;
            PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)place.getClassName(), null, (boolean)true, (GlobalSearchScope)scope);
            if (psiClass != null) {
                if (line < 0) {
                    String methodName = place.getMethodName();
                    String methodNameAdjusted = !methodName.startsWith("lambda$") ? methodName : methodName.substring(methodName.indexOf(36) + 1, methodName.lastIndexOf(36));
                    PsiMethod[] methods = psiClass.findMethodsByName(methodNameAdjusted, false);
                    offset = methods.length == 0 ? 0 : methods[0].getTextOffset();
                }
                file = PsiUtilCore.getVirtualFile((PsiElement)psiClass);
            } else {
                PsiFileSystemItem[] files;
                file = StringUtil.isNotEmpty((String)fileName) ? ((files = FilenameIndex.getFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope, (boolean)false)).length == 0 ? null : PsiUtilCore.getVirtualFile((PsiElement)files[0])) : null;
            }
            return file == null ? null : (offset > 0 ? new OpenFileDescriptor(project, file, offset) : new OpenFileDescriptor(project, file, Math.max(line - 1, 0), 0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/cachedValueProfiler/NavigationHelper$Impl";
            objectArray[2] = "getNavigatable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

