/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.intellij.ide.DataManager;
import com.intellij.internal.cachedValueProfiler.CachedValueProfilerDumpHelper;
import com.intellij.internal.cachedValueProfiler.NavigationHelper;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CVPPanel
extends JBLoadingPanel {
    private static final ColorKey HOVER_BACKGROUND = ColorKey.createColorKey((String)"Table.hoverBackground", (Color)JBUI.CurrentTheme.Table.Hover.background((boolean)true));
    private static final NumberFormat FORMAT = NumberFormat.getInstance(Locale.US);

    public CVPPanel(@NotNull Project project, @NotNull VirtualFile file, @NotNull Disposable parent) {
        if (project == null) {
            CVPPanel.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CVPPanel.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            CVPPanel.$$$reportNull$$$0(2);
        }
        super((LayoutManager)new BorderLayout(), parent);
        this.startLoading();
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            List<CVPInfo> infos = null;
            IOException error = null;
            try {
                infos = CVPPanel.loadInfos(VfsUtilCore.virtualToIoFile((VirtualFile)file));
            }
            catch (IOException ex) {
                error = ex;
            }
            finally {
                IOException finalError = error;
                List<CVPInfo> finalInfos = infos;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (finalInfos != null) {
                        TableView<CVPInfo> table = CVPPanel.createTable(finalInfos, project);
                        this.add(ScrollPaneFactory.createScrollPane(table, (boolean)true), "Center");
                    } else {
                        this.add((Component)new JBLabel(finalError != null ? finalError.getMessage() : LangBundle.message((String)"status.text.nothing.to.show", (Object[])new Object[0])));
                    }
                    this.stopLoading();
                }, o -> Disposer.isDisposed((Disposable)parent));
            }
        });
    }

    @NotNull
    private static TableView<CVPInfo> createTable(@NotNull List<CVPInfo> infos, @NotNull Project project) {
        if (infos == null) {
            CVPPanel.$$$reportNull$$$0(3);
        }
        if (project == null) {
            CVPPanel.$$$reportNull$$$0(4);
        }
        ColumnInfo[] columns = CVPPanel.getColumns();
        TableView<CVPInfo> table = new TableView<CVPInfo>(new ListTableModel(columns, infos, 1, SortOrder.DESCENDING)){

            public Color getBackground() {
                return this.colorScheme().getDefaultBackground();
            }

            public Color getForeground() {
                return this.colorScheme().getDefaultForeground();
            }

            public Color getGridColor() {
                return this.color(EditorColors.INDENT_GUIDE_COLOR, super.getGridColor());
            }

            public Color getSelectionForeground() {
                return this.color(EditorColors.SELECTION_FOREGROUND_COLOR, this.getForeground());
            }

            public Color getSelectionBackground() {
                return this.color(EditorColors.SELECTION_BACKGROUND_COLOR, this.getBackground());
            }

            protected Color getHoveredRowBackground() {
                return this.color(HOVER_BACKGROUND, super.getHoveredRowBackground());
            }

            Color color(ColorKey key, Color def) {
                return (Color)ObjectUtils.coalesce((Object)this.colorScheme().getColor(key), (Object)def);
            }

            EditorColorsScheme colorScheme() {
                return EditorColorsManager.getInstance().getGlobalScheme();
            }
        };
        table.setAutoResizeMode(0);
        table.setFillsViewportHeight(true);
        table.setAdditionalRowsCount(5);
        table.setDefaultRenderer(Object.class, (TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setTextAlign(table.convertColumnIndexToModel(column) == 0 ? 2 : 4);
                SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)table, (String)String.valueOf(value), (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)selected, (SimpleColoredComponent)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/internal/cachedValueProfiler/CVPPanel$2", "customizeCellRenderer"));
            }
        });
        new TableViewSpeedSearch<CVPInfo>((TableView)table){

            @Nullable
            protected String getItemText(@NotNull CVPInfo element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                return String.valueOf(element.place);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/internal/cachedValueProfiler/CVPPanel$3", "getItemText"));
            }
        }.setFilteringMode(true);
        DataManager.registerDataProvider((JComponent)table, arg_0 -> CVPPanel.lambda$createTable$5((TableView)table, project, arg_0));
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Navigatable[] data;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((data = (Navigatable[])DataManager.getInstance().getDataContext(event.getComponent()).getData(CommonDataKeys.NAVIGATABLE_ARRAY)) == null || data.length == 0) {
                    return false;
                }
                for (Navigatable datum : data) {
                    datum.navigate(true);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/internal/cachedValueProfiler/CVPPanel$4", "onDoubleClick"));
            }
        }.installOn((Component)table);
        for (int i = 0; i < columns.length; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(columns[i].width);
        }
        TableView<CVPInfo> tableView = table;
        if (tableView == null) {
            CVPPanel.$$$reportNull$$$0(5);
        }
        return tableView;
    }

    private static MyColumnInfo[] getColumns() {
        return new MyColumnInfo[]{CVPPanel.columnInfoS(PerformanceTestingBundle.message("cached.value.profiler.column.place", new Object[0]), o -> String.valueOf(o.place), 800, null), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.count", new Object[0]), o -> o.count, 80, "Number of computations of a value"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.total.cost", new Object[0]), o -> o.cost, 120, "Total time to compute a value (ns)"), CVPPanel.columnInfoD(PerformanceTestingBundle.message("cached.value.profiler.column.avg.cost", new Object[0]), o -> (double)o.cost / (double)o.count, 120, "Average time to compute a value (ns)"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.total.use.count", new Object[0]), o -> o.used, 80, "Total number of times a value was read (1-based)"), CVPPanel.columnInfoD(PerformanceTestingBundle.message("cached.value.profiler.column.avg.use.count", new Object[0]), o -> (double)o.used / (double)o.count, 80, "Average number of times a value was read (1-based)"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.aborted", new Object[0]), o -> o.aborted, 80, "Number of times a computation was cancelled or not finished"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.rejected", new Object[0]), o -> o.rejected, 80, "Number of times a computation result was rejected right away<br/>Several computations of a value may succeed at the same time"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.wasted", new Object[0]), o -> o.wasted, 100, "Total time of computations that were later aborted or rejected (ns)"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.max.life.time", new Object[0]), o -> o.lifetime, 200, "Longest period of time between value computation and usage (ns)"), CVPPanel.columnInfoL(PerformanceTestingBundle.message("cached.value.profiler.column.max.limbo.time", new Object[0]), o -> o.limbotime, 200, "Longest period of time between value invalidation and last usage (ns)<br/>'0' means a value was never explicitly invalidated when requested")};
    }

    @NotNull
    private static MyColumnInfo columnInfoL(@Nls String name, ToLongFunction<CVPInfo> value, int width, String tooltip) {
        return CVPPanel.columnInfo(name, o -> CVPPanel.format(value.applyAsLong((CVPInfo)o)), Comparator.comparingLong(value), width, tooltip);
    }

    @NotNull
    private static MyColumnInfo columnInfoS(@Nls String name, Function<CVPInfo, String> value, int width, String tooltip) {
        return CVPPanel.columnInfo(name, value, Comparator.comparing(value), width, tooltip);
    }

    @NotNull
    private static MyColumnInfo columnInfoD(@Nls String name, ToDoubleFunction<CVPInfo> value, int width, String tooltip) {
        return CVPPanel.columnInfo(name, o -> CVPPanel.format(Math.round(value.applyAsDouble((CVPInfo)o))), Comparator.comparingDouble(value), width, tooltip);
    }

    @NotNull
    private static MyColumnInfo columnInfo(@Nls String name, Function<CVPInfo, String> toString, Comparator<CVPInfo> comparator, int width, String tooltip) {
        return new MyColumnInfo(name, toString, comparator, width, tooltip);
    }

    private static String format(long value) {
        return FORMAT.format(value);
    }

    @NotNull
    private static List<CVPInfo> loadInfos(File file) throws IOException {
        class Computed {
            long count;
            long cost;
            long used;
            long lifetime;
            long limbotime;
            long aborted;
            long rejected;
            long wasted;

            Computed() {
            }
        }
        Computed NULL = new Computed();
        Long2ObjectOpenHashMap frames = new Long2ObjectOpenHashMap();
        Map computedMap = FactoryMap.create(o -> new Computed());
        Map abortedMap = FactoryMap.create(o -> {
            class Aborted {
                long count;
                long cost;

                Aborted() {
                }
            }
            return new Aborted();
        });
        HashMap matchedPlaces = new HashMap();
        computedMap.put(null, NULL);
        CachedValueProfilerDumpHelper.loadDump((File)file, (CachedValueProfiler.EventConsumer)new CachedValueProfiler.EventConsumer((Long2ObjectMap)frames, computedMap, matchedPlaces, NULL, abortedMap){
            final /* synthetic */ Long2ObjectMap val$frames;
            final /* synthetic */ Map val$computedMap;
            final /* synthetic */ Map val$matchedPlaces;
            final /* synthetic */ Computed val$NULL;
            final /* synthetic */ Map val$abortedMap;
            {
                this.val$frames = long2ObjectMap;
                this.val$computedMap = map;
                this.val$matchedPlaces = map2;
                this.val$NULL = computed;
                this.val$abortedMap = map3;
            }

            public void onFrameEnter(long frameId, CachedValueProfiler.EventPlace place, long parentId, long time) {
                this.val$frames.put(frameId, (Object)place.getStackFrame());
            }

            public void onFrameExit(long frameId, long start, long computed, long time) {
                StackTraceElement place = (StackTraceElement)this.val$frames.remove(frameId);
                Computed c = (Computed)this.val$computedMap.get(this.val$matchedPlaces.get(place));
                if (computed == 0L) {
                    if (c == this.val$NULL) {
                        Aborted a = (Aborted)this.val$abortedMap.get(place);
                        ++a.count;
                        a.cost += time - start;
                    } else {
                        ++c.aborted;
                        c.wasted += time - start;
                    }
                }
            }

            public void onValueComputed(long frameId, CachedValueProfiler.EventPlace place, long start, long time) {
                Computed c = (Computed)this.val$computedMap.get(place.getStackFrame());
                ++c.count;
                c.cost += time - start;
                StackTraceElement framePlace = (StackTraceElement)this.val$frames.get(frameId);
                if (!this.val$matchedPlaces.containsKey(framePlace)) {
                    this.val$matchedPlaces.put(framePlace, place.getStackFrame());
                    Aborted aborted = (Aborted)this.val$abortedMap.remove(framePlace);
                    if (aborted != null) {
                        c.aborted += aborted.count;
                        c.wasted += aborted.cost;
                    }
                }
            }

            public void onValueUsed(long frameId, CachedValueProfiler.EventPlace place, long computed, long time) {
                Computed c = (Computed)this.val$computedMap.get(place.getStackFrame());
                ++c.used;
                c.lifetime = Math.max(c.lifetime, time - computed);
            }

            public void onValueInvalidated(long frameId, CachedValueProfiler.EventPlace place, long used, long time) {
                Computed c = (Computed)this.val$computedMap.get(place.getStackFrame());
                c.limbotime = Math.max(c.limbotime, time - used);
            }

            public void onValueRejected(long frameId, CachedValueProfiler.EventPlace place, long start, long computed, long time) {
                Computed c = (Computed)this.val$computedMap.get(place.getStackFrame());
                ++c.rejected;
                c.wasted += time - start;
            }
        });
        ArrayList<CVPInfo> result = new ArrayList<CVPInfo>(computedMap.size());
        for (Map.Entry entry : computedMap.entrySet()) {
            if (entry.getKey() == null) continue;
            Computed c = (Computed)entry.getValue();
            result.add(new CVPInfo((StackTraceElement)entry.getKey(), c.count, c.cost, c.used, c.aborted, c.rejected, c.wasted, c.lifetime, c.limbotime));
        }
        ArrayList<CVPInfo> arrayList = result;
        if (arrayList == null) {
            CVPPanel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ Object lambda$createTable$5(TableView table, Project project, String dataId) {
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            NavigationHelper helper = NavigationHelper.getInstance();
            if (helper == null) {
                return null;
            }
            return table.getSelectedObjects().stream().map(o -> helper.getNavigatable(project, o.place)).toArray(Navigatable[]::new);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/cachedValueProfiler/CVPPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/cachedValueProfiler/CVPPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CVPInfo {
        final StackTraceElement place;
        final long count;
        final long cost;
        final long used;
        final long aborted;
        final long rejected;
        final long wasted;
        final long lifetime;
        final long limbotime;

        /*
         * WARNING - void declaration
         */
        CVPInfo(@NotNull StackTraceElement place, long count, long cost, long used, long aborted, long l, long l2, long l3, long l4) {
            void limbotime;
            void lifetime;
            void wasted;
            void rejected;
            if (place == null) {
                CVPInfo.$$$reportNull$$$0(0);
            }
            this.place = place;
            this.count = count;
            this.cost = cost;
            this.used = used;
            this.aborted = aborted;
            this.rejected = rejected;
            this.wasted = wasted;
            this.lifetime = lifetime;
            this.limbotime = limbotime;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/internal/cachedValueProfiler/CVPPanel$CVPInfo", "<init>"));
        }
    }

    private static class MyColumnInfo
    extends ColumnInfo<CVPInfo, String> {
        final Function<CVPInfo, String> toString;
        final Comparator<CVPInfo> comparator;
        final int width;
        final String tooltip;

        MyColumnInfo(@Nls String name, Function<CVPInfo, String> toString, Comparator<CVPInfo> comparator, int width, String tooltip) {
            super(name);
            this.toString = toString;
            this.comparator = comparator;
            this.width = width;
            this.tooltip = tooltip;
        }

        public String valueOf(CVPInfo o) {
            return this.toString.apply(o);
        }

        @Nullable
        public Comparator<CVPInfo> getComparator() {
            return this.comparator;
        }

        @NlsContexts.Tooltip
        @Nullable
        public String getTooltipText() {
            return this.tooltip;
        }
    }
}

