/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.cachedValueProfiler;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class CVPFileType
implements FileType,
INativeFileType {
    public static final CVPFileType INSTANCE = new CVPFileType();

    private CVPFileType() {
    }

    @NotNull
    public String getName() {
        return "CVP";
    }

    @NotNull
    public String getDescription() {
        String string = PerformanceTestingBundle.message("cached.value.profiler.file.description", new Object[0]);
        if (string == null) {
            CVPFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "cvperf";
    }

    public Icon getIcon() {
        return AllIcons.General.ContextHelp;
    }

    public boolean isBinary() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean useNativeIcon() {
        return false;
    }

    public boolean openFileInAssociatedApplication(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            CVPFileType.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CVPFileType.$$$reportNull$$$0(2);
        }
        FileEditorManager.getInstance((Project)project).openEditor(new OpenFileDescriptor(project, file), true);
        String tabName = file.getName();
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Profiler");
        Content content = (Content)JBIterable.of(toolWindow == null ? null : toolWindow.getContentManager().getContents()).find(o -> o.getComponent() instanceof ProfilerDumpPanel && tabName.equals(((ProfilerDumpPanel)o.getComponent()).getTabName()));
        if (toolWindow != null && content != null) {
            toolWindow.activate(() -> toolWindow.getContentManager().setSelectedContent(content, true));
        } else {
            ImportProfilerResultAction.Companion.importProfilerDump(project, file.toNioPath().toFile(), null, null, null);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/cachedValueProfiler/CVPFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/cachedValueProfiler/CVPFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openFileInAssociatedApplication";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

