/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve.impl;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.html.impl.providers.HtmlAttributeValueProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssElementProcessor;
import com.intellij.psi.css.resolve.CssInclusionContext;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.CssSelectorMatcher;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.css.resolve.Match;
import com.intellij.psi.css.resolve.PropertyNameProcessor;
import com.intellij.psi.css.resolve.ResolvingProcessListener;
import com.intellij.psi.css.resolve.impl.XhtmlFileInfo;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssResolverImpl
implements CssResolver {
    private static final Logger LOG = Logger.getInstance(XhtmlFileInfo.class);
    @NonNls
    static final String PERSISTENT_STYLE_SHEET_NAME = "__$persistent$__";
    private static final Match[] ZERO_MATCHES = new Match[0];
    private final Map<String, Match> myMatchMap = new LinkedHashMap<String, Match>();
    private final Map<String, Map<String, Match>> myPseudoClassesMatchMap = new HashMap<String, Map<String, Match>>(1);
    private XmlTag myTag;
    @Nullable
    private String myStyleSheetName;
    private XhtmlFileInfo myXhtmlFileInfo;
    private CssStylesheet myDefaultStylesheet;
    @NonNls
    private static final String INCLUDE_TAG_NAME = "include";
    private ResolvingProcessListener myListener;
    private boolean myStrictResolveMode;
    private boolean myProcessAllCssFilesMode = false;
    private String myResolvedAttrName;
    private boolean myCollectingCompletionVariants = false;
    private boolean myProcessedAllCssFilesInProject = false;
    @NonNls
    private static final String BORDER_TOP_COLOR_PROPERTY_NAME = "border-top-color";
    @NonNls
    private static final String COLOR_PROPERTY_SUFFIX = "-color";
    private boolean myUseAgentStylesheet = true;
    private CssSelectorMatcher mySelectorMatcher;
    private static final Map<String, String> ElementaryPropertiesWithPositionedSuffixes = new HashMap<String, String>();
    private static final Map<String, String> ElementaryPropertiesWithPositionedSuffixes2 = new HashMap<String, String>();
    private static final Map<String, String> ElementaryPropertiesWithPositionedSuffixes3 = new HashMap<String, String>();
    @NonNls
    private static final String[] POSITION_SUFFIXES = new String[]{"-top", "-right", "-bottom", "-left"};
    @NonNls
    private static final String[] POSITION_SUFFIXES2 = new String[]{"-x", "-y"};
    @NonNls
    private static final String[] POSITION_SUFFIXES3 = new String[]{"-top-left", "-top-right", "-bottom-left", "-bottom-right"};

    public boolean isCollectingCompletionVariants() {
        return this.myCollectingCompletionVariants;
    }

    public void setSelectorMatcher(CssSelectorMatcher selectorMatcher) {
        this.mySelectorMatcher = selectorMatcher;
    }

    public boolean hasProcessedAllCssFilesInProject() {
        return this.myProcessedAllCssFilesInProject;
    }

    public void setCollectingCompletionVariants(boolean collectingCompletionVariants) {
        this.myCollectingCompletionVariants = collectingCompletionVariants;
    }

    public void setDefaultStylesheet(CssStylesheet stylesheet) {
        this.myDefaultStylesheet = stylesheet;
    }

    public void setResolvingProcessListener(ResolvingProcessListener listener) {
        this.myListener = listener;
    }

    public void setStrictResolveMode(boolean strictMode) {
        this.myStrictResolveMode = true;
    }

    public void setProcessAllCssFilesMode(boolean processAllCssFilesMode) {
        this.myProcessAllCssFilesMode = processAllCssFilesMode;
    }

    public CssDeclaration[] resolve(XmlTag tag) {
        return this.resolve(tag, CssResolverImpl.getTopLevelFiles(tag), null);
    }

    public CssRuleset[] resolveAll(XmlFile file) {
        final HashSet rules = new HashSet(3);
        CssElementProcessor processor = new CssElementProcessor(){

            public boolean process(@NotNull CssRuleset ruleset) {
                if (ruleset == null) {
                    1.$$$reportNull$$$0(0);
                }
                rules.add(ruleset);
                ProgressIndicatorProvider.checkCanceled();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/psi/css/resolve/impl/CssResolverImpl$1", "process"));
            }
        };
        this.processStyles((PsiFile[])new XmlFile[]{file}, processor, false);
        return rules.toArray(CssRuleset.EMPTY_ARRAY);
    }

    public void setUseAgentStylesheet(boolean b) {
        this.myUseAgentStylesheet = b;
    }

    public void setResolvedAttrName(String s) {
        this.myResolvedAttrName = s;
    }

    public String getResolvedAttrName() {
        return this.myResolvedAttrName;
    }

    public String[] resolveStyleSheetNames(XmlFile file) {
        this.init(file);
        List result = ContainerUtil.mapNotNull(this.myXhtmlFileInfo.getStylesheetInfos(), info -> info.getReferencedStylesheetName());
        result.remove(PERSISTENT_STYLE_SHEET_NAME);
        return ArrayUtilRt.toStringArray((Collection)result);
    }

    public void processAllRulesetsForTag(@NotNull XmlTag tag, @NotNull Processor<? super CssRuleset> rulesetProcessor) {
        if (tag == null) {
            CssResolverImpl.$$$reportNull$$$0(0);
        }
        if (rulesetProcessor == null) {
            CssResolverImpl.$$$reportNull$$$0(1);
        }
        this.myTag = tag;
        this.clearMatches();
        PsiFile[] topLevelFiles = CssResolverImpl.getTopLevelFiles(tag);
        CssElementProcessor processor = this.createProcessor(rulesetProcessor);
        this.processStyles(topLevelFiles, processor, true);
    }

    @NotNull
    private CssElementProcessor createProcessor(final @NotNull Processor<? super CssRuleset> rulesetProcessor) {
        if (rulesetProcessor == null) {
            CssResolverImpl.$$$reportNull$$$0(2);
        }
        return new CssElementProcessor(){

            public boolean process(@NotNull CssRuleset ruleset) {
                CssSelector[] selectors;
                CssSelector matchingSelector;
                if (ruleset == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !ruleset.isValid() || (matchingSelector = CssResolverImpl.this.getMatchingSelector(selectors = ruleset.getSelectors())) == null || rulesetProcessor.process((Object)ruleset);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/psi/css/resolve/impl/CssResolverImpl$2", "process"));
            }
        };
    }

    private static PsiFile @NotNull [] getTopLevelFiles(@NotNull XmlTag tag) {
        if (tag == null) {
            CssResolverImpl.$$$reportNull$$$0(3);
        }
        if (tag.isValid()) {
            PsiFile xmlFile = tag.getContainingFile();
            PsiFile file = InjectedLanguageManager.getInstance((Project)tag.getProject()).getTopLevelFile((PsiElement)tag);
            if (file instanceof XmlFile) {
                PsiFile[] psiFileArray;
                if (file == xmlFile) {
                    PsiFile[] psiFileArray2 = new PsiFile[1];
                    psiFileArray = psiFileArray2;
                    psiFileArray2[0] = file;
                } else {
                    PsiFile[] psiFileArray3 = new PsiFile[2];
                    psiFileArray3[0] = xmlFile;
                    psiFileArray = psiFileArray3;
                    psiFileArray3[1] = file;
                }
                if (psiFileArray == null) {
                    CssResolverImpl.$$$reportNull$$$0(4);
                }
                return psiFileArray;
            }
            for (Language language : file.getViewProvider().getLanguages()) {
                PsiFile topLevelFile;
                if (!language.isKindOf((Language)XMLLanguage.INSTANCE) || !((topLevelFile = file.getViewProvider().getPsi(language)) instanceof XmlFile)) continue;
                PsiFile[] psiFileArray = new PsiFile[]{xmlFile, topLevelFile};
                if (psiFileArray == null) {
                    CssResolverImpl.$$$reportNull$$$0(5);
                }
                return psiFileArray;
            }
            PsiFile[] psiFileArray = new PsiFile[]{xmlFile};
            if (psiFileArray == null) {
                CssResolverImpl.$$$reportNull$$$0(6);
            }
            return psiFileArray;
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            CssResolverImpl.$$$reportNull$$$0(7);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    private void clearMatches() {
        this.myMatchMap.clear();
        this.myPseudoClassesMatchMap.clear();
    }

    public CssDeclaration[] resolve(XmlTag tag, PsiFile[] xhtmlFiles, @Nullable String styleSheet) {
        this.doResolve(tag, xhtmlFiles, styleSheet);
        return this.getDeclarationsFromMatchMap();
    }

    public StylesheetFile @NotNull [] resolveStyleSheets(@NotNull XmlFile file, @Nullable String styleSheet) {
        if (file == null) {
            CssResolverImpl.$$$reportNull$$$0(8);
        }
        LinkedHashSet<StylesheetFile> myFileSet = null;
        this.init(file);
        this.myStyleSheetName = styleSheet != null ? styleSheet : this.myXhtmlFileInfo.getPreferredStylesheetName();
        for (XhtmlFileInfo.StylesheetInfo info : this.myXhtmlFileInfo.getStylesheetInfos()) {
            PsiFile psiFile;
            if (info.isSpecificMedia() || info.isDirectlyReferenced() && !this.isAcceptableStyleSheetName(info.getReferencedStylesheetName()) || !((psiFile = info.getStylesheet().getContainingFile()) instanceof StylesheetFile) || "css2default_.css".equals(psiFile.getName())) continue;
            if (myFileSet == null) {
                myFileSet = new LinkedHashSet<StylesheetFile>();
            }
            myFileSet.add((StylesheetFile)psiFile);
        }
        StylesheetFile[] stylesheetFileArray = myFileSet != null ? myFileSet.toArray(StylesheetFile.EMPTY_ARRAY) : StylesheetFile.EMPTY_ARRAY;
        if (stylesheetFileArray == null) {
            CssResolverImpl.$$$reportNull$$$0(9);
        }
        return stylesheetFileArray;
    }

    private boolean isAcceptableStyleSheetName(String styleSheetName) {
        return this.myStyleSheetName == null || this.myStyleSheetName.equals(styleSheetName) || PERSISTENT_STYLE_SHEET_NAME.equals(styleSheetName);
    }

    private void doResolve(@NotNull XmlTag tag, PsiFile[] xhtmlFiles, String styleSheetName) {
        PsiFile file;
        if (tag == null) {
            CssResolverImpl.$$$reportNull$$$0(10);
        }
        if ((file = tag.getContainingFile()) instanceof XmlFile) {
            this.init((XmlFile)file);
        }
        this.myStyleSheetName = styleSheetName != null ? styleSheetName : this.myXhtmlFileInfo.getPreferredStylesheetName();
        this.myTag = tag;
        this.clearMatches();
        MyTagResolveProcessor processor = new MyTagResolveProcessor();
        this.processStyles(xhtmlFiles, processor, false);
        XmlAttribute attribute = this.myTag.getAttribute("style", null);
        if (attribute != null && this.myTag.getAttributeValue("style") != null) {
            XmlAttributeValue attributeValue = attribute.getValueElement();
            CssBlock childOfType = (CssBlock)PsiTreeUtil.getChildOfType((PsiElement)attributeValue, CssBlock.class);
            boolean seenDcls = false;
            if (childOfType != null) {
                for (CssDeclaration cssDeclaration : childOfType.getDeclarations()) {
                    processor.process(cssDeclaration);
                    seenDcls = true;
                }
            }
            if (!seenDcls) {
                for (CssDeclaration cssDeclaration : this.myTag.getAttributes()) {
                    List list;
                    XmlAttributeValue valueElement = cssDeclaration.getValueElement();
                    if (valueElement == null || (list = InjectedLanguageManager.getInstance((Project)valueElement.getProject()).getInjectedPsiFiles((PsiElement)valueElement)) == null) continue;
                    for (Pair pair : list) {
                        CssBlock block;
                        CssStylesheet stylesheet;
                        if (!(pair.getFirst() instanceof StylesheetFile) || (stylesheet = ((StylesheetFile)pair.getFirst()).getStylesheet()) == null || (block = stylesheet.getRulesets()[0].getBlock()) == null) continue;
                        for (CssDeclaration declaration : block.getDeclarations()) {
                            processor.process(declaration);
                        }
                    }
                }
            }
        }
    }

    public Map<String, Map<String, CssDeclaration>> resolveActiveDeclarations(XmlTag tag, XmlFile[] xhtmlFiles) {
        this.doResolve(tag, (PsiFile[])xhtmlFiles, null);
        HashMap<String, Map<String, CssDeclaration>> resultMap = new HashMap<String, Map<String, CssDeclaration>>(1);
        HashMap<String, CssDeclaration> result = new HashMap<String, CssDeclaration>(this.myMatchMap.size());
        resultMap.put("", result);
        for (Map.Entry<String, Match> entry : this.myMatchMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getDeclaration());
        }
        for (Map.Entry<String, Object> entry : this.myPseudoClassesMatchMap.entrySet()) {
            result = new HashMap(((Map)entry.getValue()).size());
            resultMap.put(entry.getKey(), result);
            for (Map.Entry match : ((Map)entry.getValue()).entrySet()) {
                result.put((String)match.getKey(), ((Match)match.getValue()).getDeclaration());
            }
        }
        return resultMap;
    }

    @Nullable
    public String getAttributeValue(@NotNull XmlTag tag, @NotNull String attributeName) {
        if (tag == null) {
            CssResolverImpl.$$$reportNull$$$0(11);
        }
        if (attributeName == null) {
            CssResolverImpl.$$$reportNull$$$0(12);
        }
        for (HtmlAttributeValueProvider provider : HtmlAttributeValueProvider.EP_NAME.getExtensionList()) {
            String customAttributeValue = provider.getCustomAttributeValues(tag, attributeName);
            if (customAttributeValue == null) continue;
            return customAttributeValue;
        }
        return tag.getAttributeValue(attributeName);
    }

    private static boolean doProcess(PsiFile psifile, CssElementProcessor processor, boolean withImports, boolean allMedias) {
        if (psifile instanceof StylesheetFile && psifile.isValid()) {
            CssResolverImpl.processStylesheet(((StylesheetFile)psifile).getStylesheet(), processor, withImports, allMedias);
        }
        return true;
    }

    public static void processStyles(@NotNull Module module, CssElementProcessor processor, @NotNull PsiFile expectedFile) {
        if (module == null) {
            CssResolverImpl.$$$reportNull$$$0(13);
        }
        if (expectedFile == null) {
            CssResolverImpl.$$$reportNull$$$0(14);
        }
        Project project = module.getProject();
        Collection<VirtualFile> cssFiles = CssResolverImpl.getCssFiles(module, expectedFile);
        PsiManager manager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : cssFiles) {
            PsiFile psifile;
            if (!file.isValid() || expectedFile.equals(psifile = manager.findFile(file)) || CssResolverImpl.doProcess(psifile, processor, true, false)) continue;
            return;
        }
    }

    private static Collection<VirtualFile> getCssFiles(Module module, @Nullable PsiFile contextFile) {
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForModule(module, contextFile);
        Collection cssFiles = FileTypeIndex.getFiles((FileType)CssFileType.INSTANCE, (GlobalSearchScope)scope);
        for (Language dialects : CssFileType.INSTANCE.getLanguage().getDialects()) {
            LanguageFileType fileType = dialects.getAssociatedFileType();
            if (fileType == null) continue;
            cssFiles.addAll(FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)scope));
        }
        return cssFiles;
    }

    private void processStyles(PsiFile[] xhtmlFiles, CssElementProcessor processor, boolean allMedias) {
        this.processDefaultStylesheet(processor);
        boolean seenJspFile = false;
        boolean seenOnlyFragments = false;
        boolean cssStylesheetsScanned = false;
        for (PsiFile xhtmlFile : xhtmlFiles) {
            if (xhtmlFile == null) continue;
            try {
                cssStylesheetsScanned |= this.processOneFile(xhtmlFile, processor, true, null, true, allMedias);
            }
            catch (PsiInvalidElementAccessException e) {
                VirtualFile vFile = xhtmlFile.getVirtualFile();
                if (vFile != null) {
                    LOG.error("InvalidElementAccess", new Throwable(), new Attachment[]{AttachmentFactory.createAttachment((VirtualFile)vFile)});
                }
                throw e;
            }
            seenJspFile |= LanguageUtil.isInTemplateLanguageFile((PsiElement)xhtmlFile);
            if (!(xhtmlFile instanceof XmlFile)) {
                seenJspFile = true;
                continue;
            }
            XmlDocument doc = HtmlUtil.getRealXmlDocument((XmlDocument)((XmlFile)xhtmlFile).getDocument());
            XmlTag rootTag = doc != null ? doc.getRootTag() : null;
            seenOnlyFragments |= rootTag != null && !"html".equals(rootTag.getLocalName());
        }
        if (!this.myStrictResolveMode && xhtmlFiles[0] != null && this.myTag != null && (this.shouldProcessAllCssFiles((PsiElement)this.myTag) || (seenJspFile || seenOnlyFragments) && !cssStylesheetsScanned)) {
            String selector;
            this.myProcessedAllCssFilesInProject = true;
            Project project = this.myTag.getProject();
            PsiFile xhtmlFile = xhtmlFiles[0];
            VirtualFile virtualFile = xhtmlFile.getOriginalFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Module moduleForFile = fileIndex.getModuleForFile(virtualFile);
            if (moduleForFile == null) {
                return;
            }
            Collection<VirtualFile> cssFiles = CssResolverImpl.getCssFiles(moduleForFile, xhtmlFile);
            PsiManager instance = PsiManager.getInstance((Project)project);
            String resolvedAttrName = xhtmlFile.getOriginalFile() == xhtmlFile ? this.getResolvedAttrName() : null;
            String string = selector = resolvedAttrName != null ? this.myTag.getAttributeValue(resolvedAttrName, null) : null;
            if (selector == null) {
                for (VirtualFile file : cssFiles) {
                    PsiFile psifile;
                    if (!file.isValid() || CssResolverImpl.doProcess(psifile = instance.findFile(file), processor, false, allMedias)) continue;
                    return;
                }
                CssResolverImpl.processSelectorsWithAmpersand(project, GlobalSearchScope.filesScope((Project)project, cssFiles), processor);
            } else {
                XmlAttributeValue valueElement;
                XmlAttribute attribute = this.myTag.getAttribute(resolvedAttrName);
                if (attribute != null && (valueElement = attribute.getValueElement()) != null) {
                    CssSelectorSuffixType selectorType = HtmlCssClassOrIdReference.isIdAttribute(attribute) ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
                    GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForModule(moduleForFile, xhtmlFile);
                    PairProcessor suffixProcessor = (name, selectorSuffix) -> {
                        CssRuleset ruleset = selectorSuffix.getRuleset();
                        return ruleset == null || processor.process(ruleset);
                    };
                    String attributeValue = this.getAttributeValue(this.myTag, resolvedAttrName);
                    for (String className : CssUtil.getClassNames(attributeValue, (PsiElement)valueElement, null)) {
                        CssIndexUtil.processSelectorSuffixes(selectorType, className, project, scope, (PairProcessor<? super String, ? super CssSelectorSuffix>)suffixProcessor);
                    }
                    CssResolverImpl.processSelectorsWithAmpersand(project, scope, processor);
                    CssResolverImpl.processRelatedStylesheets(this.myTag.getContainingFile(), processor, allMedias);
                }
            }
        }
    }

    private static void processSelectorsWithAmpersand(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull CssElementProcessor processor) {
        if (project == null) {
            CssResolverImpl.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            CssResolverImpl.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            CssResolverImpl.$$$reportNull$$$0(17);
        }
        CssIndexUtil.processAmpersandSelectors(project, scope, (Processor<? super CssSelector>)((Processor)ampersandSelector -> {
            CssRuleset ruleset = ampersandSelector.getRuleset();
            return ruleset == null || processor.process(ruleset);
        }));
    }

    private boolean shouldProcessAllCssFiles(@Nullable PsiElement contextElement) {
        if (contextElement != null) {
            for (CssInclusionContext context : CssInclusionContext.EXTENSION_POINT_NAME.getExtensionList()) {
                if (!context.processAllCssFilesOnResolving(contextElement)) continue;
                return true;
            }
        }
        return this.myProcessAllCssFilesMode;
    }

    private static boolean processRelatedStylesheets(@NotNull PsiFile file, @NotNull CssElementProcessor processor, boolean allMedias) {
        if (file == null) {
            CssResolverImpl.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            CssResolverImpl.$$$reportNull$$$0(19);
        }
        boolean result = false;
        for (CssInclusionContext context : CssInclusionContext.EXTENSION_POINT_NAME.getExtensionList()) {
            for (PsiFile contextFile : context.getContextFiles(file)) {
                CssStylesheet stylesheet = context.getStylesheet(contextFile);
                if (stylesheet == null) continue;
                CssResolverImpl.processStylesheet(stylesheet, processor, true, allMedias);
                result = true;
            }
        }
        return result;
    }

    public boolean processOneFile(XmlFile xmlFile, CssElementProcessor processor, boolean withImports) {
        return this.processOneFile((PsiFile)xmlFile, processor, true, null, withImports, false);
    }

    private boolean processOneFile(PsiFile psi, CssElementProcessor processor, boolean topLevel, Set<PsiFile> visited, boolean withImports, boolean allMedias) {
        XmlTag headTag;
        if (!(psi instanceof XmlFile) || !psi.isValid()) {
            return false;
        }
        XmlFile xhtmlFile = (XmlFile)psi;
        this.init(xhtmlFile);
        boolean result = withImports && this.processLinks(processor, allMedias);
        XmlDocument document = xhtmlFile.getDocument();
        result |= CssResolverImpl.processStyleTag(document, processor, withImports, allMedias);
        result |= CssResolverImpl.processRelatedStylesheets(psi, processor, allMedias);
        XmlTag xmlTag = headTag = document == null ? null : AbstractTagUtil.findGenericHeadTag(document);
        if (LanguageUtil.isInTemplateLanguageFile((PsiElement)xhtmlFile)) {
            XmlTag rootTag;
            XmlDocument _document;
            FileViewProvider viewProvider;
            PsiFile psiFile;
            if (topLevel) {
                VirtualFile virtualFile;
                XmlTag rootTag2;
                if (headTag == null && document != null && (rootTag2 = document.getRootTag()) != null) {
                    result |= CssResolverImpl.processStylesRecursively(rootTag2, processor, result, withImports, allMedias);
                    for (PsiElement el = rootTag2.getNextSibling(); el != null; el = el.getNextSibling()) {
                        if (!(el instanceof XmlTag)) continue;
                        result |= CssResolverImpl.processStylesRecursively((XmlTag)el, processor, result, withImports, allMedias);
                    }
                    result |= CssResolverImpl.processInjectedContent((PsiElement)xhtmlFile.getDocument(), processor, withImports, allMedias);
                }
                boolean[] includeResult = new boolean[1];
                if (withImports && (psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)xhtmlFile)) != null && (virtualFile = psiFile.getVirtualFile()) != null) {
                    VirtualFile[] files;
                    for (VirtualFile file : files = FileIncludeManager.getManager((Project)xhtmlFile.getProject()).getIncludedFiles(virtualFile, false)) {
                        PsiFile psiFile1 = xhtmlFile.getManager().findFile(file);
                        if (!(psiFile1 instanceof XmlFile)) continue;
                        includeResult[0] = includeResult[0] | this.processOneFile(psiFile1, processor, false, visited, true, allMedias);
                    }
                }
                result |= includeResult[0];
            }
            if (withImports && (psiFile = (viewProvider = xhtmlFile.getViewProvider()).getPsi(viewProvider.getBaseLanguage())) instanceof XmlFile && (_document = ((XmlFile)psiFile).getDocument()) != null && (rootTag = _document.getRootTag()) != null) {
                result |= this.processRuntimeIncludes(rootTag, processor, visited, allMedias);
            }
        }
        return result;
    }

    private boolean processRuntimeIncludes(XmlTag rootTag, CssElementProcessor processor, Set<PsiFile> visited, boolean allMedias) {
        if (visited == null) {
            visited = new HashSet<PsiFile>(4);
        }
        visited.add(rootTag.getContainingFile());
        boolean result = false;
        for (XmlTag tag : rootTag.getSubTags()) {
            if (INCLUDE_TAG_NAME.equals(tag.getLocalName()) && "http://java.sun.com/JSP/Page".equals(tag.getNamespace())) {
                PsiElement psiElement;
                PsiReference[] references;
                XmlAttributeValue valueElement;
                XmlAttribute attribute = tag.getAttribute("page", null);
                if (attribute == null || (valueElement = attribute.getValueElement()) == null || (references = valueElement.getReferences()).length <= 0 || !((psiElement = references[references.length - 1].resolve()) instanceof PsiFile) || !LanguageUtil.isInTemplateLanguageFile((PsiElement)psiElement) || visited.contains((PsiFile)psiElement) || !(psiElement instanceof XmlFile)) continue;
                result |= this.processOneFile((PsiFile)((XmlFile)psiElement), processor, false, visited, true, allMedias);
                continue;
            }
            result |= this.processRuntimeIncludes(tag, processor, visited, allMedias);
        }
        return result;
    }

    private void init(XmlFile xhtmlFile) {
        this.myXhtmlFileInfo = XhtmlFileInfo.getInfo(xhtmlFile, this.myUseAgentStylesheet);
    }

    private void processDefaultStylesheet(CssElementProcessor processor) {
        CssStylesheet defaultStylesheet = this.myDefaultStylesheet;
        if (defaultStylesheet != null) {
            CssResolverImpl.processStylesheet(defaultStylesheet, processor, true, false);
        }
    }

    private boolean processLinks(CssElementProcessor processor, boolean allMedias) {
        boolean hasDirectRefs = false;
        for (XhtmlFileInfo.StylesheetInfo info : this.myXhtmlFileInfo.getStylesheetInfos()) {
            if (allMedias) {
                if (info.isDirectlyReferenced()) {
                    hasDirectRefs = true;
                }
                CssResolverImpl.processStylesheet(info.getStylesheet(), processor, true, true);
                continue;
            }
            if (info.isSpecificMedia() || info.isDirectlyReferenced() && !this.isAcceptableStyleSheetName(info.getReferencedStylesheetName())) continue;
            if (info.isDirectlyReferenced()) {
                hasDirectRefs = true;
            }
            CssResolverImpl.processStylesheet(info.getStylesheet(), processor, true, false);
        }
        return hasDirectRefs;
    }

    private static boolean processStyleTag(XmlDocument document, CssElementProcessor processor, boolean withImports, boolean allMedias) {
        boolean result = false;
        if (document == null) {
            return false;
        }
        ArrayList<XmlTag> tags2look = new ArrayList<XmlTag>();
        XmlTag headTag = AbstractTagUtil.findGenericHeadTag(document);
        if (headTag != null) {
            tags2look.add(headTag);
        } else {
            Collection<XmlTag> styleTags = AbstractTagUtil.findStyleTags(document);
            tags2look.addAll(styleTags);
        }
        XmlTag bodyTag = AbstractTagUtil.findGenericBodyTag(document);
        if (bodyTag != null) {
            tags2look.add(bodyTag);
        }
        for (XmlTag xmlTag : tags2look) {
            XmlTag[] styles;
            String tagName;
            String string = tagName = xmlTag instanceof HtmlTag || !xmlTag.getNamespacePrefix().isEmpty() ? StringUtil.toLowerCase((String)xmlTag.getLocalName()) : xmlTag.getLocalName();
            if ("style".equals(tagName)) {
                result |= CssResolverImpl.processStyleTag(xmlTag, processor, withImports, allMedias);
                XmlTag parentTag = xmlTag.getParentTag();
                if (parentTag != null) {
                    result |= CssResolverImpl.processInjectedContent((PsiElement)parentTag, processor, withImports, allMedias);
                    continue;
                }
                for (PsiElement element = xmlTag.getNextSibling(); element != null; element = element.getNextSibling()) {
                    result |= CssResolverImpl.processInjectedContent(element, processor, withImports, allMedias);
                }
                continue;
            }
            for (XmlTag styleTag : styles = xmlTag.findSubTags("style")) {
                result |= CssResolverImpl.processStyleTag(styleTag, processor, withImports, allMedias);
            }
            result |= CssResolverImpl.processInjectedContent((PsiElement)xmlTag, processor, withImports, allMedias);
        }
        return result;
    }

    private static boolean processInjectedContent(PsiElement element, CssElementProcessor processor, boolean withImports, boolean allMedias) {
        boolean[] result;
        block6: {
            XmlComment[] comments;
            PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor;
            block7: {
                block5: {
                    result = new boolean[]{false};
                    injectedPsiVisitor = (injectedPsi, places) -> {
                        XmlTag rootTag;
                        XmlDocument injectedDocument;
                        if (injectedPsi instanceof XmlFile && (injectedDocument = ((XmlFile)injectedPsi).getDocument()) != null && (rootTag = injectedDocument.getRootTag()) != null) {
                            for (XmlTag element1 = rootTag; element1 != null; element1 = element1.getNextSibling()) {
                                if (!(element1 instanceof XmlTag)) continue;
                                XmlTag tag = element1;
                                String tagName = tag.getLocalName();
                                if (element1 instanceof HtmlTag || !tag.getNamespacePrefix().isEmpty()) {
                                    tagName = StringUtil.toLowerCase((String)tagName);
                                }
                                if (!"style".equals(tagName)) continue;
                                result[0] = result[0] | CssResolverImpl.processStyleTag(tag, processor, withImports, allMedias);
                            }
                        }
                    };
                    if (!(element instanceof XmlComment) || !(element instanceof PsiLanguageInjectionHost)) break block5;
                    InjectedLanguageManager.getInstance((Project)element.getProject()).enumerate(element, injectedPsiVisitor);
                    break block6;
                }
                if (!(element instanceof XmlText)) break block7;
                for (PsiElement _element : element.getChildren()) {
                    if (!(_element instanceof PsiLanguageInjectionHost)) continue;
                    InjectedLanguageManager.getInstance((Project)element.getProject()).enumerate(_element, injectedPsiVisitor);
                }
                break block6;
            }
            XmlText[] texts = (XmlText[])PsiTreeUtil.getChildrenOfType((PsiElement)element, XmlText.class);
            if (texts != null && texts.length > 0) {
                for (XmlText text : texts) {
                    for (PsiElement _element : text.getChildren()) {
                        if (!(_element instanceof PsiLanguageInjectionHost)) continue;
                        InjectedLanguageManager.getInstance((Project)element.getProject()).enumerate(_element, injectedPsiVisitor);
                    }
                }
            }
            if ((comments = (XmlComment[])PsiTreeUtil.getChildrenOfType((PsiElement)element, XmlComment.class)) == null || comments.length <= 0) break block6;
            for (XmlComment comment : comments) {
                if (!(comment instanceof PsiLanguageInjectionHost)) continue;
                InjectedLanguageManager.getInstance((Project)element.getProject()).enumerate((PsiElement)comment, injectedPsiVisitor);
            }
        }
        return result[0];
    }

    private static boolean processStylesRecursively(XmlTag tag, CssElementProcessor processor, boolean result, boolean withImports, boolean allMedias) {
        if ("style".equalsIgnoreCase(tag.getName())) {
            result |= CssResolverImpl.processStyleTag(tag, processor, withImports, allMedias);
        } else {
            for (XmlTag subTag : tag.getSubTags()) {
                result |= CssResolverImpl.processStylesRecursively(subTag, processor, result, withImports, allMedias);
            }
        }
        return result |= CssResolverImpl.processInjectedContent((PsiElement)tag, processor, withImports, allMedias);
    }

    private static boolean processStyleTag(XmlTag styleTag, CssElementProcessor processor, boolean withImports, boolean allMedias) {
        boolean result = false;
        CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getChildOfType((PsiElement)styleTag, CssStylesheet.class);
        if (stylesheet != null) {
            CssResolverImpl.processStylesheet(stylesheet, processor, withImports, allMedias);
            result = true;
        } else {
            XmlTagChild[] tagChildren = styleTag.getValue().getChildren();
            if (tagChildren.length > 0 && tagChildren[0] instanceof PsiLanguageInjectionHost) {
                CssStylesheet[] resultArray = new CssStylesheet[1];
                InjectedLanguageManager.getInstance((Project)styleTag.getProject()).enumerate((PsiElement)tagChildren[0], (injectedPsi, places) -> {
                    if (injectedPsi instanceof StylesheetFile) {
                        resultArray[0] = ((StylesheetFile)injectedPsi).getStylesheet();
                    }
                });
                if (resultArray[0] != null) {
                    CssResolverImpl.processStylesheet(resultArray[0], processor, withImports, allMedias);
                    result = true;
                }
            }
        }
        return result;
    }

    public static void processStylesheet(@Nullable CssStylesheet stylesheet, CssElementProcessor processor, boolean withImports, boolean allMedias) {
        CssRuleset[] rulesets;
        if (stylesheet == null) {
            return;
        }
        processor.process(stylesheet);
        for (CssRuleset ruleset : rulesets = withImports ? stylesheet.getRulesets(allMedias) : stylesheet.getRulesetList().getRulesets(allMedias)) {
            processor.process(ruleset);
        }
    }

    private CssDeclaration[] getDeclarationsFromMatchMap() {
        LinkedHashSet<CssDeclaration> set = new LinkedHashSet<CssDeclaration>(this.myMatchMap.size());
        for (Match match : this.myMatchMap.values()) {
            set.add(match.getDeclaration());
        }
        for (Map map : this.myPseudoClassesMatchMap.values()) {
            for (Match match : map.values()) {
                set.add(match.getDeclaration());
            }
        }
        return set.toArray(CssDeclaration.EMPTY_ARRAY);
    }

    private Match[] getMatches(CssRuleset ruleset) {
        CssBlock block;
        CssSelectorSuffix lastSelectorSuffix;
        CssSelectorList selectorList = ruleset.getSelectorList();
        if (selectorList == null) {
            return ZERO_MATCHES;
        }
        CssSelector selector = this.getMatchingSelector(selectorList.getSelectors());
        if (selector == null) {
            return ZERO_MATCHES;
        }
        String pseudoClass = null;
        CssSimpleSelector lastSimpleSelector = (CssSimpleSelector)ArrayUtil.getLastElement((Object[])selector.getSimpleSelectors());
        if (lastSimpleSelector != null && (lastSelectorSuffix = (CssSelectorSuffix)ArrayUtil.getLastElement((Object[])lastSimpleSelector.getSelectorSuffixes())) instanceof CssPseudoClass) {
            pseudoClass = lastSelectorSuffix.getName();
        }
        if ((block = ruleset.getBlock()) == null) {
            return ZERO_MATCHES;
        }
        CssDeclaration[] declarations = block.getDeclarations();
        Match[] matches = new Match[declarations.length];
        for (int i = 0; i < matches.length; ++i) {
            matches[i] = new Match(selector, declarations[i], pseudoClass);
        }
        return matches;
    }

    @Nullable
    private CssSelector getMatchingSelector(CssSelector @NotNull [] selectors) {
        if (selectors == null) {
            CssResolverImpl.$$$reportNull$$$0(20);
        }
        for (CssSelector selector : selectors) {
            ProgressIndicatorProvider.checkCanceled();
            if (!selector.isValid() || !(this.mySelectorMatcher != null ? this.mySelectorMatcher.isMatch(selector, this.myTag, (CssResolver)this) : selector.isMatch(this.myTag, (CssResolver)this, null))) continue;
            return selector;
        }
        return null;
    }

    private boolean isMatchAnySubTag(CssSelector @NotNull [] selectors) {
        if (selectors == null) {
            CssResolverImpl.$$$reportNull$$$0(21);
        }
        for (CssSelector selector : selectors) {
            ProgressIndicatorProvider.checkCanceled();
            if (!selector.isValid() || !selector.isHierarchicalSelectorThatMatchesSubtag(this.myTag, (CssResolver)this)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean processDependentPropertiesInner(String propertyName, CssPropertyDescriptor descriptor, PropertyNameProcessor processor) {
        if (descriptor == null) {
            return true;
        }
        String[] refNames = descriptor.getRefNames();
        if (refNames != null) {
            for (String string : refNames) {
                void var7_7;
                if (BORDER_TOP_COLOR_PROPERTY_NAME.equals(string)) {
                    String string2 = propertyName + COLOR_PROPERTY_SUFFIX;
                }
                if (!processor.process((String)var7_7, true)) {
                    return false;
                }
                CssPropertyDescriptor nestedDescriptor = CssDescriptorsUtil.getPropertyDescriptor((String)var7_7, null);
                if (!(nestedDescriptor != null && nestedDescriptor.getRefNames() != null ? !CssResolverImpl.processDependentPropertiesInner((String)var7_7, nestedDescriptor, processor) : !CssResolverImpl.handleElementaryProperty((String)var7_7, null, processor))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processDependentProperties(CssDeclaration declaration, PropertyNameProcessor processor) {
        CssPropertyDescriptor descriptor = declaration.getDescriptor();
        String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)declaration);
        if (descriptor == null) {
            return false;
        }
        if (descriptor.getRefNames() == null) {
            int ind = propertyName.lastIndexOf(45);
            while (ind != -1) {
                CssPropertyDescriptor nestedDescriptor;
                String shortHandPropertyName = propertyName.substring(0, ind);
                String elementName = ElementaryPropertiesWithPositionedSuffixes.get(shortHandPropertyName);
                if (elementName == null) {
                    elementName = ElementaryPropertiesWithPositionedSuffixes2.get(shortHandPropertyName);
                }
                if (elementName == null) {
                    elementName = ElementaryPropertiesWithPositionedSuffixes3.get(shortHandPropertyName);
                }
                if (elementName != null) {
                    shortHandPropertyName = elementName;
                }
                if ((nestedDescriptor = CssDescriptorsUtil.getPropertyDescriptor((String)shortHandPropertyName, (PsiElement)declaration)) != null && !processor.process(shortHandPropertyName, false)) {
                    return false;
                }
                if (ind <= 0) break;
                ind = propertyName.lastIndexOf(45, ind - 1);
            }
            return CssResolverImpl.handleElementaryProperty(propertyName, (PsiElement)declaration, processor);
        }
        CssResolverImpl.processDependentPropertiesInner(propertyName, descriptor, processor);
        return true;
    }

    private static boolean handleElementaryProperty(String propertyName, @Nullable PsiElement context, PropertyNameProcessor processor) {
        String positionedPropertyName = ElementaryPropertiesWithPositionedSuffixes.get(propertyName);
        String[] table = POSITION_SUFFIXES;
        if (positionedPropertyName == null) {
            positionedPropertyName = ElementaryPropertiesWithPositionedSuffixes2.get(propertyName);
            table = POSITION_SUFFIXES2;
        }
        if (positionedPropertyName == null) {
            positionedPropertyName = ElementaryPropertiesWithPositionedSuffixes3.get(propertyName);
            table = POSITION_SUFFIXES3;
        }
        if (propertyName.equals(positionedPropertyName)) {
            int i = propertyName.indexOf(45);
            String shortHandPropertyName = i != -1 ? propertyName.substring(0, i) : propertyName;
            String propertySuffix = i != -1 ? propertyName.substring(i) : "";
            for (String s : table) {
                String definedPropertyName = shortHandPropertyName + s + propertySuffix;
                CssPropertyDescriptor nestedDescriptor = CssDescriptorsUtil.getPropertyDescriptor((String)definedPropertyName, (PsiElement)context);
                if (nestedDescriptor == null || processor.process(definedPropertyName, true)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        @NonNls String[] POSITIONED_ELEMENTS = new String[]{"padding", "margin", "border-width", "border-style", "border-color"};
        @NonNls String[] POSITIONED_ELEMENTS2 = new String[]{"overflow"};
        @NonNls String[] POSITIONED_ELEMENTS3 = new String[]{"border-radius"};
        for (String el : POSITIONED_ELEMENTS) {
            ElementaryPropertiesWithPositionedSuffixes.put(el, el);
            for (String s : POSITION_SUFFIXES) {
                ElementaryPropertiesWithPositionedSuffixes.put(el + s, el);
            }
        }
        for (String el : POSITIONED_ELEMENTS2) {
            ElementaryPropertiesWithPositionedSuffixes2.put(el, el);
            for (String s : POSITION_SUFFIXES2) {
                ElementaryPropertiesWithPositionedSuffixes2.put(el + s, el);
            }
        }
        for (String el : POSITIONED_ELEMENTS3) {
            ElementaryPropertiesWithPositionedSuffixes3.put(el, el);
            for (String s : POSITION_SUFFIXES3) {
                ElementaryPropertiesWithPositionedSuffixes3.put(el + s, el);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rulesetProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/impl/CssResolverImpl";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/impl/CssResolverImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveStyleSheets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAllRulesetsForTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveStyleSheets";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processStyles";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processSelectorsWithAmpersand";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processRelatedStylesheets";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingSelector";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isMatchAnySubTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class MyTagResolveProcessor
    extends CssElementProcessor
    implements PropertyNameProcessor {
        private Map<String, Match> myMatchMapToUse;
        private Match myMatchToTest;

        MyTagResolveProcessor() {
        }

        public boolean process(@NotNull CssRuleset ruleset) {
            if (ruleset == null) {
                MyTagResolveProcessor.$$$reportNull$$$0(0);
            }
            ProgressIndicatorProvider.checkCanceled();
            for (Match match2 : CssResolverImpl.this.getMatches(ruleset)) {
                this.processMatch(match2);
            }
            return true;
        }

        private void processMatch(Match match2) {
            CssDeclaration declaration = match2.getDeclaration();
            String propertyName = CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)declaration);
            String pseudoClass = match2.getPseudoClass();
            if (pseudoClass != null) {
                Map<String, Match> map = CssResolverImpl.this.myPseudoClassesMatchMap.get(pseudoClass);
                if (map == null) {
                    map = new LinkedHashMap<String, Match>(5);
                    CssResolverImpl.this.myPseudoClassesMatchMap.put(pseudoClass, map);
                }
                this.myMatchMapToUse = map;
            } else {
                this.myMatchMapToUse = CssResolverImpl.this.myMatchMap;
            }
            this.myMatchToTest = match2;
            this.process(propertyName, true);
            CssResolverImpl.processDependentProperties(declaration, this);
        }

        public boolean process(@NotNull CssDeclaration declaration) {
            if (declaration == null) {
                MyTagResolveProcessor.$$$reportNull$$$0(1);
            }
            this.processMatch(new Match(null, declaration, null));
            return true;
        }

        @Override
        public boolean process(String propertyName, boolean defined) {
            Match match1 = this.myMatchMapToUse.get(propertyName);
            Match match = null;
            if (match1 == null) {
                if (defined) {
                    match = this.myMatchToTest;
                    if (CssResolverImpl.this.myListener != null) {
                        CssResolverImpl.this.myListener.propertyMatched(propertyName, match.getDeclaration());
                    }
                }
            } else if (!match1.getDeclaration().equals(this.myMatchToTest.getDeclaration())) {
                Match match2 = match = match1.compareTo(this.myMatchToTest) <= 0 ? this.myMatchToTest : match1;
                if (match == this.myMatchToTest) {
                    if (CssResolverImpl.this.myListener != null) {
                        CssResolverImpl.this.myListener.propertyOverriden(propertyName, match1.getDeclaration(), this.myMatchToTest.getDeclaration());
                    }
                } else if (CssResolverImpl.this.myListener != null) {
                    CssResolverImpl.this.myListener.propertyOverriden(propertyName, this.myMatchToTest.getDeclaration(), match1.getDeclaration());
                }
            } else {
                match = match1;
            }
            if (match != null) {
                this.myMatchMapToUse.put(propertyName, match);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ruleset";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "declaration";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/resolve/impl/CssResolverImpl$MyTagResolveProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

