/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.completion.LengthUserLookup;
import com.intellij.psi.css.impl.util.completion.PercentageUserLookup;
import com.intellij.psi.css.util.CssSuffixes;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

class InsertUnitQualifier
implements LocalQuickFix {
    private Object[] mySuffixVariants = ArrayUtilRt.EMPTY_OBJECT_ARRAY;

    InsertUnitQualifier(CssDeclaration declaration) {
        CssPropertyDescriptor descriptor = declaration.getDescriptor();
        if (descriptor != null) {
            String[] lengthSuffixes = CssSuffixes.LENGTH_SUFFIXES;
            int variantsCount = (InsertUnitQualifier.allowsLengths(descriptor) ? lengthSuffixes.length : 0) + (InsertUnitQualifier.allowsPercentages(descriptor) ? 1 : 0);
            this.mySuffixVariants = new Object[variantsCount];
            if (InsertUnitQualifier.allowsLengths(descriptor)) {
                System.arraycopy(lengthSuffixes, 0, this.mySuffixVariants, 0, lengthSuffixes.length);
            }
            if (InsertUnitQualifier.allowsPercentages(descriptor)) {
                this.mySuffixVariants[this.mySuffixVariants.length - 1] = "%";
            }
        }
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.inspections.unitless.number.fix.message", (Object[])new Object[0]);
        if (string == null) {
            InsertUnitQualifier.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Editor editor;
        if (project == null) {
            InsertUnitQualifier.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            InsertUnitQualifier.$$$reportNull$$$0(2);
        }
        TemplateManager instance = TemplateManager.getInstance((Project)project);
        Template template = instance.createTemplate("", "");
        TextResult defaultText = new TextResult("px");
        LookupElement[] lookupItems = (LookupElement[])ContainerUtil.map((Object[])this.mySuffixVariants, o -> o instanceof LookupElement ? (LookupElement)o : LookupElementBuilder.create((String)((String)o)), (Object[])LookupElement.EMPTY_ARRAY);
        ConstantNode expression = new ConstantNode((Result)defaultText).withLookupItems(lookupItems);
        template.addVariable("name", (Expression)expression, (Expression)expression, true);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null && (editor = fileEditorManager.openTextEditor(new OpenFileDescriptor(project, containingFile.getVirtualFile(), psiElement.getTextRange().getEndOffset()), false)) != null) {
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{descriptor.getPsiElement().getContainingFile()}).run(() -> instance.startTemplate(editor, template));
        }
    }

    private static boolean allowsLengths(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            InsertUnitQualifier.$$$reportNull$$$0(3);
        }
        return ContainerUtil.findInstance((Object[])descriptor.getAllVariants(), LengthUserLookup.class) != null;
    }

    private static boolean allowsPercentages(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            InsertUnitQualifier.$$$reportNull$$$0(4);
        }
        return ContainerUtil.findInstance((Object[])descriptor.getAllVariants(), PercentageUserLookup.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/InsertUnitQualifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/InsertUnitQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allowsLengths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "allowsPercentages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

