/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.table.AbstractCssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssCompletionContext;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.impl.util.table.CssShorthandExpandProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyDescriptorImpl
extends AbstractCssPropertyDescriptor {
    @NonNls
    private static final TokenSet POSSIBLE_VALUE_PREFIXES = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_SLASH});
    private final CssPropertyInfo[] myCssPropertyInfos;
    private final String myPropertyName;
    private CssPropertyValueImpl myValue;
    private static final Logger LOG = Logger.getInstance(CssPropertyDescriptorImpl.class);

    public CssPropertyDescriptorImpl(@NotNull String propertyName, CssPropertyInfo @NotNull [] infos) {
        if (propertyName == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(1);
        }
        this.myPropertyName = propertyName;
        this.myCssPropertyInfos = infos;
    }

    public boolean isShorthandValue() {
        if (this.getRefNames() != null) {
            return true;
        }
        if ("overflow".equals(this.getPropertyName())) {
            return true;
        }
        String propertyName = this.getPropertyName();
        if (propertyName.startsWith("-moz-border-radius")) {
            return propertyName.equals("-moz-border-radius");
        }
        if (propertyName.contains("border-radius")) {
            return true;
        }
        if ("cursor".equalsIgnoreCase(propertyName)) {
            return false;
        }
        if (propertyName.contains("border") && propertyName.contains("image")) {
            String[] sides = new String[]{"left", "right", "bottom", "top"};
            boolean containsSide = false;
            for (String s : sides) {
                if (!propertyName.contains(s)) continue;
                containsSide = true;
                break;
            }
            if (!containsSide) {
                return true;
            }
        }
        return this.getValue().getMaxValuesCount() == 4;
    }

    @Override
    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(2);
        }
        if (CssPropertyUtil.isVendorSpecificElement(this.getPropertyName())) {
            return true;
        }
        String text = element.getText();
        if (text != null && CssPropertyUtil.isVendorSpecificElement(StringUtil.toLowerCase((String)text))) {
            return true;
        }
        return super.isValidValue(element);
    }

    @Override
    @NotNull
    public CssPropertyValue getValue() {
        CssPropertyValueImpl cssPropertyValueImpl = this.myValue;
        if (cssPropertyValueImpl == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(3);
        }
        return cssPropertyValueImpl;
    }

    void setValue(@NotNull CssPropertyValueImpl value) {
        if (value == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(4);
        }
        this.myValue = value;
    }

    @Nullable
    public static CssCompletionContext buildFullContext(CssDeclaration decl) {
        CssTermList value = decl.getValue();
        List<PsiElement> psiElements = value != null ? CssPropertyDescriptorImpl.buildContextPath((PsiElement)value, true) : Collections.emptyList();
        CssCompletionContext c = null;
        for (PsiElement each : psiElements) {
            c = CssCompletionContext.createContext((PsiElement)each, c);
        }
        return c;
    }

    @Override
    public String @NotNull [] expand(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(5);
        }
        if (this.isShorthandValue() && PsiTreeUtil.getChildOfType((PsiElement)declaration.getValue(), CssTerm.class) != null) {
            String[] stringArray = CssShorthandExpandProcessor.create(this).expand(declaration);
            if (stringArray == null) {
                CssPropertyDescriptorImpl.$$$reportNull$$$0(6);
            }
            return stringArray;
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(7);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public PsiElement @Nullable [] getShorthandPsiValue(@NotNull CssDeclaration decl, @NotNull String propertyName) {
        CssCompletionContext c;
        CssPropertyValue value;
        if (decl == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(9);
        }
        if ((value = CssShorthandExpandProcessor.create(this).getPropertyValue(decl, propertyName)) == null) {
            return null;
        }
        if (this.myPropertyName.startsWith("-moz-border-radius")) {
            propertyName = propertyName.replace("top", "top-");
            propertyName = propertyName.replace("bottom", "bottom-");
        }
        if (this.myPropertyName.contains("border-radius") || this.myPropertyName.contains("border") && this.myPropertyName.contains("image")) {
            c = CssPropertyDescriptorImpl.buildFullContext(decl);
            LOG.assertTrue(c != null, (Object)("Context is null for: " + decl.getText()));
            switch (c.getLength()) {
                case 1: {
                    return new PsiElement[]{c.getElement()};
                }
                case 2: {
                    if (propertyName.contains("top-right") || propertyName.contains("bottom-left")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    return new PsiElement[]{c.getParent().getElement()};
                }
                case 3: {
                    if (propertyName.contains("top-right") || propertyName.contains("bottom-left")) {
                        return new PsiElement[]{c.getParent().getElement()};
                    }
                    if (propertyName.contains("bottom-right")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    return new PsiElement[]{c.getParent().getParent().getElement()};
                }
                case 4: {
                    if (propertyName.contains("bottom-left")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    if (propertyName.contains("bottom-right")) {
                        return new PsiElement[]{c.getParent().getElement()};
                    }
                    if (propertyName.contains("top-right")) {
                        return new PsiElement[]{c.getParent().getParent().getElement()};
                    }
                    return new PsiElement[]{c.getParent().getParent().getParent().getElement()};
                }
            }
        }
        if (this.is4ValueProperty() || this.getPropertyName().contains("border-image")) {
            c = CssPropertyDescriptorImpl.buildFullContext(decl);
            if (c == null) {
                return null;
            }
            switch (c.getLength()) {
                case 1: {
                    return new PsiElement[]{c.getElement()};
                }
                case 2: {
                    if (propertyName.contains("left") || propertyName.contains("right")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    return new PsiElement[]{c.getParent().getElement()};
                }
                case 3: {
                    if (propertyName.contains("bottom")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    if (propertyName.contains("top")) {
                        return new PsiElement[]{c.getParent().getParent().getElement()};
                    }
                    return new PsiElement[]{c.getParent().getElement()};
                }
                case 4: {
                    if (propertyName.contains("left")) {
                        return new PsiElement[]{c.getElement()};
                    }
                    if (propertyName.contains("bottom")) {
                        return new PsiElement[]{c.getParent().getElement()};
                    }
                    if (propertyName.contains("right")) {
                        return new PsiElement[]{c.getParent().getParent().getElement()};
                    }
                    return new PsiElement[]{c.getParent().getParent().getParent().getElement()};
                }
            }
        } else {
            LinkedList<PsiElement> values = new LinkedList<PsiElement>();
            for (c = CssPropertyDescriptorImpl.buildFullContext(decl); c != null; c = c.getParent()) {
                PsiElement element = c.getElement();
                if (!value.isValueBelongs(element) || !CssPropertyDescriptorImpl.isPropertyValuePrefixMatch(element, value)) continue;
                values.addFirst(element);
            }
            return values.isEmpty() ? null : PsiUtilCore.toPsiElementArray(values);
        }
        return null;
    }

    @Override
    public CssPropertyInfo @NotNull [] getInfos() {
        if (this.myCssPropertyInfos == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(10);
        }
        return this.myCssPropertyInfos;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean getInherited() {
        for (CssPropertyInfo info : this.myCssPropertyInfos) {
            if (!"yes".equalsIgnoreCase(info.getInherited()) && !"true".equals(info.getInherited())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String toCanonicalName(@NotNull String propertyName) {
        if (propertyName == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(12);
        }
        String string = StringUtil.toLowerCase((String)propertyName);
        if (string == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static boolean isPropertyValuePrefixMatch(@Nullable PsiElement element, CssPropertyValue value) {
        String prefix = value.getPrefix();
        if (element != null) {
            int maxValuesCount = Math.max(value.getMaxValuesCount(), 1);
            for (int i = 0; i < maxValuesCount; ++i) {
                CssTerm prevTerm;
                if ((element = PsiTreeUtil.prevVisibleLeaf((PsiElement)element)) != null && (prevTerm = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class)) != null) {
                    element = prevTerm;
                    if (!value.isValueBelongs((PsiElement)prevTerm)) break;
                    continue;
                }
                return prefix != null ? element != null && prefix.equalsIgnoreCase(element.getText()) : element == null || !CssPropertyDescriptorImpl.isPossibleValuePrefix(element);
            }
        }
        return prefix == null;
    }

    private static boolean isPossibleValuePrefix(@NotNull PsiElement element) {
        if (element == null) {
            CssPropertyDescriptorImpl.$$$reportNull$$$0(14);
        }
        return POSSIBLE_VALUE_PREFIXES.contains(element.getNode().getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssPropertyDescriptorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "expand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidValue";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getShorthandPsiValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleValuePrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

