/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.CssCommonDescriptorData;
import com.intellij.psi.css.impl.descriptor.CssFunctionDescriptorImpl;
import com.intellij.psi.css.impl.descriptor.value.CssAnyValueImpl;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssStringValue;
import com.intellij.psi.css.impl.descriptor.value.CssTextValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorData;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsHolder;
import com.intellij.psi.css.impl.util.scheme.CssDescriptorsLoader;
import com.intellij.psi.css.impl.util.scheme.CssValueDescriptorModificator;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.lang.ref.Reference;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementDescriptorFactory2 {
    private static final Logger LOG = Logger.getInstance(CssElementDescriptorFactory2.class);
    private static final CssCommonDescriptorData CSS_TOGGLE_FUNCTION_COMMON_DATA = new CssCommonDescriptorData("toggle", "toggle", new CssContextType[]{CssContextType.ANY}, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.CSS_3_0, "http://dev.w3.org/csswg/css-values/#funcdef-toggle", "The toggle() expression allows descendant elements to cycle over a list of values instead of inheriting the same value.");
    private static final CssCommonDescriptorData CSS_VAR_FUNCTION_COMMON_DATA = new CssCommonDescriptorData("var", "var", new CssContextType[]{CssContextType.ANY}, new BrowserVersion[]{new BrowserVersion(BrowserVersion.Browser.CHROME, "49"), new BrowserVersion(BrowserVersion.Browser.SAFARI, "9.1"), new BrowserVersion(BrowserVersion.Browser.FIREFOX, "31"), new BrowserVersion(BrowserVersion.Browser.OPERA, "36"), new BrowserVersion(BrowserVersion.Browser.EDGE, "16")}, CssElementDescriptor.CssVersion.CSS_3_0, "https://www.w3.org/TR/css-variables/#funcdef-var", "The var() function returns the value of a custom property.");
    private static final String[] SCHEME_NAMES = new String[]{"css-cascade-4.xml", "css1.0.xml", "css3-gcpm.xml", "css2.0.xml", "css2.1.xml", "css3.0.xml", "css-overflow-3.xml", "css-box.xml", "css-page-floats.xml", "css3-page.xml", "custom-elements.xml", "css3-images.xml", "css-images-4.xml", "css3-line-grid.xml", "css3-mediaqueries.xml", "view-mode.xml", "css-device-adapt.xml", "css3-transitions.xml", "css3-animations.xml", "css3-transforms.xml", "css-text-3.xml", "css-ruby-1.xml", "css3-speech.xml", "css-ui-4.xml", "css-counter-styles-3.xml", "css-lists-3.xml", "css3-filter-effects.xml", "css-scoping1.xml", "css-regions.xml", "css3-break.xml", "css3-flexbox.xml", "css3-grid.xml", "css-masking-1.xml", "css-shapes-1.xml", "css3-background.xml", "css-display-3.xml", "css3-fonts.xml", "css-fonts-4.xml", "fontface.xml", "css-text-decor-3.xml", "css-text-decor-4.xml", "css3-preslev.xml", "css3-positioning.xml", "css-compositing-1.xml", "css3-align.xml", "ie.xml", "css3-writing-modes.xml", "jquery.xml", "mozilla.xml", "mso.xml", "opera.xml", "svg.xml", "webkit.xml", "css-scroll-snap.xml", "css-will-change.xml", "css-inline-3.xml", "appmanifest.xml", "css-color-4.xml", "css-selectors-4.xml", "cssModules.xml", "css-contain-1.xml", "cssom-view-1.xml", "mediaqueries4.xml", "mediaqueries-5.xml", "css-logical-1.xml", "css-motion-1.xml", "css-overscroll-behavior.xml", "css-shadow-parts-1.xml"};
    private final String[] mySchemesToLoad;
    private Reference<CssDescriptorsHolder> myCssDescriptorsHolderRef;

    public static CssElementDescriptorFactory2 getInstance() {
        return (CssElementDescriptorFactory2)ApplicationManager.getApplication().getService(CssElementDescriptorFactory2.class);
    }

    private synchronized CssDescriptorsHolder getDescriptors() {
        CssDescriptorsHolder descriptors = (CssDescriptorsHolder)SoftReference.dereference(this.myCssDescriptorsHolderRef);
        return descriptors != null ? descriptors : this.reload();
    }

    @NotNull
    public Collection<CssPseudoSelectorDescriptor> findPseudoSelector(@NotNull String name) {
        if (name == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(0);
        }
        Collection collection = this.getDescriptors().pseudoSelectors.get((Object)StringUtil.toLowerCase((String)name));
        if (collection == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public Collection<CssPropertyDescriptor> findProperty(@NotNull String name) {
        if (name == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(2);
        }
        Collection collection = this.getProperties().get((Object)StringUtil.toLowerCase((String)name));
        if (collection == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Collection<CssFunctionDescriptor> findFunction(@NotNull String name) {
        if (name == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(4);
        }
        Collection collection = this.getDescriptors().functions.get((Object)StringUtil.toLowerCase((String)name));
        if (collection == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public Collection<CssMediaFeatureDescriptor> findMediaFeature(@NotNull String name) {
        if (name == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(6);
        }
        Collection collection = this.getDescriptors().mediaFeatures.get((Object)StringUtil.toLowerCase((String)name));
        if (collection == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public Set<String> getAllNamedValues() {
        return this.getDescriptors().namedValues.keySet();
    }

    @NotNull
    public Collection<CssValueDescriptor> findNamedValue(@NotNull String name, @Nullable CssValueDescriptor parent) {
        if (name == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(8);
        }
        if (parent != null) {
            List list = ContainerUtil.map((Collection)this.getDescriptors().namedValues.get((Object)StringUtil.toLowerCase((String)name)), descriptor -> CssValueDescriptorModificator.withParent(descriptor, parent));
            if (list == null) {
                CssElementDescriptorFactory2.$$$reportNull$$$0(9);
            }
            return list;
        }
        Collection collection = this.getDescriptors().namedValues.get((Object)StringUtil.toLowerCase((String)name));
        if (collection == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public MultiMap<String, CssPseudoSelectorDescriptor> getPseudoSelectors() {
        MultiMap<String, CssPseudoSelectorDescriptor> multiMap = this.getDescriptors().pseudoSelectors;
        if (multiMap == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(11);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, CssFunctionDescriptor> getFunctions() {
        MultiMap<String, CssFunctionDescriptor> multiMap = this.getDescriptors().functions;
        if (multiMap == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(12);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, CssPropertyDescriptor> getProperties() {
        MultiMap<String, CssPropertyDescriptor> multiMap = this.getDescriptors().properties;
        if (multiMap == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(13);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, CssMediaFeatureDescriptor> getMediaFeatures() {
        MultiMap<String, CssMediaFeatureDescriptor> multiMap = this.getDescriptors().mediaFeatures;
        if (multiMap == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(14);
        }
        return multiMap;
    }

    @NotNull
    public Set<String> getValueIdentifiers() {
        Set<String> set = this.getDescriptors().valueIdentifiers;
        if (set == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    public CssFunctionDescriptor createToggleFunctionDescriptorFromPropertyDescriptor(@NotNull CssPropertyDescriptor descriptor) {
        if (descriptor == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(16);
        }
        return new CssFunctionDescriptorImpl(CSS_TOGGLE_FUNCTION_COMMON_DATA, CssValueDescriptorModificator.withQuantifiers(descriptor.getValueDescriptor(), 1, -1, true), CssTermTypes.TOGGLE);
    }

    @NotNull
    public CssFunctionDescriptor createVarFunctionDescriptorFromPropertyDescriptors(@NotNull CssValueDescriptor valueDescriptor) {
        if (valueDescriptor == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(17);
        }
        CssGroupValue value = this.createGroupValue(CssGroupValue.Type.ALL, 1, 1, null, null);
        value.addChild(this.createNameValueDescriptor(null, CssBundle.message((String)"custom.property.name.value.presentable.name", (Object[])new Object[0]), 1, 1, value));
        CssGroupValue defaultValue = this.createGroupValue(CssGroupValue.Type.ALL, 0, 1, value, null);
        defaultValue.addChild(this.createTextValueDescriptor(",", 1, 1, defaultValue));
        defaultValue.addChild(CssValueDescriptorModificator.withParent(valueDescriptor, defaultValue));
        value.addChild(defaultValue);
        return new CssFunctionDescriptorImpl(CSS_VAR_FUNCTION_COMMON_DATA, value, CssTermTypes.VAR);
    }

    public CssElementDescriptorFactory2() {
        this(SCHEME_NAMES);
    }

    public CssElementDescriptorFactory2(String ... schemesToLoad) {
        this.mySchemesToLoad = schemesToLoad;
    }

    public synchronized CssDescriptorsHolder reload() {
        ProgressManager myProgressManager = ProgressManager.getInstance();
        CssDescriptorsLoader loader = new CssDescriptorsLoader(myProgressManager.getProgressIndicator());
        for (String scheme : this.mySchemesToLoad) {
            URL resource = this.getClass().getResource("xml/" + scheme);
            if (resource == null) {
                LOG.warn("Cannot find CSS scheme: " + scheme);
                continue;
            }
            loader.loadDescriptors(resource);
        }
        CssDescriptorsHolder descriptors = loader.getDescriptors();
        this.myCssDescriptorsHolderRef = new SoftReference((Object)descriptors);
        return descriptors;
    }

    public CssGroupValue createGroupValue(@NotNull CssGroupValue.Type type, int minOccur, int maxOccur, @Nullable CssValueDescriptor parent, @Nullable CssValueDescriptor separator) {
        if (type == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(18);
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData("", "", CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(false, minOccur, maxOccur, null, null, parent, null, false);
        return CssGroupValue.create(commonDescriptorData, valueDescriptorData, true, separator, type);
    }

    public CssTextValue createTextValueDescriptor(@NotNull String text, int minOccur, int maxOccur, CssValueDescriptor parent) {
        if (text == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(19);
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(text, text, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssTextValue(text, commonDescriptorData, valueDescriptorData);
    }

    public CssNameValue createNameValueDescriptor(@Nullable String id, @Nullable String presentableName, int minOccur, int maxOccur, CssValueDescriptor parent) {
        presentableName = StringUtil.notNullize((String)presentableName, (String)CssBundle.message((String)"name.value.presentable.name", (Object[])new Object[0]));
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(presentableName, presentableName, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssNameValue(id, true, commonDescriptorData, valueDescriptorData);
    }

    public CssAnyValue createAnyValueDescriptor(int minOccur, int maxOccur, CssValueDescriptor parent) {
        String id = CssBundle.message((String)"any.value.presentable.name", (Object[])new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssAnyValueImpl(commonDescriptorData, valueDescriptorData);
    }

    public CssStringValue createStringValueDescriptor(@Nullable String stringValue, int minOccur, int maxOccur, CssValueDescriptor parent) {
        String id = stringValue != null ? StringUtil.wrapWithDoubleQuote((String)stringValue) : CssBundle.message((String)"string.value.presentable.name", (Object[])new Object[0]);
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(id, id, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssStringValue(stringValue, commonDescriptorData, valueDescriptorData);
    }

    public CssFunctionInvocationValue createFunctionInvocationValueDescriptor(@NotNull String name, int minOccur, int maxOccur, CssValueDescriptor parent) {
        if (name == null) {
            CssElementDescriptorFactory2.$$$reportNull$$$0(20);
        }
        CssCommonDescriptorData commonDescriptorData = new CssCommonDescriptorData(name, name, CssContextType.EMPTY_ARRAY, BrowserVersion.EMPTY_ARRAY, CssElementDescriptor.CssVersion.UNKNOWN, null, "");
        CssValueDescriptorData valueDescriptorData = new CssValueDescriptorData(true, minOccur, maxOccur, null, null, parent, null, false);
        return new CssFunctionInvocationValue(name, commonDescriptorData, valueDescriptorData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescriptor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findPseudoSelector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findProperty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMediaFeature";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamedValue";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPseudoSelectors";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMediaFeatures";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueIdentifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPseudoSelector";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMediaFeature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNamedValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createToggleFunctionDescriptorFromPropertyDescriptor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createVarFunctionDescriptorFromPropertyDescriptors";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createGroupValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createTextValueDescriptor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionInvocationValueDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

