/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssPseudoElement;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.SelectorSpecificity;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.stubs.CssSelectorStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.impl.stubs.base.CssStubElementType;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssSelectorImpl
extends CssStubElement<CssSelectorStub>
implements CssSelector {
    private static final Logger LOG = Logger.getInstance(CssSelectorImpl.class);
    private static final TokenSet ELEMENT_FILTER = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_SIMPLE_SELECTOR, CssElementTypes.CSS_GT, CssElementTypes.CSS_KEYFRAMES_SELECTOR, CssElementTypes.CSS_PLUS, CssElementTypes.CSS_TILDA});

    public CssSelectorImpl(@NotNull CssSelectorStub stub, @NotNull CssStubElementType nodeType) {
        if (stub == null) {
            CssSelectorImpl.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            CssSelectorImpl.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public CssSelectorImpl(@NotNull ASTNode node) {
        if (node == null) {
            CssSelectorImpl.$$$reportNull$$$0(2);
        }
        super(node);
    }

    public PsiElement[] getElements() {
        return this.getStubOrPsiChildren(ELEMENT_FILTER, ARRAY_FACTORY);
    }

    @NotNull
    public String getPresentableText() {
        StringBuilder result = new StringBuilder();
        CssSelector.Combinator[] combinators = this.getCombinators();
        CssSimpleSelector[] selectors = this.getSimpleSelectors();
        for (int i = 0; i < combinators.length; ++i) {
            CssSelector.Combinator combinator = combinators[i];
            if (combinator != CssSelector.Combinator.DESCENDANT) {
                result.append(combinator.getPresentation());
                result.append(' ');
            }
            if (selectors.length <= i) continue;
            result.append(selectors[i].getPresentableText()).append(' ');
        }
        String string = result.toString().trim();
        if (string == null) {
            CssSelectorImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    CssSelector.Combinator @NotNull [] getCombinators() {
        CssSelectorStub stub = (CssSelectorStub)this.getStub();
        if (stub != null) {
            CssSelector.Combinator[] combinatorArray = stub.getCombinators();
            if (combinatorArray == null) {
                CssSelectorImpl.$$$reportNull$$$0(4);
            }
            return combinatorArray;
        }
        CssSelector.Combinator[] combinatorArray = (CssSelector.Combinator[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            LinkedList<CssSelector.Combinator> result = new LinkedList<CssSelector.Combinator>();
            for (CssSimpleSelector selector : this.getSimpleSelectors()) {
                CssSelector.Combinator prevCombinator = CssSelector.Combinator.DESCENDANT;
                for (PsiElement prevSibling = selector.getPrevSibling(); prevSibling != null && !(prevSibling instanceof CssSimpleSelector); prevSibling = prevSibling.getPrevSibling()) {
                    CssSelector.Combinator combinator = CssSelectorImpl.combinatorFromElementType(prevSibling.getNode().getElementType());
                    if (combinator == null) continue;
                    prevCombinator = combinator;
                    break;
                }
                result.add(prevCombinator);
            }
            return CachedValueProvider.Result.create((Object)result.toArray(new CssSelector.Combinator[0]), (Object[])new Object[]{this});
        });
        if (combinatorArray == null) {
            CssSelectorImpl.$$$reportNull$$$0(5);
        }
        return combinatorArray;
    }

    public CssSimpleSelector @NotNull [] getSimpleSelectors() {
        CssSimpleSelector[] cssSimpleSelectorArray = (CssSimpleSelector[])this.getStubOrPsiChildren(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_SIMPLE_SELECTOR, CssElementTypes.CSS_KEYFRAMES_SELECTOR}), (PsiElement[])CssSimpleSelector.EMPTY_ARRAY);
        if (cssSimpleSelectorArray == null) {
            CssSelectorImpl.$$$reportNull$$$0(6);
        }
        return cssSimpleSelectorArray;
    }

    @Nullable
    public SelectorSpecificity getSpecificity() {
        if (this.isAmpersandSelector()) {
            return null;
        }
        int idSelectorsNumber = 0;
        int classAndAttributeSelectorsNumber = 0;
        int typeSelectorsAndPseudoElementsNumber = 0;
        for (PsiElement selectorChild : this.getChildren()) {
            if (selectorChild instanceof PsiErrorElement) {
                return null;
            }
            if (selectorChild instanceof LeafPsiElement) continue;
            if (!(selectorChild instanceof CssSimpleSelector)) {
                return null;
            }
            CssSimpleSelector cssSimpleSelector = (CssSimpleSelector)selectorChild;
            if (!cssSimpleSelector.isUniversalSelector()) {
                ++typeSelectorsAndPseudoElementsNumber;
            }
            for (PsiElement simpleSelectorChild : selectorChild.getChildren()) {
                if (simpleSelectorChild instanceof PsiErrorElement) {
                    return null;
                }
                if (simpleSelectorChild instanceof PsiWhiteSpace || simpleSelectorChild instanceof PsiComment) continue;
                if (simpleSelectorChild instanceof LeafPsiElement) {
                    IElementType type = simpleSelectorChild.getNode().getElementType();
                    if (type == CssElementTypes.CSS_IDENT || type == CssElementTypes.CSS_PIPE || type == CssElementTypes.CSS_ASTERISK) continue;
                    return null;
                }
                if (!(simpleSelectorChild instanceof CssSelectorSuffixList)) {
                    return null;
                }
                for (CssSelectorSuffix suffix : cssSimpleSelector.getSelectorSuffixes()) {
                    CssTermList termList;
                    if (suffix instanceof CssIdSelector) {
                        ++idSelectorsNumber;
                    } else if (suffix instanceof CssClass || suffix instanceof CssAttribute) {
                        ++classAndAttributeSelectorsNumber;
                    } else if (suffix instanceof CssPseudoClass) {
                        String name = suffix.getName();
                        if (ArrayUtil.contains((String)name, (String[])new String[]{"before", "after", "first-line", "first-letter"})) {
                            ++typeSelectorsAndPseudoElementsNumber;
                        } else if (!"not".equals(name)) {
                            ++classAndAttributeSelectorsNumber;
                        }
                    } else if (suffix instanceof CssPseudoElement) {
                        ++typeSelectorsAndPseudoElementsNumber;
                    }
                    if (!(suffix instanceof CssPseudoSelector)) continue;
                    CssFunction function = (CssFunction)PsiTreeUtil.findChildOfType((PsiElement)suffix, CssFunction.class);
                    CssTermList cssTermList = termList = function != null ? function.getValue() : null;
                    if (termList == null) continue;
                    for (CssTerm term : termList.getTerms()) {
                        PsiElement child = term.getFirstChild();
                        IElementType type = child.getNode().getElementType();
                        if (type == CssElementTypes.CSS_HASH) {
                            ++idSelectorsNumber;
                            continue;
                        }
                        if (child instanceof CssClass || child instanceof CssAttribute || child instanceof CssPseudoClass) {
                            ++classAndAttributeSelectorsNumber;
                            continue;
                        }
                        if (!(suffix instanceof CssPseudoElement) && type != CssElementTypes.CSS_IDENT) continue;
                        ++typeSelectorsAndPseudoElementsNumber;
                    }
                }
            }
        }
        return new SelectorSpecificity(idSelectorsNumber, classAndAttributeSelectorsNumber, typeSelectorsAndPseudoElementsNumber);
    }

    public boolean processAmpersandEvaluatedSelectors(@NotNull Processor<? super CssSelector> processor) {
        if (processor == null) {
            CssSelectorImpl.$$$reportNull$$$0(7);
        }
        Collection selectors = (Collection)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.getAmpersandEvaluatedSelectors(this.getRuleset()), (Object[])new Object[]{this}));
        for (CssSelector selector : selectors) {
            if (processor.process((Object)selector)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Collection<CssSelector> getAmpersandEvaluatedSelectors(@Nullable CssRuleset contextRuleset) {
        if (contextRuleset == null) {
            List<CssSelector> list = Collections.emptyList();
            if (list == null) {
                CssSelectorImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (!this.isAmpersandSelector()) {
            List<CssSelector> list = Collections.emptyList();
            if (list == null) {
                CssSelectorImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        CssRuleset parentRuleset = (CssRuleset)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)contextRuleset, CssRuleset.class);
        if (parentRuleset == null) {
            List<CssSelector> list = Collections.emptyList();
            if (list == null) {
                CssSelectorImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        String presentableText = this.getPresentableText();
        CssSelector[] parentSelectors = parentRuleset.getSelectors();
        ArrayList<CssSelector> result = new ArrayList<CssSelector>(parentSelectors.length);
        for (CssSelector parentSelector : parentSelectors) {
            ProgressManager.checkCanceled();
            String newText = StringUtil.replace((String)presentableText, (String)"&", (String)parentSelector.getPresentableText());
            if (newText.isEmpty()) continue;
            CssRuleset ruleset = null;
            try {
                Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)contextRuleset);
                ruleset = CssElementFactory.getInstance((Project)this.getProject()).createRuleset(newText, CssDeclaration.EMPTY_ARRAY, language);
            }
            catch (IllegalArgumentException language) {
                // empty catch block
            }
            CssSelector newSelector = (CssSelector)PsiTreeUtil.findChildOfType(ruleset, CssSelector.class);
            if (newSelector == null) {
                LOG.warn("Cannot create ampersand selector for parent selector '" + parentSelector.getText() + "' and child selector '" + this.getText() + "'");
                continue;
            }
            if (newSelector.isAmpersandSelector()) {
                result.addAll(((CssSelectorImpl)newSelector).getAmpersandEvaluatedSelectors(parentRuleset));
                continue;
            }
            newSelector.putUserData(CssSelector.AMPERSAND_SELECTOR_ORIGIN_KEY, (Object)SmartPointerManager.createPointer((PsiElement)this));
            result.add(newSelector);
        }
        ArrayList<CssSelector> arrayList = result;
        if (arrayList == null) {
            CssSelectorImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public boolean isMatch(@NotNull XmlTag tag, @NotNull CssResolver resolver, @Nullable Map<XmlTag, CssSimpleSelector> mapping) {
        if (tag == null) {
            CssSelectorImpl.$$$reportNull$$$0(12);
        }
        if (resolver == null) {
            CssSelectorImpl.$$$reportNull$$$0(13);
        }
        if (this.isAmpersandSelector()) {
            return !this.processAmpersandEvaluatedSelectors((Processor<? super CssSelector>)((Processor)selector -> !CssSelectorImpl.isMatchInner(selector, tag, resolver, mapping)));
        }
        return CssSelectorImpl.isMatchInner(this, tag, resolver, mapping);
    }

    public boolean isHierarchicalSelectorThatMatchesSubtag(@NotNull XmlTag tag, @NotNull CssResolver resolver) {
        if (tag == null) {
            CssSelectorImpl.$$$reportNull$$$0(14);
        }
        if (resolver == null) {
            CssSelectorImpl.$$$reportNull$$$0(15);
        }
        if (resolver.isCollectingCompletionVariants()) {
            LOG.error("This method is not designed to be used for code completion");
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)tag.getAttributeValue("class"))) {
            return false;
        }
        CssSimpleSelector[] simpleSelectors = this.getSimpleSelectors();
        if (simpleSelectors.length < 2) {
            return false;
        }
        for (int i = simpleSelectors.length - 2; i >= 0; --i) {
            boolean hasClassSuffix = false;
            for (CssSelectorSuffix suffix : simpleSelectors[i].getSelectorSuffixes()) {
                if (!(suffix instanceof CssClass)) continue;
                hasClassSuffix = true;
                break;
            }
            if (!hasClassSuffix || !CssSelectorImpl.isMatchInner(this, tag, resolver, null, i) || !CssSelectorImpl.hasMatchingSubTag(tag, this, resolver, i + 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMatchingSubTag(@NotNull XmlTag tag, @NotNull CssSelector selector, @NotNull CssResolver resolver, int indexOfFirstSimpleSelectorToCare) {
        if (tag == null) {
            CssSelectorImpl.$$$reportNull$$$0(16);
        }
        if (selector == null) {
            CssSelectorImpl.$$$reportNull$$$0(17);
        }
        if (resolver == null) {
            CssSelectorImpl.$$$reportNull$$$0(18);
        }
        CssSimpleSelector[] simpleSelectors = selector.getSimpleSelectors();
        CssSelector.Combinator[] combinators = selector.getCombinators();
        if (indexOfFirstSimpleSelectorToCare == simpleSelectors.length) {
            return true;
        }
        CssSimpleSelector simpleSelector = simpleSelectors[indexOfFirstSimpleSelectorToCare];
        CssSelector.Combinator combinator = combinators[indexOfFirstSimpleSelectorToCare];
        boolean strictMatch = combinator == CssSelector.Combinator.CHILD || combinator == CssSelector.Combinator.SIBLING;
        boolean sibling = combinator == CssSelector.Combinator.SIBLING || combinator == CssSelector.Combinator.FOLLOWING_SIBLING;
        XmlTag currentTag = sibling ? (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, XmlTag.class) : (XmlTag)PsiTreeUtil.getChildOfType((PsiElement)tag, XmlTag.class);
        while (true) {
            XmlTag nextTagToCheck;
            ProgressManager.checkCanceled();
            if (currentTag == null) {
                return false;
            }
            if (simpleSelector.isMatch(currentTag, resolver) && CssSelectorImpl.hasMatchingSubTag(currentTag, selector, resolver, indexOfFirstSimpleSelectorToCare + 1)) {
                return true;
            }
            if (sibling) {
                if (strictMatch) {
                    return false;
                }
                nextTagToCheck = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)currentTag, XmlTag.class);
            } else {
                nextTagToCheck = strictMatch ? (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)currentTag, XmlTag.class) : CssSelectorImpl.getNextTagToCheck(currentTag, tag);
            }
            currentTag = nextTagToCheck;
        }
    }

    @Nullable
    private static XmlTag getNextTagToCheck(@NotNull XmlTag currentTag, @NotNull XmlTag tagToStopAt) {
        XmlTag childTag;
        if (currentTag == null) {
            CssSelectorImpl.$$$reportNull$$$0(19);
        }
        if (tagToStopAt == null) {
            CssSelectorImpl.$$$reportNull$$$0(20);
        }
        if ((childTag = (XmlTag)PsiTreeUtil.getChildOfType((PsiElement)currentTag, XmlTag.class)) != null) {
            return childTag;
        }
        XmlTag nextTag = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)currentTag, XmlTag.class);
        if (nextTag != null) {
            return nextTag;
        }
        for (XmlTag parentTag = currentTag.getParentTag(); parentTag != null && parentTag != tagToStopAt; parentTag = parentTag.getParentTag()) {
            XmlTag parentSibling = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)parentTag, XmlTag.class);
            if (parentSibling == null) continue;
            return parentSibling;
        }
        return null;
    }

    private static boolean isMatchInner(@NotNull CssSelector selector, @NotNull XmlTag tag, @NotNull CssResolver resolver, @Nullable Map<XmlTag, CssSimpleSelector> mapping) {
        if (selector == null) {
            CssSelectorImpl.$$$reportNull$$$0(21);
        }
        if (tag == null) {
            CssSelectorImpl.$$$reportNull$$$0(22);
        }
        if (resolver == null) {
            CssSelectorImpl.$$$reportNull$$$0(23);
        }
        return CssSelectorImpl.isMatchInner(selector, tag, resolver, mapping, selector.getSimpleSelectors().length - 1);
    }

    private static boolean isMatchInner(@NotNull CssSelector selector, @NotNull XmlTag tag, @NotNull CssResolver resolver, @Nullable Map<XmlTag, CssSimpleSelector> mapping, int indexOfLastSimpleSelectorToCheck) {
        if (selector == null) {
            CssSelectorImpl.$$$reportNull$$$0(24);
        }
        if (tag == null) {
            CssSelectorImpl.$$$reportNull$$$0(25);
        }
        if (resolver == null) {
            CssSelectorImpl.$$$reportNull$$$0(26);
        }
        CssSimpleSelector[] simpleSelectors = selector.getSimpleSelectors();
        CssSelector.Combinator[] combinators = selector.getCombinators();
        if (simpleSelectors.length == 0 || combinators.length != simpleSelectors.length) {
            return false;
        }
        boolean match = false;
        XmlTag currentTag = tag;
        boolean strictMatch = true;
        boolean sibling = false;
        block0: for (int i = indexOfLastSimpleSelectorToCheck; i >= 0; --i) {
            CssSelector.Combinator combinator;
            CssSimpleSelector simpleSelector = simpleSelectors[i];
            if (resolver.isCollectingCompletionVariants()) {
                if (!simpleSelector.isMatch(tag, resolver)) continue;
                match = true;
                break;
            }
            do {
                if (i < indexOfLastSimpleSelectorToCheck && (currentTag = sibling ? (XmlTag)PsiTreeUtil.getPrevSiblingOfType((PsiElement)currentTag, XmlTag.class) : currentTag.getParentTag()) == null) {
                    match = false;
                    break block0;
                }
                match = simpleSelector.isMatch(currentTag, resolver);
                if (strictMatch && !match) break block0;
            } while (!match);
            if (mapping != null) {
                mapping.put(currentTag, simpleSelector);
            }
            strictMatch = (combinator = combinators[i]) == CssSelector.Combinator.CHILD || combinator == CssSelector.Combinator.SIBLING;
            sibling = combinator == CssSelector.Combinator.SIBLING || combinator == CssSelector.Combinator.FOLLOWING_SIBLING;
        }
        return match;
    }

    @Nullable
    public CssRuleset getRuleset() {
        return (CssRuleset)this.getStubOrPsiParentOfType(CssRuleset.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssSelectorImpl.$$$reportNull$$$0(27);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssSelector((CssSelector)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isAmpersandSelector() {
        CssSelectorStub stub = (CssSelectorStub)this.getStub();
        if (stub != null) {
            return stub.isAmpersandSelector();
        }
        return this.textContains('&');
    }

    public int getLineNumber() {
        return CssUtil.getLineNumber(this);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                return CssSelectorImpl.this.getPresentableText();
            }

            @Nullable
            public String getLocationString() {
                return CssNamedItemPresentation.getLocationString((PsiElement)CssSelectorImpl.this);
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    private static CssSelector.Combinator combinatorFromElementType(@NotNull IElementType type) {
        if (type == null) {
            CssSelectorImpl.$$$reportNull$$$0(28);
        }
        if (type == CssElementTypes.CSS_GT) {
            return CssSelector.Combinator.CHILD;
        }
        if (type == CssElementTypes.CSS_PLUS) {
            return CssSelector.Combinator.SIBLING;
        }
        if (type == CssElementTypes.CSS_TILDA) {
            return CssSelector.Combinator.FOLLOWING_SIBLING;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssSelectorImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 17: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTag";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagToStopAt";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssSelectorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinators";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleSelectors";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAmpersandEvaluatedSelectors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAmpersandEvaluatedSelectors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMatch";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isHierarchicalSelectorThatMatchesSubtag";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchingSubTag";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNextTagToCheck";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isMatchInner";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "combinatorFromElementType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

