/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssEscapeUtil;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.CssSelectorSelfReference;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssClassImpl
extends CssNamedStubElement<CssNamedStub<CssClass>>
implements CssClass {
    public CssClassImpl(@NotNull CssNamedStub<CssClass> stub, @NotNull CssNamedStubElementType nodeType) {
        if (stub == null) {
            CssClassImpl.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            CssClassImpl.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public CssClassImpl(@NotNull ASTNode node) {
        if (node == null) {
            CssClassImpl.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @NotNull
    public String getName() {
        CssNamedStub stub = (CssNamedStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                CssClassImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        PsiElement child = this.getFirstChild();
        if (child instanceof LeafElement && ((LeafElement)child).getElementType() == CssElementTypes.CSS_PERIOD && (child = child.getNextSibling()) instanceof PsiErrorElement) {
            return "";
        }
        PsiElement token = this.getNameIdentifier();
        String string = CssEscapeUtil.unescapeCssString(CssPsiUtil.getTokenText((PsiElement)token));
        if (string == null) {
            CssClassImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public CssSelectorSuffixType getType() {
        CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.CLASS;
        if (cssSelectorSuffixType == null) {
            CssClassImpl.$$$reportNull$$$0(5);
        }
        return cssSelectorSuffixType;
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiElement token;
        if (name == null) {
            CssClassImpl.$$$reportNull$$$0(6);
        }
        if ((token = this.getNameIdentifier()) != null) {
            CssPsiUtil.replaceToken((PsiElement)token, (String)CssEscapeUtil.escapeSpecialCssChars(name));
        }
        CssClassImpl cssClassImpl = this;
        if (cssClassImpl == null) {
            CssClassImpl.$$$reportNull$$$0(7);
        }
        return cssClassImpl;
    }

    @Nullable
    private PsiElement getNameIdentifier() {
        return CssPsiUtil.findToken((CssElement)this, (TokenSet)CssElementTypes.NAME_TOKEN_TYPES);
    }

    public boolean isMatch(@NotNull XmlTag tag, @NotNull CssResolver resolver) {
        if (tag == null) {
            CssClassImpl.$$$reportNull$$$0(8);
        }
        if (resolver == null) {
            CssClassImpl.$$$reportNull$$$0(9);
        }
        return CssResolveUtil.checkTagForMatching(tag, "class", this.getName(), resolver);
    }

    public ItemPresentation getPresentation() {
        return new CssNamedItemPresentation((PsiNamedElement)this, "." + this.getName());
    }

    public Icon getIcon(int flags) {
        return AllIcons.Xml.Css_class;
    }

    public int getTextOffset() {
        return this.getTextRange().isEmpty() ? super.getTextOffset() : super.getTextOffset() + 1;
    }

    public PsiReference getReference() {
        int startOffset = this.getTextOffset() - this.getTextRange().getStartOffset();
        return new CssSelectorSelfReference((CssSelectorSuffix)this, TextRange.from((int)startOffset, (int)this.getName().length()));
    }

    @Nullable
    public CssRuleset getRuleset() {
        return (CssRuleset)this.getStubOrPsiParentOfType(CssRuleset.class);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        CssSelector ampersandSelector;
        CssSelector selector = (CssSelector)this.getStubOrPsiParentOfType(CssSelector.class);
        SmartPsiElementPointer pointer = selector != null ? (SmartPsiElementPointer)selector.getUserData(CssSelector.AMPERSAND_SELECTOR_ORIGIN_KEY) : null;
        CssSelector cssSelector = ampersandSelector = pointer != null ? (CssSelector)pointer.getElement() : null;
        if (ampersandSelector != null) {
            CssSelector cssSelector2 = ampersandSelector;
            if (cssSelector2 == null) {
                CssClassImpl.$$$reportNull$$$0(10);
            }
            return cssSelector2;
        }
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            CssClassImpl.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssClassImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssClassImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

