/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.rename;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssClassOrIdRenameHandler
extends PsiElementRenameHandler {
    private static final Logger LOG = Logger.getInstance(CssClassOrIdRenameHandler.class);

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiFile psiFile;
        Editor editor;
        if (dataContext == null) {
            CssClassOrIdRenameHandler.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null && (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null) {
            if (!CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)psiFile) && psiFile.getLanguage() != CssFileType.INSTANCE.getLanguage()) {
                return false;
            }
            return PsiTreeUtil.getNonStrictParentOfType((PsiElement)CssClassOrIdRenameHandler.getElement((DataContext)dataContext), (Class[])new Class[]{CssSelectorSuffix.class}) != null || CssClassOrIdRenameHandler.getElementToRename(editor, psiFile) != null;
        }
        return false;
    }

    @Nullable
    public static CssSelectorSuffix getElementToRename(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            CssClassOrIdRenameHandler.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            CssClassOrIdRenameHandler.$$$reportNull$$$0(2);
        }
        if (CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)psiFile) || psiFile.getLanguage() == CssFileType.INSTANCE.getLanguage()) {
            PsiReference ref = psiFile.findReferenceAt(editor.getCaretModel().getOffset());
            CssReference cssRef = null;
            if (ref instanceof CssReference) {
                cssRef = (CssReference)ref;
            } else if (ref instanceof PsiMultiReference) {
                PsiReference[] references;
                for (PsiReference psiReference : references = ((PsiMultiReference)ref).getReferences()) {
                    if (!(psiReference instanceof CssReference)) continue;
                    cssRef = (CssReference)psiReference;
                    break;
                }
            }
            if (cssRef != null) {
                if (cssRef instanceof PsiPolyVariantReference) {
                    ResolveResult[] results = ((PsiPolyVariantReference)cssRef).multiResolve(false);
                    for (PsiReference psiReference : results) {
                        PsiElement element = psiReference.getElement();
                        if (!(element instanceof CssSelectorSuffix) || ((CssSelectorSuffix)element).getType() == CssSelectorSuffixType.UNKNOWN) continue;
                        return (CssSelectorSuffix)element;
                    }
                } else {
                    PsiElement psiElement = cssRef.resolve();
                    if (psiElement instanceof CssSelectorSuffix && ((CssSelectorSuffix)psiElement).getType() != CssSelectorSuffixType.UNKNOWN) {
                        return (CssSelectorSuffix)psiElement;
                    }
                }
            }
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, @NotNull DataContext dataContext) {
        if (project == null) {
            CssClassOrIdRenameHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            CssClassOrIdRenameHandler.$$$reportNull$$$0(4);
        }
        if (!this.isRenaming(dataContext)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        CssSelectorSuffix elementToRename = CssClassOrIdRenameHandler.getElementToRename(editor, file);
        if (elementToRename == null) {
            elementToRename = (CssSelectorSuffix)PsiTreeUtil.getNonStrictParentOfType((PsiElement)CssClassOrIdRenameHandler.getElement((DataContext)dataContext), (Class[])new Class[]{CssSelectorSuffix.class});
        }
        LOG.assertTrue(elementToRename != null);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String initialName = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
            CssClassOrIdRenameHandler.doRename((PsiElement)elementToRename, project, initialName, false, false, false);
            return;
        }
        CssClassOrIdRenameDialog dialog = new CssClassOrIdRenameDialog((PsiElement)elementToRename, editor, project);
        dialog.show();
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            CssClassOrIdRenameHandler.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            CssClassOrIdRenameHandler.$$$reportNull$$$0(6);
        }
    }

    public static void doRename(PsiElement toRename, Project project, String newName, boolean comments, boolean nonJava, boolean preview) {
        RenameRefactoring rename = RefactoringFactory.getInstance((Project)project).createRename(toRename, newName);
        rename.setSearchInComments(comments);
        rename.setSearchInNonJavaFiles(nonJava);
        rename.setPreviewUsages(preview);
        rename.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementToRename";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CssClassOrIdRenameDialog
    extends RenameDialog {
        private final PsiElement myElement;

        private CssClassOrIdRenameDialog(@NotNull PsiElement psiElement, @NotNull Editor editor, @NotNull Project project) {
            if (psiElement == null) {
                CssClassOrIdRenameDialog.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                CssClassOrIdRenameDialog.$$$reportNull$$$0(1);
            }
            if (project == null) {
                CssClassOrIdRenameDialog.$$$reportNull$$$0(2);
            }
            super(project, psiElement, psiElement, editor);
            this.myElement = psiElement;
        }

        protected void doAction() {
            this.close(0);
            CssClassOrIdRenameHandler.doRename(this.myElement, this.myProject, this.getNewName(), this.isSearchInComments(), this.isSearchInNonJavaFiles(), this.isPreviewUsages());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/actions/rename/CssClassOrIdRenameHandler$CssClassOrIdRenameDialog";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

