/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api;

import com.yourkit.api.AllocationRecordingSettings;
import com.yourkit.api.ControllerListener;
import com.yourkit.api.ProbeActivityMode;
import com.yourkit.api.ProgressListener;
import com.yourkit.api.TableUpdater;
import com.yourkit.runtime.FrozenThreadInfo;
import com.yourkit.runtime.Packet;
import com.yourkit.runtime.StackTraceElementRes;
import com.yourkit.runtime.ThreadInfoRes;
import com.yourkit.runtime.TransferableSnapshotInfo;
import com.yourkit.util.ArrayUtil;
import com.yourkit.util.Asserts;
import com.yourkit.util.IntRef;
import com.yourkit.util.LongRef;
import com.yourkit.util.ObjectRef;
import com.yourkit.util.PresentableException;
import com.yourkit.util.StringRef;
import com.yourkit.util.Strings;
import com.yourkit.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerImpl {
    public static final int DEADLOCK_DETECTOR_FRAME_MATURITY_THRESHOLD_MS = 10000;
    @NotNull
    private final ArrayList<ControllerListener> myListeners;
    @NotNull
    protected final String myHost;
    protected final int myPort;
    @NotNull
    private final String myHostId;
    @Nullable
    public Boolean myIsLocalCached;
    private final int myPid;
    @NotNull
    private final String mySessionName;
    private final long mySessionId;
    @NotNull
    private final String mySnapshotNameFormat;
    private final long myCapabilities;
    private final int myTelemetryLimit;
    @NotNull
    private final String myPossibleSnapshotDir;
    @NotNull
    private final String myAgentVersion;
    @NotNull
    public final String myPlatform;
    @Nullable
    public Object myProxy;
    @Nullable
    public String myRemoteHostAndPort;
    public boolean myRestarted;
    private int myOomeDumperStatusCached;
    private AllocationRecordingSettings myAllocationRecordingSettingsCached;
    @NotNull
    private String myTriggersCached;
    private boolean myConnected;
    private final ThreadLocal<DataOutputStream> myOutStream;
    private final ThreadLocal<DataInputStream> myInStream;
    private int myNextEventTableIndex;
    @NotNull
    private final String[] myEventTableDescriptions;
    private FrozenThreadInfo[] myFrozenThreadsCached;
    private final int myConnectTimeoutMs;
    private final int myReadTimeoutMs;
    private long myStatusCached;
    private final ArrayList<Runnable> myOnCloseHooks;

    @NotNull
    public static String composeAllocationRecordingSettings(int sizeLimit, int recordEach, boolean sampledAllocationRecording) {
        String string = "sizeLimit=" + sizeLimit + ",recordEach=" + recordEach + (sampledAllocationRecording ? ",sampledStacks" : "");
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getActualHostAndPort() {
        String string = this.myRemoteHostAndPort != null ? this.myRemoteHostAndPort : this.myHost + ":" + this.myPort;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getActualHost() {
        String string = Strings.getFirstToken(this.getActualHostAndPort(), ':');
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public ControllerImpl(@NotNull String host, int port) throws PresentableException {
        if (host == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myListeners = new ArrayList();
        this.myTriggersCached = "";
        this.myOutStream = new ThreadLocal();
        this.myInStream = new ThreadLocal();
        this.myNextEventTableIndex = 32;
        this.myEventTableDescriptions = new String[96];
        this.myOnCloseHooks = new ArrayList();
        if (port < 1 || port > 65535) {
            throw new PresentableException("Port number " + port + " is invalid. It must be in range 1-65535.");
        }
        this.myHost = host;
        this.myPort = port;
        Integer timeoutMs = Strings.parseInt(System.getProperty("yk.controller.connect.timeout.ms", ""));
        this.myConnectTimeoutMs = timeoutMs != null && timeoutMs > 0 ? timeoutMs : 5000;
        timeoutMs = Strings.parseInt(System.getProperty("yk.controller.read.timeout.ms", ""));
        this.myReadTimeoutMs = timeoutMs != null && timeoutMs > 0 ? timeoutMs : 30000;
        final ObjectRef sessionName = new ObjectRef();
        final ObjectRef snapshotNameFormat = new ObjectRef();
        final ObjectRef hostId = new ObjectRef();
        final ObjectRef possibleSnapshotDir = new ObjectRef();
        final ObjectRef agentVersion = new ObjectRef();
        final ObjectRef platform = new ObjectRef();
        final LongRef capabilities = new LongRef();
        final LongRef sessionId = new LongRef();
        final IntRef pid = new IntRef();
        final IntRef telemetryLimit = new IntRef();
        this.runBatch(new Runnable(){

            @Override
            public void run() {
                ControllerImpl.this.makeRequest(new Communication(){

                    @Override
                    public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws Exception {
                        if (input == null) {
                            throw new IllegalArgumentException("Parameter 1 must not be null");
                        }
                        if (output == null) {
                            throw new IllegalArgumentException("Parameter 2 must not be null");
                        }
                        Packet.writeHeader(output, 102400);
                        Packet.flush(output);
                        Packet.readHeaderWithStandardResponse(input);
                        int protocolVersion = Packet.readInt(input);
                        agentVersion.setRef(Packet.readStringNotNull(input));
                        if (protocolVersion != 20190410) {
                            AgentVersionMismatchException cause = new AgentVersionMismatchException();
                            try {
                                Packet.readLong(input);
                                cause.mySessionName = Strings.notEmpty(Packet.readStringNotNull(input), ControllerImpl.this.myHost + ":" + ControllerImpl.this.myPort);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throw new PresentableException("Cannot connect to the profiled application.\nThe application has been started with incompatible profiler agent version:\n\nClient version: YourKit Java Profiler 2019.8-b126\nAgent version:  " + (String)agentVersion.getRefNotNull(), cause);
                        }
                        capabilities.set(Packet.readLong(input));
                        sessionName.setRef(Strings.notEmpty(Packet.readStringNotNull(input), ControllerImpl.this.myHost + ":" + ControllerImpl.this.myPort));
                        snapshotNameFormat.setRef(Strings.notEmpty(Packet.readStringNotNull(input), "{sessionname}-{date}"));
                        sessionId.set(Packet.readLong(input));
                        hostId.setRef(Packet.readStringNotNull(input));
                        possibleSnapshotDir.setRef(Packet.readStringNotNull(input));
                        pid.set(Packet.readInt(input));
                        telemetryLimit.set(Packet.readInt(input));
                    }
                });
                ControllerImpl.this.cacheStatuses();
                platform.setRef(ControllerImpl.this.dispatchCommand("d_get_platform"));
            }
        });
        this.mySessionName = (String)sessionName.getRefNotNull();
        this.mySnapshotNameFormat = (String)snapshotNameFormat.getRefNotNull();
        this.myHostId = (String)hostId.getRefNotNull();
        this.myCapabilities = capabilities.get();
        this.mySessionId = sessionId.get();
        this.myPid = pid.get();
        this.myTelemetryLimit = telemetryLimit.get();
        this.myPossibleSnapshotDir = (String)possibleSnapshotDir.getRefNotNull();
        this.myAgentVersion = (String)agentVersion.getRefNotNull();
        this.myPlatform = (String)platform.getRefNotNull();
        this.myConnected = true;
    }

    public final void cacheStatuses() {
        this.getStatus();
        this.updateOomeDumperStatus();
        this.updateEventTableInfo();
        this.updateAllocationRecordingSettings();
        this.getTriggers();
        this.myFrozenThreadsCached = this.getFrozenThreads(10000L);
    }

    @NotNull
    public final String getPossibleSnapshotDir() {
        String string = this.myPossibleSnapshotDir;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public boolean isConnected() {
        return this.myConnected;
    }

    public void setDisconnected() {
        if (!this.myConnected) {
            return;
        }
        this.myConnected = false;
        this.fireAgentDisconnected();
    }

    private void fireAgentDisconnected() {
        int size = this.myListeners.size();
        for (int idx = 0; idx < size; ++idx) {
            this.myListeners.get(idx).agentDisconnected(this);
        }
    }

    private void makeRequest(@NotNull Communication communication) throws PresentableException {
        if (communication == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.makeRequest(communication, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRequest(@NotNull Communication communication, boolean longerReadTimeout) throws PresentableException {
        block13: {
            if (communication == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            try {
                boolean first;
                DataInputStream inStream = this.myInStream.get();
                DataOutputStream outStream = this.myOutStream.get();
                boolean bl = first = inStream == null || outStream == null;
                if (first) {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(this.myHost, this.myPort), this.myConnectTimeoutMs);
                    socket.setSoTimeout(longerReadTimeout ? Util.minInt((long)this.myReadTimeoutMs * 4L, Integer.MAX_VALUE) : this.myReadTimeoutMs);
                    try {
                        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.wrapOutputStream(socket.getOutputStream())));
                        this.myOutStream.set(out);
                        try {
                            DataInputStream input = new DataInputStream(new BufferedInputStream(this.wrapInputStream(socket.getInputStream())));
                            this.myInStream.set(input);
                            try {
                                communication.perform(input, out);
                                break block13;
                            }
                            finally {
                                this.myInStream.set(null);
                                input.close();
                            }
                        }
                        finally {
                            this.myOutStream.set(null);
                            out.close();
                        }
                    }
                    finally {
                        socket.close();
                    }
                }
                communication.perform(inStream, outStream);
            }
            catch (Throwable exc) {
                throw this.transformException(exc);
            }
        }
    }

    protected InputStream wrapInputStream(InputStream stream) {
        return stream;
    }

    protected OutputStream wrapOutputStream(OutputStream stream) {
        return stream;
    }

    @NotNull
    private PresentableException transformException(@NotNull Throwable exc) {
        String message;
        if (exc == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (exc instanceof UnknownHostException) {
            return new PresentableException("Cannot connect to host " + this.myHost);
        }
        if (exc instanceof PresentableException) {
            PresentableException presentableException = (PresentableException)exc;
            if (presentableException == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return presentableException;
        }
        if (exc instanceof IOException && (message = exc.getMessage()) != null && (message.startsWith("Connection refused") || message.startsWith("Connection reset"))) {
            return new PresentableException("There's no application running at " + this.myHost + " with profiler agent configured to listen on port " + this.myPort);
        }
        return new PresentableException("There's no application running at " + this.myHost + " with profiler agent configured to listen on port " + this.myPort + "\nor profiler agent is incompatible with current version of profiler", exc);
    }

    @NotNull
    public final String getHost() {
        String string = this.myHost;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public final int getPort() {
        return this.myPort;
    }

    @NotNull
    public String getHostId() {
        String string = this.myHostId;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public final void addListener(@NotNull ControllerListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (this.myListeners.contains(l)) {
            Asserts.fail();
        }
        this.myListeners.add(l);
    }

    public final void removeListener(@NotNull ControllerListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myListeners.remove(l);
    }

    private void fireAgentStatusChanged(long oldStatus, long newStatus) {
        int size = this.myListeners.size();
        for (int idx = 0; idx < size; ++idx) {
            this.myListeners.get(idx).statusChanged(this, oldStatus, newStatus);
        }
    }

    public final long getStatus() throws PresentableException {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 100000);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                ControllerImpl.this.setStatusCached(Packet.readLong(input));
            }
        });
        return this.myStatusCached;
    }

    public final long getStatusCached() {
        return this.myStatusCached;
    }

    private void setStatusCached(long status) {
        long oldStatus = this.myStatusCached;
        if (oldStatus == status) {
            return;
        }
        this.myStatusCached = status;
        this.fireAgentStatusChanged(oldStatus, status);
    }

    public final long getSessionId() {
        return this.mySessionId;
    }

    @NotNull
    public final String getSessionName() {
        String string = this.mySessionName;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public final String getSnapshotNameFormat() {
        String string = this.mySnapshotNameFormat;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    private static boolean isValidCpuProfilingMode(long mode) {
        return (mode & 0xFFFFFFFFFFF9FFFFL) == 4L || mode == 12L || mode == 4100L;
    }

    public final void startCpuProfiling(final long mode, final @Nullable String settings) {
        if (!ControllerImpl.isValidCpuProfilingMode(mode)) {
            throw new IllegalArgumentException("Invalid mode: " + mode);
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 100301);
                Packet.writeLong(output, mode);
                Packet.writeStringNullable(output, settings);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void startSampling(@Nullable String settings) {
        this.startCpuProfiling(4L, settings);
    }

    public void startAsyncSamplingCpu(@Nullable String settings) {
        this.startCpuProfiling(131076L, settings);
    }

    public void startAsyncSamplingPeriodic(@Nullable String settings) {
        this.startCpuProfiling(262148L, settings);
    }

    public void startTracing(@Nullable String settings) {
        this.startCpuProfiling(12L, settings);
    }

    public void startCallCounting() {
        this.startCpuProfiling(4100L, null);
    }

    public final void retransformClassesLoadedBeforeAgentAttached() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105203);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        }, true);
    }

    public void stopCpuProfiling() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 100400);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearCpuData() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 103700);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public final void startMonitorProfiling() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 102600);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void stopMonitorProfiling() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 102700);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public final void startStackTelemetry() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104300);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void stopStackTelemetry() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104400);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public final void startExceptionProfiling() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104500);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void stopExceptionProfiling() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104600);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearMonitorData() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 103800);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearExceptions() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104200);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearEventTables(@NotNull List<? extends String> tableNames) {
        if (tableNames == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        final String namesList = Strings.join(tableNames, "\n", false);
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105800);
                Packet.writeStringNotNull(output, namesList);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    @NotNull
    public String[] getTopEventTableNames() {
        final ObjectRef topTableNames = new ObjectRef();
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105900);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                String list = Packet.readStringNotNull(input);
                topTableNames.setRef(list.isEmpty() ? ArrayUtil.EMPTY_STRING_ARRAY : list.split("\n"));
            }
        });
        String[] stringArray = (String[])topTableNames.getRefNotNull();
        if (stringArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return stringArray;
    }

    public void startAllocationRecording(@Nullable String settings) {
        int recordEach = 10;
        int sizeLimit = 4096;
        long mode = 2L;
        if (settings != null) {
            for (String optionRaw : settings.split("[\n,]")) {
                Integer value;
                String option = optionRaw.trim();
                if (option.isEmpty()) continue;
                if ("exactStacks".equals(option)) {
                    mode = 2L;
                    continue;
                }
                if ("sampledStacks".equals(option)) {
                    mode = 8194L;
                    continue;
                }
                if ("counting".equals(option)) {
                    mode = 16386L;
                    continue;
                }
                if (option.startsWith("sizeLimit=")) {
                    value = Strings.parseInt(Strings.cutPrefix(option, "sizeLimit="));
                    if (value == null) {
                        throw new IllegalArgumentException("invalid 'sizeLimit': should be a number");
                    }
                    sizeLimit = value;
                    continue;
                }
                if (option.startsWith("recordEach=")) {
                    value = Strings.parseInt(Strings.cutPrefix(option, "recordEach="));
                    if (value == null || value < 0) {
                        throw new IllegalArgumentException("invalid 'recordEach': should be a number >= 0");
                    }
                    recordEach = value;
                    continue;
                }
                throw new IllegalArgumentException("unexpected option '" + option + "'");
            }
        }
        final int finalRecordEach = recordEach;
        final int finalSizeLimit = sizeLimit;
        final long finalMode = mode;
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 100106);
                Packet.writeInt(output, finalRecordEach);
                Packet.writeInt(output, finalSizeLimit);
                Packet.writeLong(output, finalMode);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void stopAllocationRecording() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 100200);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void clearAllocationData() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 103900);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    @NotNull
    public final long[] forceGc() {
        final long[] result = new long[2];
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 100500);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                result[0] = Packet.readLong(input);
                result[1] = Packet.readLong(input);
            }
        });
        if (result == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return result;
    }

    public void message(final @NotNull String category, final @NotNull String messageText, final @NotNull String detail) {
        if (category == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (messageText == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (detail == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104800);
                Packet.writeStringNotNull(output, category);
                Packet.writeStringNotNull(output, messageText);
                Packet.writeStringNotNull(output, detail);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public int getOomeDumperStatusCached() {
        return this.myOomeDumperStatusCached;
    }

    @NotNull
    public FrozenThreadInfo[] getFrozenThreadsCached() {
        FrozenThreadInfo[] frozenThreadInfoArray = this.myFrozenThreadsCached != null ? this.myFrozenThreadsCached : FrozenThreadInfo.EMPTY;
        if (frozenThreadInfoArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return frozenThreadInfoArray;
    }

    public boolean hasCapabilities(long mask) {
        return (this.myCapabilities & mask) != 0L;
    }

    public boolean isAttachMode() {
        return this.hasCapabilities(1024L);
    }

    @NotNull
    public final String captureSnapshot(final long snapshotFlags, final @Nullable String preferredSnapshotDir, final @Nullable String optionalFileName, final @Nullable ProgressListener listener) {
        final StringRef result = new StringRef();
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                int packetType;
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104006);
                Packet.writeLong(output, snapshotFlags);
                Packet.writeStringNotNull(output, preferredSnapshotDir != null ? preferredSnapshotDir : "");
                Packet.writeStringNotNull(output, optionalFileName != null ? optionalFileName : "");
                Packet.flush(output);
                while ((packetType = Packet.readHeader(input, "Communication with the profiled application failed.\nThe profiled application has been started with profiler agent\nincompatible with the current version of the profiler.")) == 100600) {
                    int percents = Packet.readInt(input);
                    if (percents < 0 || percents > 99) {
                        throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Wrong percents: " + percents);
                    }
                    if (listener == null) continue;
                    listener.update(percents);
                }
                if (packetType == 1) {
                    ControllerImpl.this.readAndValidateSessionId(input);
                    result.setRef(Packet.readStringNotNull(input));
                    return;
                }
                throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Unexpected packet type: " + packetType);
            }
        });
        String string = (String)result.getRefNotNull();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public final void transferSnapshot(@NotNull String snapshotPath, @NotNull ChunkProcessor processor, boolean compressed) {
        if (snapshotPath == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (compressed) {
            this.transferSnapshotCompressed(snapshotPath, processor);
        } else {
            this.transferSnapshotUncompressed(snapshotPath, processor);
        }
    }

    private void transferSnapshotUncompressed(final @NotNull String snapshotPath, final @NotNull ChunkProcessor processor) {
        if (snapshotPath == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                int read;
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 101000);
                Packet.writeStringNotNull(output, snapshotPath);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                long fileLength = Packet.readLong(input);
                if (fileLength <= 0L) {
                    throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Wrong file length: " + fileLength);
                }
                long transferred = 0L;
                byte[] buffer = new byte[65536];
                while ((read = Packet.readBytes(input, buffer)) != -1) {
                    if (transferred + (long)read > fileLength) {
                        throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Too long stream");
                    }
                    transferred += (long)read;
                    try {
                        processor.processNextChunk(fileLength, buffer, read);
                    }
                    catch (IOException e) {
                        throw new PresentableException("Error writing file " + processor.getTargetFile().getAbsolutePath(), e);
                    }
                    if (transferred != fileLength) continue;
                    break;
                }
            }
        });
    }

    private void transferSnapshotCompressed(final @NotNull String snapshotPath, final @NotNull ChunkProcessor processor) {
        if (snapshotPath == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.makeRequest(new Communication(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 101001);
                Packet.writeStringNotNull(output, snapshotPath);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                long fileLength = Packet.readLong(input);
                if (fileLength <= 0L) {
                    throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Wrong file length: " + fileLength);
                }
                Inflater inflater = new Inflater(true);
                try {
                    byte[] compressedData = new byte[65536];
                    byte[] uncompressedData = new byte[131072];
                    long transferred = 0L;
                    while (transferred != fileLength) {
                        int compressedDataLength;
                        inflater.reset();
                        while ((compressedDataLength = Packet.readInt(input)) != 0) {
                            input.readFully(compressedData, 0, compressedDataLength);
                            inflater.setInput(compressedData, 0, compressedDataLength);
                            try {
                                int uncompressedLength;
                                while ((uncompressedLength = inflater.inflate(uncompressedData, 0, uncompressedData.length)) != 0) {
                                    if (transferred + (long)uncompressedLength > fileLength) {
                                        throw new PresentableException("Communication with the profiled application failed.\nThe agent has returned incorrect data.", "Too long stream");
                                    }
                                    transferred += (long)uncompressedLength;
                                    try {
                                        processor.processNextChunk(fileLength, uncompressedData, uncompressedLength);
                                    }
                                    catch (IOException e) {
                                        throw new PresentableException("Error writing file " + processor.getTargetFile().getAbsolutePath(), e);
                                    }
                                }
                            }
                            catch (DataFormatException e) {
                                throw new PresentableException("Error reading compressed data stream", e);
                            }
                        }
                        continue;
                        return;
                    }
                }
                finally {
                    inflater.end();
                }
            }
        });
    }

    private void updateAllocationRecordingSettings() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104103);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                int recordEach = Packet.readInt(input);
                int sizeLimit = Packet.readInt(input);
                ControllerImpl.this.myAllocationRecordingSettingsCached = new AllocationRecordingSettings(recordEach, sizeLimit);
            }
        });
    }

    @NotNull
    public AllocationRecordingSettings getAllocationRecordingSettingsCached() {
        AllocationRecordingSettings allocationRecordingSettings = this.myAllocationRecordingSettingsCached;
        if (allocationRecordingSettings == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return allocationRecordingSettings;
    }

    public void getJvmThreadDump(final ObjectRef<ThreadInfoRes[]> op_result) {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 101300);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                Packet.readLong(input);
                int infoCount = Packet.readCount(input);
                ThreadInfoRes[] result = new ThreadInfoRes[infoCount];
                op_result.setRef(result);
                for (int i = infoCount - 1; i >= 0; --i) {
                    long threadId = Packet.readLong(input);
                    String threadName = Packet.readStringNotNull(input);
                    String lockName = Packet.readStringNullable(input);
                    long lockOwnerId = Packet.readLong(input);
                    int statusOrdinal = Packet.readInt(input);
                    boolean isDeadlocked = Packet.readBoolean(input);
                    int stackTraceElementCount = Packet.readCount(input);
                    StackTraceElementRes[] elements = new StackTraceElementRes[stackTraceElementCount];
                    for (int j = 0; j < stackTraceElementCount; ++j) {
                        String declaringClass = Packet.readStringNotNull(input);
                        String methodName = Packet.readStringNotNull(input);
                        String fileName = Packet.readStringNullable(input);
                        int lineNumber = Packet.readInt(input);
                        elements[j] = new StackTraceElementRes(declaringClass, methodName, fileName, lineNumber);
                    }
                    result[i] = new ThreadInfoRes(threadId, threadName, lockName, lockOwnerId, statusOrdinal, isDeadlocked, elements);
                }
            }
        });
    }

    private void updateOomeDumperStatus() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 101700);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                ControllerImpl.this.myOomeDumperStatusCached = Packet.readInt(input);
            }
        });
    }

    public void updateEventTableInfo() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                int tableIndex;
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104700);
                Packet.writeInt(output, ControllerImpl.this.myNextEventTableIndex);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                while ((tableIndex = Packet.readInt(input)) != -1) {
                    if (tableIndex < 32 || tableIndex >= 128) {
                        throw new IOException("Invalid table index: " + tableIndex);
                    }
                    ((ControllerImpl)ControllerImpl.this).myEventTableDescriptions[tableIndex - 32] = Packet.readStringNotNull(input);
                    ControllerImpl.this.myNextEventTableIndex = Math.max(ControllerImpl.this.myNextEventTableIndex, tableIndex + 1);
                }
            }
        });
    }

    public String getEventTableDescription(int tableIndex) {
        if (tableIndex < 32 || tableIndex >= 128) {
            throw new IllegalArgumentException("Invalid table index: " + tableIndex);
        }
        return this.myEventTableDescriptions[tableIndex - 32];
    }

    public void advanceGeneration(final @NotNull String description) {
        if (description == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 102301);
                Packet.writeStringNotNull(output, description);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void runBatch(final @NotNull Runnable batch) {
        if (batch == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(DataInputStream input, @NotNull DataOutputStream output) throws Exception {
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 103300);
                Packet.flush(output);
                batch.run();
                Packet.writeHeader(output, 103400);
                Packet.flush(output);
            }
        });
    }

    public void updateDatabaseTables(final int tableMask, final @NotNull TableUpdater tableUpdater) {
        if (tableUpdater == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws Exception {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 103501);
                Packet.writeInt(output, tableMask);
                for (int i = 0; i < 32; ++i) {
                    if ((tableMask & 1 << i) == 0) continue;
                    Packet.writeInt(output, tableUpdater.getModificationStamp(i));
                }
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                tableUpdater.updateTables(input);
            }
        });
    }

    @NotNull
    public String getDatabaseStatistics() {
        final StringRef result = new StringRef();
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws Exception {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 103600);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                result.setRef(Packet.readStringNotNull(input));
            }
        });
        String string = (String)result.getRefNotNull();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public HashMap<String, ProbeActivityMode> getProbes() {
        final HashMap<String, ProbeActivityMode> result = new HashMap<String, ProbeActivityMode>();
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                String probeClass;
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 104900);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                while ((probeClass = Packet.readStringNullable(input)) != null) {
                    int mode = Packet.readInt(input);
                    ProbeActivityMode modeObj = null;
                    for (ProbeActivityMode m : ProbeActivityMode.values()) {
                        if (m.myValue != mode) continue;
                        modeObj = m;
                        break;
                    }
                    if (modeObj == null) {
                        throw new PresentableException("Communication failed.\nThe response contains incorrect data.", "Unexpected probe activity mode: " + mode);
                    }
                    if (probeClass.startsWith("com.yourkit.probes.builtin.") && probeClass.endsWith("Support") || probeClass.equals("com.yourkit.probes.builtin.Messages") || probeClass.startsWith("com.yourkit.probes.youmonitor.") || probeClass.startsWith("com.yourkit.probes.triggers.")) continue;
                    result.put(probeClass, modeObj);
                }
            }
        });
        HashMap<String, ProbeActivityMode> hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return hashMap;
    }

    public void setProbes(final HashMap<String, ProbeActivityMode> probeClassName2mode) {
        for (Map.Entry<String, ProbeActivityMode> entry : probeClassName2mode.entrySet()) {
            String name = entry.getKey();
            ProbeActivityMode mode = entry.getValue();
            if (name == null) {
                throw new IllegalArgumentException("the map contains null keys");
            }
            if (mode != null) continue;
            throw new IllegalArgumentException("the map contains null values");
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105000);
                Packet.writeCount(output, probeClassName2mode.size());
                for (Map.Entry entry : probeClassName2mode.entrySet()) {
                    Packet.writeStringNotNull(output, (String)entry.getKey());
                    Packet.writeInt(output, ((ProbeActivityMode)((Object)entry.getValue())).myValue);
                }
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    @NotNull
    public String getTriggers() {
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105400);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                ControllerImpl.this.myTriggersCached = Packet.readStringNotNull(input);
            }
        });
        String string = this.myTriggersCached;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getTriggersCached() {
        String string = this.myTriggersCached;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public void setTriggers(final @NotNull String triggersDescription, final boolean append) {
        if (triggersDescription == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105500);
                Packet.writeStringNotNull(output, triggersDescription);
                Packet.writeBoolean(output, append);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    public void registerAndLoadProbesByBytecode(final @NotNull byte[][] probesBytes) {
        if (probesBytes == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105300);
                Packet.writeCount(output, probesBytes.length);
                for (byte[] bytes : probesBytes) {
                    if (bytes == null) {
                        Packet.writeCount(output, 0);
                        continue;
                    }
                    Packet.writeCount(output, bytes.length);
                    Packet.writeBytes(output, bytes, bytes.length);
                }
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
            }
        });
    }

    @NotNull
    public final List<? extends TransferableSnapshotInfo> getTransferableSnapshots() {
        final ArrayList result = new ArrayList();
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105601);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                int count = Packet.readCount(input);
                for (int i = 0; i < count; ++i) {
                    String path = Packet.readStringNotNull(input);
                    int digest = Packet.readInt(input);
                    long size = Packet.readLong(input);
                    long lastModifiedMs = Packet.readLong(input);
                    Packet.readLong(input);
                    result.add(new TransferableSnapshotInfo(path, digest, size, lastModifiedMs));
                }
            }
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return arrayList;
    }

    @NotNull
    public FrozenThreadInfo[] getFrozenThreads(final long frameMaturityThresholdMs) {
        final ArrayList result = new ArrayList();
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 105700);
                Packet.writeLong(output, frameMaturityThresholdMs);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                int count = Packet.readInt(input);
                for (int i = 0; i < count; ++i) {
                    int trn = Packet.readInt(input);
                    int frame = Packet.readInt(input);
                    long lastChangeUptimeNs = Packet.readLong(input);
                    result.add(new FrozenThreadInfo(trn, frame, lastChangeUptimeNs));
                }
            }
        });
        FrozenThreadInfo[] frozenThreadInfoArray = result.toArray(FrozenThreadInfo.EMPTY);
        if (frozenThreadInfoArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return frozenThreadInfoArray;
    }

    public final void clearCharts() {
        this.dispatchCommand("d_clear_charts");
    }

    @NotNull
    public final String getVmInfo() {
        String string = this.dispatchCommand("d_getVmInfo");
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public final long getTotalCreatedObjectCount() {
        return Strings.parseLong(this.dispatchCommand("d_get_total_created_object_count"), 0L);
    }

    public final long getTotalCreatedObjectSize() {
        return Strings.parseLong(this.dispatchCommand("d_get_total_created_object_size"), 0L);
    }

    @NotNull
    private String dispatchCommand(final @NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        final StringRef result = new StringRef();
        this.makeRequest(new Communication(){

            @Override
            public void perform(@NotNull DataInputStream input, @NotNull DataOutputStream output) throws IOException {
                if (input == null) {
                    throw new IllegalArgumentException("Parameter 1 must not be null");
                }
                if (output == null) {
                    throw new IllegalArgumentException("Parameter 2 must not be null");
                }
                Packet.writeHeader(output, 106000);
                Packet.writeStringNotNull(output, command);
                Packet.flush(output);
                ControllerImpl.this.readHeaderWithStandardResponse(input);
                result.setRef(Packet.readStringNotNull(input));
            }
        });
        String string = (String)result.getRefNotNull();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getAgentVersion() {
        String string = this.myAgentVersion;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public int getPid() {
        return this.myPid;
    }

    public int getTelemetryLimit() {
        return this.myTelemetryLimit;
    }

    public void addOnCloseHook(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myOnCloseHooks.add(runnable);
    }

    public void removeOnCloseHook(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myOnCloseHooks.remove(runnable);
    }

    public void executeOnCloseHooks() {
        for (Runnable runnable : this.myOnCloseHooks) {
            runnable.run();
        }
        this.myOnCloseHooks.clear();
    }

    private void readHeaderWithStandardResponse(@NotNull DataInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Packet.readHeaderWithStandardResponse(input);
        this.readAndValidateSessionId(input);
    }

    private void readAndValidateSessionId(@NotNull DataInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        long sessionId = Packet.readLong(input);
        if (this.mySessionId == 0L) {
            return;
        }
        if (sessionId != this.mySessionId) {
            this.myRestarted = true;
            throw new DifferentProfiledProcessRespondedException();
        }
    }

    public String toString() {
        return "ControllerImpl@" + Integer.toHexString(this.hashCode()) + "{" + this.myHost + ":" + this.myPort + " pid=" + this.myPid + " agent=" + this.myAgentVersion + "}";
    }

    public static class AgentVersionMismatchException
    extends IOException {
        @NotNull
        public String mySessionName = "";

        public AgentVersionMismatchException() {
            super("The application has been started with incompatible profiler agent version");
        }
    }

    public static class DifferentProfiledProcessRespondedException
    extends IOException {
        public DifferentProfiledProcessRespondedException() {
            super("A different process is now listening at the same host:port. The profiled application likely restarted.");
        }
    }

    public static interface ChunkProcessor {
        public void processNextChunk(long var1, byte[] var3, int var4) throws IOException;

        public File getTargetFile();
    }

    private static interface Communication {
        public void perform(DataInputStream var1, DataOutputStream var2) throws Exception;
    }
}

