/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.settings.DiagramConfigElement;
import com.intellij.diagram.settings.DiagramConfigGroup;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.Arrays;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@State(name="UmlConfiguration", storages={@Storage(value="uml.xml")})
public class DiagramConfiguration
implements PersistentStateComponent<DiagramConfiguration>,
Cloneable {
    @NotNull
    @NlsSafe
    public volatile String defaultScope = "All";
    @NotNull
    public volatile DiagramLayout layout = DiagramLayout.HIERARCHIC;
    public volatile boolean fitContentAfterLayout = false;
    public volatile boolean relayoutOnNewElements = true;
    @MapAnnotation(keyAttributeName="id", valueAttributeName="categories")
    public Map<String, String> categories = ConcurrentCollectionFactory.createConcurrentMap();

    @NotNull
    public static DiagramConfiguration getInstance() {
        DiagramConfiguration diagramConfiguration = (DiagramConfiguration)ApplicationManager.getApplication().getService(DiagramConfiguration.class);
        if (diagramConfiguration == null) {
            DiagramConfiguration.$$$reportNull$$$0(0);
        }
        return diagramConfiguration;
    }

    @Deprecated
    @NotNull
    public static DiagramConfiguration getConfiguration() {
        return DiagramConfiguration.getInstance();
    }

    public DiagramConfiguration getState() {
        return this;
    }

    public void loadState(@NotNull DiagramConfiguration state) {
        if (state == null) {
            DiagramConfiguration.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean isEnabledByDefault(@NotNull DiagramProvider<?> provider, @NotNull String catName) {
        if (provider == null) {
            DiagramConfiguration.$$$reportNull$$$0(2);
        }
        if (catName == null) {
            DiagramConfiguration.$$$reportNull$$$0(3);
        }
        String cats = this.categories.get(provider.getID());
        boolean enabledByDefault = DiagramConfiguration.getDefaultValue(provider, catName);
        if (cats == null) {
            return enabledByDefault;
        }
        return Arrays.asList(cats.split(";")).contains(catName) != enabledByDefault;
    }

    private static boolean getDefaultValue(@NotNull DiagramProvider<?> provider, @NotNull String catName) {
        if (provider == null) {
            DiagramConfiguration.$$$reportNull$$$0(4);
        }
        if (catName == null) {
            DiagramConfiguration.$$$reportNull$$$0(5);
        }
        for (DiagramCategory category : provider.getAllContentCategories()) {
            if (!category.getName().equals(catName)) continue;
            return category.isEnabledByDefault();
        }
        DiagramExtras<?> extras = provider.getExtras();
        for (DiagramConfigGroup group : extras.getAdditionalDiagramSettings()) {
            for (DiagramConfigElement element : group.getElements()) {
                if (!element.getName().equals(catName)) continue;
                return element.isChecked();
            }
        }
        throw new IllegalArgumentException("There is no element '" + catName + "' in UML provider " + provider.getID());
    }

    public DiagramConfiguration clone() throws CloneNotSupportedException {
        return (DiagramConfiguration)super.clone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/settings/DiagramConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/settings/DiagramConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledByDefault";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

