/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.extras.custom;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.components.ScalableIconWrapper;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.icons.AllIcons;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CommonDiagramExtras<T>
extends DiagramExtras<T> {
    public static final DiagramCategory SELECTION_MODE = new DiagramCategory(DiagramBundle.message("category.name.show.neighbours.of.selected.nodes", new Object[0]), AllIcons.Graph.NodeSelectionMode, false, true, true, true);
    public static final DiagramCategory BORDERS = new DiagramCategory(DiagramBundle.message("category.name.borderless", new Object[0]), AllIcons.Graph.SnapToGrid, false, false, false);
    public static final DiagramCategory PATH_TO_ROOT = new DiagramCategory(DiagramBundle.message("category.name.show.paths.root.selection", new Object[0]), AllIcons.Hierarchy.Subtypes, false, true, true, true);

    @Override
    @NotNull
    public JComponent createNodeComponent(DiagramNode<T> node, DiagramBuilder builder, Point basePoint, JPanel wrapper) {
        JComponent jComponent = this.createLabelNode(node, builder, wrapper);
        if (jComponent == null) {
            CommonDiagramExtras.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    @NotNull
    public JComponent createLabelNode(DiagramNode<T> node, DiagramBuilder builder, JPanel wrapper) {
        DiagramNodeContentManager nodeContentManager = builder.getDataModel().getNodeContentManager();
        this.setNodeBorders(wrapper, nodeContentManager.isCategoryEnabled(BORDERS));
        wrapper.setBackground(builder.getColorScheme().getDefaultBackground());
        SimpleColoredComponent simpleColoredComponent = this.createLabel(builder, node);
        if (simpleColoredComponent == null) {
            CommonDiagramExtras.$$$reportNull$$$0(1);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public SimpleColoredComponent createLabel(DiagramBuilder builder, DiagramNode<T> node) {
        Icon icon;
        SimpleColoredComponent label = new SimpleColoredComponent();
        label.setOpaque(false);
        label.setIconOpaque(false);
        label.setForeground(builder.getColorScheme().getDefaultForeground());
        DiagramElementManager<?> manager = builder.getProvider().getElementManager();
        String presentableName = manager.getElementTitle(node.getIdentifyingElement());
        if (presentableName != null) {
            label.append(presentableName, new SimpleTextAttributes(0, null));
        }
        label.setIcon((Icon)((icon = node.getIcon()) != null ? ScalableIconWrapper.evaluateDeferredAndWrap(icon) : null));
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            CommonDiagramExtras.$$$reportNull$$$0(2);
        }
        return simpleColoredComponent;
    }

    protected void setNodeBorders(JPanel wrapper, boolean showBorders) {
        if (showBorders) {
            wrapper.setBorder(JBUI.Borders.customLine((Color)(StartupUiUtil.isUnderDarcula() ? JBColor.foreground() : JBColor.border())));
        } else {
            wrapper.setBorder((Border)JBUI.Borders.empty());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/diagram/extras/custom/CommonDiagramExtras";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabelNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

