/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.components.ScalableIconWrapper;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramNodeItemComponent
extends CellRendererPanel {
    private final SimpleColoredComponent myLeft = new SimpleColoredComponent();
    private final SimpleColoredComponent myRight = new SimpleColoredComponent();

    public DiagramNodeItemComponent() {
        this.setLayout(new BorderLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)1, (int)2));
        this.add((Component)this.myLeft, "West");
        this.add((Component)this.myRight, "East");
        if (GraphViewUtil.isPrintMode()) {
            this.setBackground(Color.WHITE);
        }
        this.myLeft.setOpaque(true);
        this.myLeft.setIconOpaque(true);
        this.myRight.setOpaque(true);
        this.myRight.setIconOpaque(true);
        this.setOpaque(true);
    }

    public void setUp(@NotNull DiagramBuilder builder, @NotNull DiagramNode node, Object element, boolean selected) {
        SimpleColoredText typeText;
        if (builder == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(0);
        }
        if (node == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(1);
        }
        this.myLeft.clear();
        this.myRight.clear();
        DiagramProvider<?> provider = builder.getProvider();
        DiagramElementManager<?> mgr = provider.getElementManager();
        DiagramColorManager colorManager = builder.getProvider().getColorManager();
        Color forcedForeground = GraphViewUtil.isPrintMode() ? builder.getColorScheme().getDefaultForeground() : (selected ? colorManager.getNodeForeground(builder, node, element, true) : null);
        Color anchorColor = DiagramNodeItemComponent.getAnchorColor(builder, node, element);
        Icon icon = mgr.getItemIcon(element, builder);
        ScalableIcon scalableIcon = icon != null ? ScalableIconWrapper.evaluateDeferredAndWrap(icon) : null;
        this.myLeft.setIcon((Icon)(scalableIcon != null ? scalableIcon : icon));
        SimpleColoredText text = mgr.getItemName(element, builder);
        if (text != null) {
            DiagramNodeItemComponent.doAppend(this.myLeft, text, selected, forcedForeground, anchorColor);
        }
        if ((typeText = mgr.getItemType(element)) != null) {
            DiagramNodeItemComponent.doAppend(this.myRight, typeText, selected, forcedForeground, anchorColor);
        }
        if (GraphViewUtil.isPrintMode()) {
            this.setForeground((Color)JBColor.BLACK);
            this.setForcedBackground((Color)JBColor.WHITE);
        } else {
            Color defaultFg;
            Color foreground;
            Color background = colorManager.getNodeBackground(builder, node, element, selected);
            if (!ColorUtil.areContrasting((Color)background, (Color)(foreground = colorManager.getNodeForeground(builder, node, element, selected))) && ColorUtil.areContrasting((Color)background, (Color)(defaultFg = EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultForeground()))) {
                foreground = defaultFg;
            }
            this.setBackground(background);
            this.setForeground(foreground);
            this.setSelected(selected);
        }
    }

    private static void doAppend(@NotNull SimpleColoredComponent target, @NotNull SimpleColoredText text, boolean selected, @Nullable Color foreground, @Nullable Color anchor) {
        if (target == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(2);
        }
        if (text == null) {
            DiagramNodeItemComponent.$$$reportNull$$$0(3);
        }
        if (anchor == null && foreground == null) {
            text.appendToComponent((ColoredTextContainer)target);
            return;
        }
        ArrayList attrs = text.getAttributes();
        ArrayList texts = text.getTexts();
        for (int i = 0; i < texts.size(); ++i) {
            SimpleTextAttributes attr = (SimpleTextAttributes)attrs.get(i);
            Color fg = selected ? null : (anchor != null ? anchor : foreground);
            Color bg = selected ? null : attr.getBgColor();
            int style = attr.getStyle() | (anchor != null ? 1 : 0);
            target.append((String)texts.get(i), new SimpleTextAttributes(bg, fg, attr.getWaveColor(), style));
        }
    }

    @Nullable
    private static Color getAnchorColor(DiagramBuilder builder, DiagramNode node, Object element) {
        DiagramEdge<?> e;
        Object anchor;
        Edge edge;
        Node yNode = builder.getNode(node);
        if (yNode == null) {
            return null;
        }
        EdgeCursor in = yNode.inEdges();
        EdgeCursor out = yNode.outEdges();
        while ((edge = in.edge()) != null) {
            if (builder.getGraph().isSelected(edge) && (anchor = (e = builder.getEdgeObject(edge)).getTargetAnchor()) != null && element.equals(anchor)) {
                Color color = e.getAnchorColor();
                return color == null ? JBColor.foreground() : color;
            }
            in.next();
        }
        while ((edge = out.edge()) != null) {
            if (builder.getGraph().isSelected(edge) && (anchor = (e = builder.getEdgeObject(edge)).getSourceAnchor()) != null && element.equals(anchor)) {
                Color color = e.getAnchorColor();
                return color == null ? JBColor.foreground() : color;
            }
            out.next();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagram/components/DiagramNodeItemComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setUp";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doAppend";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

