/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.components.DiagramNodeHeaderComponent;
import com.intellij.diagram.components.JBHiDPIVolatileImage;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiagramNodeContainer
extends CellRendererPanel {
    @NotNull
    @NonNls
    private static final String DO_USE_RENDER_CACHE_REGKEY = "diagrams.rendering.use.render.cache";
    @NotNull
    @NonNls
    private static final String DO_USE_VOLATILE_IMAGES_REGKEY = "diagrams.rendering.use.volatile.images.for.cache";
    @NotNull
    @NonNls
    private static final String MAX_NODE_SIZE_TO_CACHE_REGKEY = "diagrams.rendering.max.node.size.to.cache";
    @NotNull
    private final CellRendererPanel myHeader;
    @NotNull
    private final CellRendererPanel myBody;
    @NotNull
    private final DiagramNodeBodyComponent myNodeBodyComponent;
    @NotNull
    private final DiagramNode<?> myNode;
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final MyRenderCacheHandler myRenderCacheHandler;
    @NotNull
    private final MyColorManager myColorManager;
    private boolean myIsSelected;

    public DiagramNodeContainer(@NotNull DiagramNode<?> node, @NotNull DiagramBuilder builder, @NotNull Point basePointForPopup) {
        if (node == null) {
            DiagramNodeContainer.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramNodeContainer.$$$reportNull$$$0(1);
        }
        if (basePointForPopup == null) {
            DiagramNodeContainer.$$$reportNull$$$0(2);
        }
        DiagramColorManager colorManager = builder.getProvider().getColorManager();
        this.myBuilder = builder;
        this.myNode = node;
        this.myHeader = new DiagramNodeHeaderComponent(builder, node);
        this.myHeader.setFont(colorManager.getNodeHeaderFont(builder));
        this.myNodeBodyComponent = new DiagramNodeBodyComponent(this.myNode, builder, basePointForPopup);
        this.myNodeBodyComponent.setFont(colorManager.getNodeBodyFont());
        this.myBody = new CellRendererPanel();
        this.myBody.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myBody.setBorder((Border)JBUI.Borders.empty());
        this.myBody.setOpaque(true);
        this.myBody.add((Component)((Object)this.myNodeBodyComponent));
        this.myRenderCacheHandler = new MyRenderCacheHandler(this);
        this.myColorManager = new MyColorManager();
        this.setFocusable(false);
        this.setOpaque(true);
        this.switchHeaderSeparator(this.myNodeBodyComponent.getModel().getSize() > 0, false);
        this.setBorder(this.getMyBorder(false));
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.myHeader, "North");
        if (this.myBody.getComponentCount() > 0) {
            this.add((Component)this.myBody, "Center");
        }
        for (JComponent c : UIUtil.uiTraverser((Component)((Object)this)).filter(JComponent.class)) {
            ComponentUtil.putClientProperty((JComponent)c, (Key)IdeBackgroundUtil.NO_BACKGROUND, (Object)true);
        }
    }

    @NotNull
    public JPanel getHeader() {
        CellRendererPanel cellRendererPanel = this.myHeader;
        if (cellRendererPanel == null) {
            DiagramNodeContainer.$$$reportNull$$$0(3);
        }
        return cellRendererPanel;
    }

    @NotNull
    public JPanel getBody() {
        CellRendererPanel cellRendererPanel = this.myBody;
        if (cellRendererPanel == null) {
            DiagramNodeContainer.$$$reportNull$$$0(4);
        }
        return cellRendererPanel;
    }

    public void switchHeaderSeparator(boolean on, boolean isSelected) {
        this.myHeader.setBorder((Border)(on ? new CustomLineBorder(this.myColorManager.getSeparatorColor(isSelected), 0, 0, 1, 0) : JBUI.Borders.empty()));
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.isShadingNeeded()) {
            g2d.setComposite(this.myColorManager.getShadingComposite(this.myNode.getIdentifyingElement()));
        }
        this.updateIfSelectionChanged();
        if (GraphViewUtil.isPrintMode() || GraphViewUtil.isExportMode() || UIUtil.isPrinting((Graphics)g) || Boolean.TRUE.equals(this.getClientProperty("cell.editor")) || !Registry.is((String)DO_USE_RENDER_CACHE_REGKEY)) {
            this.doPaintComponent(g2d);
        } else {
            this.myRenderCacheHandler.paint(g2d);
        }
    }

    private void updateIfSelectionChanged() {
        boolean isCurrentlySelected = this.myBuilder.getGraph().isSelected(this.myBuilder.getNode(this.myNode));
        if (this.myIsSelected != isCurrentlySelected) {
            this.myIsSelected = isCurrentlySelected;
            this.myRenderCacheHandler.selectionChanged();
            this.setBorder(this.getMyBorder(isCurrentlySelected));
        }
    }

    private void updateContent() {
        DefaultListModel bodyComponentListModel = (DefaultListModel)this.myNodeBodyComponent.getModel();
        bodyComponentListModel.clear();
        bodyComponentListModel.addAll(Arrays.asList(DiagramNodeBodyComponent.getNodeItems(this.myNode.getIdentifyingElement(), this.myBuilder)));
    }

    private void doPaintComponent(@NotNull Graphics2D g) {
        if (g == null) {
            DiagramNodeContainer.$$$reportNull$$$0(5);
        }
        Object element = this.myNode.getIdentifyingElement();
        this.myHeader.setForeground(this.myColorManager.getHeaderForegroundColor(element));
        this.myHeader.setForcedBackground(this.myColorManager.getHeaderForcedBackgroundColor(element));
        this.switchHeaderSeparator(this.myNodeBodyComponent.getModel().getSize() > 0, this.myIsSelected);
        this.myHeader.validate();
        this.myBody.setForcedBackground(this.myColorManager.getBodyBackgroundColor(element));
        super.paint((Graphics)g);
    }

    @NotNull
    private Border getMyBorder(boolean isSelected) {
        Color borderColor = this.myColorManager.getSeparatorColor(isSelected);
        return GraphViewUtil.isPrintMode() ? new LineBorder(borderColor, 2) : new LineBorder(borderColor);
    }

    private boolean isShadingNeeded() {
        return Boolean.FALSE.equals(this.myNode.getUserData(DiagramNode.SELECTED_NODE_KEY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePointForPopup";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeContainer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeContainer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doPaintComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PairObjLong<V> {
        V data;
        long stamp;

        private PairObjLong(V data, long stamp) {
            this.data = data;
            this.stamp = stamp;
        }
    }

    private final class MyColorManager {
        private MyColorManager() {
        }

        @Nullable
        private Color getHeaderForcedBackgroundColor(@NotNull Object element) {
            if (element == null) {
                MyColorManager.$$$reportNull$$$0(0);
            }
            DiagramColorManager colorManager = DiagramNodeContainer.this.myBuilder.getProvider().getColorManager();
            return GraphViewUtil.isPrintMode() ? null : colorManager.getNodeHeaderBackground(DiagramNodeContainer.this.myBuilder, DiagramNodeContainer.this.myNode, element);
        }

        @NotNull
        private Color getHeaderForegroundColor(@NotNull Object element) {
            Color defaultFgColor;
            if (element == null) {
                MyColorManager.$$$reportNull$$$0(1);
            }
            Color headerFgOverrideColor = GraphViewUtil.isPrintMode() ? null : DiagramUtils.getFileTabForeground(element);
            Color headerFgColor = headerFgOverrideColor != null ? headerFgOverrideColor : DiagramNodeContainer.this.myBuilder.getColorScheme().getDefaultForeground();
            Color headerBgColor = this.getHeaderForcedBackgroundColor(element);
            if (headerBgColor != null && !ColorUtil.areContrasting((Color)headerBgColor, (Color)headerFgColor) && ColorUtil.areContrasting((Color)headerBgColor, (Color)(defaultFgColor = EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultForeground()))) {
                Color color = defaultFgColor;
                if (color == null) {
                    MyColorManager.$$$reportNull$$$0(2);
                }
                return color;
            }
            Color color = headerFgColor;
            if (color == null) {
                MyColorManager.$$$reportNull$$$0(3);
            }
            return color;
        }

        @Nullable
        private Color getBodyBackgroundColor(@NotNull Object element) {
            if (element == null) {
                MyColorManager.$$$reportNull$$$0(4);
            }
            DiagramColorManager colorManager = DiagramNodeContainer.this.myBuilder.getProvider().getColorManager();
            return GraphViewUtil.isPrintMode() ? null : colorManager.getNodeBackground(DiagramNodeContainer.this.myBuilder, DiagramNodeContainer.this.myNode, element, false);
        }

        @NotNull
        private Color getSeparatorColor(boolean isSelected) {
            Color color = DiagramNodeContainer.this.myBuilder.getProvider().getColorManager().getNodeBorderColor(DiagramNodeContainer.this.myBuilder, DiagramNodeContainer.this.myNode, isSelected);
            if (color == null) {
                MyColorManager.$$$reportNull$$$0(5);
            }
            return color;
        }

        @NotNull
        private AlphaComposite getShadingComposite(@NotNull Object element) {
            Color headerBgColor;
            if (element == null) {
                MyColorManager.$$$reportNull$$$0(6);
            }
            Color bg = (headerBgColor = this.getHeaderForcedBackgroundColor(element)) != null ? headerBgColor : DiagramNodeContainer.this.myBuilder.getColorScheme().getDefaultBackground();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, ColorUtil.isDark((Color)bg) ? 0.7f : 0.5f);
            if (alphaComposite == null) {
                MyColorManager.$$$reportNull$$$0(7);
            }
            return alphaComposite;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/components/DiagramNodeContainer$MyColorManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/components/DiagramNodeContainer$MyColorManager";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaderForegroundColor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparatorColor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShadingComposite";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getHeaderForcedBackgroundColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getHeaderForegroundColor";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getBodyBackgroundColor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getShadingComposite";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyRenderCacheHandler {
        @NotNull
        private final DiagramNodeContainer myOwner;
        @NotNull
        private final SimpleModificationTracker mySelectionModTracker;
        @NotNull
        private final ModificationTracker myViewModTracker;
        @NotNull
        private final ModificationTracker myZoomModTracker;
        @Nullable
        private GraphicsConfiguration myLastGraphicsConfiguration;
        private static final @NotNull Map<MyRenderCacheHandler, PairObjLong<@Nullable Image>> OUR_CACHES = CollectionFactory.createWeakIdentityMap((int)20, (float)0.8f);
        @NotNull
        private static final PaintUtil.RoundingMode OUR_ROUNDING_MODE = PaintUtil.RoundingMode.CEIL;

        MyRenderCacheHandler(@NotNull DiagramNodeContainer owner) {
            if (owner == null) {
                MyRenderCacheHandler.$$$reportNull$$$0(0);
            }
            this.myOwner = owner;
            this.mySelectionModTracker = new SimpleModificationTracker();
            this.myViewModTracker = owner.myBuilder.getPresentationModel().getModificationTrackerOfViewUpdates();
            this.myZoomModTracker = Objects.requireNonNullElseGet(owner.myBuilder.getPresentationModel().getModificationTrackerOfZoomChanged(), () -> new SimpleModificationTracker());
        }

        private void selectionChanged() {
            this.mySelectionModTracker.incModificationCount();
        }

        @Nullable
        private Image getRenderCache(double currentViewportScale) {
            Image renderCache;
            long currentModStamp = this.mySelectionModTracker.getModificationCount() + this.myViewModTracker.getModificationCount() + this.myZoomModTracker.getModificationCount();
            PairObjLong cache = OUR_CACHES.computeIfAbsent(this, __ -> new PairObjLong<Image>(this.computeUpToDateCacheIfPossible(currentViewportScale), currentModStamp));
            if (cache.stamp != currentModStamp) {
                if (cache.data != null) {
                    ((Image)cache.data).flush();
                }
                renderCache = this.computeUpToDateCacheIfPossible(currentViewportScale);
                OUR_CACHES.put(this, new PairObjLong<Image>(renderCache, currentModStamp));
            } else {
                renderCache = (Image)cache.data;
            }
            return renderCache;
        }

        private static boolean areEqual(double a, double b) {
            return Math.abs(a - b) < 0.01;
        }

        public void paint(@NotNull Graphics2D g) {
            if (g == null) {
                MyRenderCacheHandler.$$$reportNull$$$0(1);
            }
            this.myLastGraphicsConfiguration = g.getDeviceConfiguration();
            AffineTransform currTransform = g.getTransform();
            assert (MyRenderCacheHandler.areEqual(currTransform.getScaleX(), currTransform.getScaleY()));
            double viewportScale = this.myOwner.myBuilder.getZoom();
            if (this.myOwner.myBuilder.getGraphBuilder().getActiveMode() instanceof MagnifierViewMode && !MyRenderCacheHandler.areEqual(currTransform.getScaleX(), viewportScale) && !MyRenderCacheHandler.areEqual(currTransform.getScaleX(), viewportScale * (double)JBUIScale.sysScale((GraphicsConfiguration)this.myLastGraphicsConfiguration))) {
                this.myOwner.doPaintComponent(g);
                return;
            }
            Image image = this.getRenderCache(viewportScale);
            do {
                int validateResult = image instanceof VolatileImage ? ((VolatileImage)image).validate(this.myLastGraphicsConfiguration) : -1;
                switch (validateResult) {
                    case 1: {
                        this.fillRenderCache(viewportScale, image);
                        break;
                    }
                    case 2: {
                        image.flush();
                        image = this.computeUpToDateCacheIfPossible(viewportScale);
                    }
                }
                if (image == null) {
                    this.myOwner.doPaintComponent(g);
                    return;
                }
                g.scale(1.0 / viewportScale, 1.0 / viewportScale);
                JBHiDPIVolatileImage.drawImage(g, image, 0, 0, null);
                g.setTransform(currTransform);
            } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost());
        }

        @Nullable
        private Image computeUpToDateCacheIfPossible(double viewportScale) {
            this.myOwner.updateContent();
            this.myOwner.forceInvalidate();
            int widthScaled = OUR_ROUNDING_MODE.round((double)this.myOwner.getWidth() * viewportScale);
            int heightScaled = OUR_ROUNDING_MODE.round((double)this.myOwner.getHeight() * viewportScale);
            Image result = null;
            if (!MyRenderCacheHandler.isTooLargeToCache(widthScaled, heightScaled)) {
                result = MyRenderCacheHandler.createRenderCache(widthScaled, heightScaled, this.myLastGraphicsConfiguration);
                this.fillRenderCache(viewportScale, result);
            }
            return result;
        }

        private static boolean isTooLargeToCache(int width, int height) {
            return width * height > Registry.intValue((String)DiagramNodeContainer.MAX_NODE_SIZE_TO_CACHE_REGKEY);
        }

        @NotNull
        private static Image createRenderCache(int widthScaled, int heightScaled, @Nullable GraphicsConfiguration cfg) {
            if (cfg == null) {
                cfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            if (Registry.is((String)DiagramNodeContainer.DO_USE_VOLATILE_IMAGES_REGKEY)) {
                return new JBHiDPIVolatileImage(cfg, widthScaled, heightScaled, 1, 1.0f, OUR_ROUNDING_MODE);
            }
            BufferedImage bufferedImage = ImageUtil.createImage((GraphicsConfiguration)cfg, (int)widthScaled, (int)heightScaled, (int)1);
            if (bufferedImage == null) {
                MyRenderCacheHandler.$$$reportNull$$$0(2);
            }
            return bufferedImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void fillRenderCache(double viewportScale, @NotNull Image image) {
            void image2;
            if (image == null) {
                MyRenderCacheHandler.$$$reportNull$$$0(3);
            }
            if (image2 instanceof VolatileImage) {
                ((VolatileImage)image2).validate(this.myLastGraphicsConfiguration);
            }
            Graphics2D g = (Graphics2D)image2.getGraphics();
            try {
                g.setColor(this.myOwner.myBuilder.getColorScheme().getDefaultBackground());
                g.fillRect(0, 0, ImageUtil.getRealWidth((Image)image2), ImageUtil.getRealHeight((Image)image2));
                g.scale(viewportScale, viewportScale);
                this.myOwner.doPaintComponent(g);
            }
            finally {
                g.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/components/DiagramNodeContainer$MyRenderCacheHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/components/DiagramNodeContainer$MyRenderCacheHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRenderCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fillRenderCache";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

