/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DiagramIntentionAction
extends DiagramAction {
    private static final Logger LOG = Logger.getInstance(DiagramIntentionAction.class);

    protected DiagramIntentionAction() {
        super(DiagramBundle.message("show.intentions.for.node", new Object[0]), null, null);
    }

    @Override
    public void perform(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(0);
        }
        if ((builder = DiagramIntentionAction.getBuilder(e)) == null) {
            return;
        }
        DiagramNode node = DiagramIntentionAction.getSelectedNodes(e).get(0);
        ArrayList actions = new ArrayList();
        for (DiagramNodeIntentionAction<?> action : builder.getProvider().getNodeIntentionActions()) {
            if (!action.isEnabled(e, builder)) continue;
            actions.add(action);
        }
        JBList list = new JBList(actions);
        list.installCellRenderer(obj -> {
            Presentation presentation = obj.getTemplatePresentation();
            String actionText = presentation.getText();
            LOG.assertTrue(actionText != null, (Object)obj);
            String text = StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)actionText));
            Icon icon = presentation.getIcon();
            JLabel label = new JLabel(text, icon == null ? AllIcons.Actions.IntentionBulb : icon, 2);
            label.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)4, (int)10));
            return label;
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setAutoselectOnMouseMove(true).setItemChoosenCallback(() -> {
            DiagramNodeIntentionAction value = (DiagramNodeIntentionAction)((Object)((Object)list.getSelectedValue()));
            if (value != null) {
                value.perform(node, builder);
            }
        }).createPopup();
        Utils.showPopupBeneathNode(popup, builder.getNode(node), builder.getView());
    }

    @Override
    public boolean isEnabled(@NotNull AnActionEvent e, DiagramBuilder b) {
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(1);
        }
        for (DiagramNodeIntentionAction<?> action : b.getProvider().getNodeIntentionActions()) {
            if (!action.isEnabled(e, b)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Override
    public String getActionName() {
        return DiagramBundle.message("show.intentions.for.node", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/diagram/actions/DiagramIntentionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

