/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import java.util.Comparator;
import org.jetbrains.annotations.Nls;

public interface DiagramElementsProvider<T> {
    public static final Comparator<PsiElement> PSI_COMPARATOR = (o1, o2) -> {
        boolean n1 = o1 instanceof PsiNamedElement;
        boolean n2 = o2 instanceof PsiNamedElement;
        if (n1 && n2) {
            String name1 = ((PsiNamedElement)o1).getName();
            String name2 = ((PsiNamedElement)o2).getName();
            return name1 == null ? (name2 == null ? 0 : 1) : (name2 == null ? -1 : name1.compareTo(name2));
        }
        return n1 ? -1 : 1;
    };
    public static final DiagramElementsProvider[] EMPTY_ARRAY = new DiagramElementsProvider[0];

    public T[] getElements(T var1, Project var2);

    @Nls
    public String getName();

    @Nls
    public String getHeaderName(T var1, Project var2);

    public ShortcutSet getShortcutSet();

    public Comparator<? super T> getComparator();

    public boolean showProgress();

    @Nls
    public String getProgressMessage();

    public boolean isEnabledOn(T var1);
}

