/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramProviderHolder;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiagramElementManager<T>
extends DiagramProviderHolder<T> {
    @NotNull
    public static final SimpleTextAttributes DEFAULT_TEXT_ATTR = new SimpleTextAttributes(0, null);
    @NotNull
    public static final SimpleTextAttributes DEFAULT_TITLE_ATTR = new SimpleTextAttributes(1, null);

    @Nullable
    public T findInDataContext(@NotNull DataContext var1);

    @NotNull
    public Collection<T> findElementsInDataContext(@NotNull DataContext var1);

    default public boolean canBeBuiltFrom(@Nullable Object element) {
        return this.isAcceptableAsNode(element);
    }

    public boolean isAcceptableAsNode(@Nullable Object var1);

    public Object @NotNull [] getNodeItems(T var1);

    public boolean canCollapse(T var1);

    public boolean isContainerFor(T var1, T var2);

    @Nullable
    @Nls
    public String getElementTitle(T var1);

    @Nullable
    default public SimpleColoredText getPresentableElementTitle(T element) {
        String presentableName = this.getElementTitle(element);
        int textStyle = this instanceof AbstractDiagramElementManager ? ((AbstractDiagramElementManager)this).getTitleAttributes(element) : 0;
        return presentableName != null ? new SimpleColoredText(presentableName, new SimpleTextAttributes(textStyle, null)) : null;
    }

    @Deprecated
    @Nullable
    default public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            DiagramElementManager.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    default public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(1);
        }
        return this.getItemName(element, builder.getPresentation());
    }

    @Nullable
    public SimpleColoredText getItemType(@Nullable Object var1);

    @Nullable
    default public Icon getItemIcon(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            DiagramElementManager.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    default public Icon getItemIcon(@Nullable Object element, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramElementManager.$$$reportNull$$$0(3);
        }
        return this.getItemIcon(element, builder.getPresentation());
    }

    @Nullable
    @Nls
    public String getNodeTooltip(T var1);

    @Deprecated
    @Nullable
    @Nls
    default public String getEditorTitle(T element, @NotNull DiagramState presentation, @NotNull Collection<T> additionalElements) {
        if (presentation == null) {
            DiagramElementManager.$$$reportNull$$$0(4);
        }
        if (additionalElements == null) {
            DiagramElementManager.$$$reportNull$$$0(5);
        }
        return this.getEditorTitle(element, additionalElements);
    }

    @Nullable
    @Nls
    default public String getEditorTitle(T element, @NotNull Collection<T> additionalElements) {
        if (additionalElements == null) {
            DiagramElementManager.$$$reportNull$$$0(6);
        }
        return this.getEditorTitle(element, DiagramState.empty(null), additionalElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalElements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagram/DiagramElementManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorTitle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

