/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Point;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiagramBuilder
extends Disposable,
UserDataHolder {
    @NotNull
    public Project getProject();

    @NotNull
    public Graph2D getGraph();

    @NotNull
    public Graph2DView getView();

    @Nullable
    default public Overview getOverview() {
        return null;
    }

    @NotNull
    public Collection<DiagramNode<?>> getNodeObjects();

    @Nullable
    public Node getNode(DiagramNode<?> var1);

    @Nullable
    public DiagramNode<?> getNodeObject(Node var1);

    @NotNull
    public Collection<DiagramEdge<?>> getEdgeObjects();

    @Nullable
    public Edge getEdge(DiagramEdge<?> var1);

    @Nullable
    public DiagramEdge<?> getEdgeObject(Edge var1);

    default public boolean doAllowEdgeCreation() {
        return true;
    }

    public void setAllowEdgeCreation(boolean var1);

    @Deprecated
    @NotNull
    public DiagramState getPresentation();

    @NotNull
    public DiagramPresentationModel getPresentationModel();

    @NotNull
    public DiagramDataModel<?> getDataModel();

    @NotNull
    public DiagramProvider<?> getProvider();

    public void setSelected(@NotNull DiagramNode<?> var1, boolean var2);

    public void setSelected(@NotNull DiagramEdge<?> var1, boolean var2);

    @Nullable
    public DiagramFileEditor getEditor();

    public void setEditor(@NotNull DiagramFileEditor var1);

    @Nullable
    public DocumentReference getDocumentReference();

    public void update();

    public void update(boolean var1, boolean var2);

    public boolean isPopupMode();

    @Nullable
    public JBPopup getPopup();

    public void setPopup(@NotNull JBPopup var1);

    public void relayout();

    @Deprecated
    public void updateGraph();

    public void updateDataModel();

    public void initialize();

    public void updateView();

    public void createDraggedNode(@NotNull DiagramNode<?> var1, @Nullable String var2, @NotNull Point var3);

    public void requestFocus();

    public double getZoom();

    public void setZoom(double var1);

    public void notifyOtherBuilders();

    @NotNull
    public GraphBuilder<DiagramNode<?>, DiagramEdge<?>> getGraphBuilder();

    @NotNull
    public EditorColorsScheme getColorScheme();
}

