/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.FileTextMatcher;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt$WhenMappings;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.DirectorySpecBase;
import com.intellij.util.io.impl.FileSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b\u001a<\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0007*\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"assertDirectoryContentMatches", "", "file", "Ljava/io/File;", "spec", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "relativePath", "", "fileTextMatcher", "Lcom/intellij/util/io/FileTextMatcher;", "filePathFilter", "Lkotlin/Function1;", "", "assertDirectoryMatches", "Lcom/intellij/util/io/impl/DirectorySpecBase;", "createSpecByDirectory", "Lcom/intellij/util/io/impl/DirectorySpec;", "dir", "Ljava/nio/file/Path;", "createSpecByPath", "path", "convertToText", "", "intellij.platform.testFramework"})
public final class DirectoryContentSpecImplKt {
    public static final void assertDirectoryContentMatches(@NotNull File file2, @NotNull DirectoryContentSpecImpl spec, @NotNull String relativePath, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter) {
        block1: {
            String place;
            block3: {
                byte[] actualBytes;
                DirectoryContentSpecImpl directoryContentSpecImpl;
                block2: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
                        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
                        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
                        Assert.assertTrue((String)(file2 + " doesn't exist"), (boolean)file2.exists());
                        directoryContentSpecImpl = spec;
                        if (!(directoryContentSpecImpl instanceof DirectorySpec)) break block0;
                        DirectoryContentSpecImplKt.assertDirectoryMatches(file2, (DirectorySpecBase)spec, relativePath, fileTextMatcher, filePathFilter);
                        break block1;
                    }
                    if (!(directoryContentSpecImpl instanceof ZipSpec)) break block2;
                    Assert.assertTrue((String)(file2 + " is not a file"), (boolean)file2.isFile());
                    File file3 = FileUtil.createTempDirectory((String)("extracted-" + file2.getName()), null, (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"FileUtil.createTempDirec\u2026file.name}\", null, false)");
                    File dirForExtracted = file3;
                    ZipUtil.extract((File)file2, (File)dirForExtracted, null);
                    DirectoryContentSpecImplKt.assertDirectoryMatches(dirForExtracted, (DirectorySpecBase)spec, relativePath, fileTextMatcher, filePathFilter);
                    FileUtil.delete((File)dirForExtracted);
                    break block1;
                }
                if (!(directoryContentSpecImpl instanceof FileSpec)) break block1;
                Assert.assertTrue((String)(file2 + " is not a file"), (boolean)file2.isFile());
                if (((FileSpec)spec).getContent() == null || Arrays.equals(actualBytes = FileUtil.loadFileBytes((File)file2), ((FileSpec)spec).getContent())) break block1;
                Intrinsics.checkNotNullExpressionValue((Object)actualBytes, (String)"actualBytes");
                String actualString = DirectoryContentSpecImplKt.convertToText(actualBytes);
                String expectedString = DirectoryContentSpecImplKt.convertToText(((FileSpec)spec).getContent());
                String string = place = Intrinsics.areEqual((Object)relativePath, (Object)".") ^ true ? " at " + relativePath : "";
                if (actualString == null || expectedString == null) break block3;
                if (fileTextMatcher.matches(actualString, expectedString)) break block1;
                Assert.assertEquals((String)("File content mismatch" + place + ':'), (Object)expectedString, (Object)actualString);
                break block1;
            }
            Assert.fail((String)("Binary file content mismatch" + place));
        }
    }

    private static final String convertToText(byte[] $this$convertToText) {
        Charset charset;
        CharsetToolkit.GuessedEncoding guessedEncoding = new CharsetToolkit($this$convertToText, Charsets.UTF_8, false).guessFromContent($this$convertToText.length);
        Intrinsics.checkNotNullExpressionValue((Object)guessedEncoding, (String)"CharsetToolkit(this, Cha\u2026e).guessFromContent(size)");
        CharsetToolkit.GuessedEncoding encoding = guessedEncoding;
        switch (DirectoryContentSpecImplKt$WhenMappings.$EnumSwitchMapping$0[encoding.ordinal()]) {
            case 1: {
                charset = Charsets.US_ASCII;
                break;
            }
            case 2: {
                charset = Charsets.UTF_8;
                break;
            }
            default: {
                return null;
            }
        }
        Charset charset2 = charset;
        boolean bl = false;
        return new String($this$convertToText, charset2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final void assertDirectoryMatches(File file, DirectorySpecBase spec, String relativePath, FileTextMatcher fileTextMatcher, Function1<? super String, Boolean> filePathFilter) {
        Assert.assertTrue((String)(file + " is not a directory"), (boolean)file.isDirectory());
        $fun$childNameFilter$1 = new Function1<String, Boolean>(filePathFilter, relativePath){
            final /* synthetic */ Function1 $filePathFilter;
            final /* synthetic */ String $relativePath;

            public final boolean invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return (Boolean)this.$filePathFilter.invoke((Object)(this.$relativePath + '/' + name));
            }
            {
                this.$filePathFilter = function1;
                this.$relativePath = string;
                super(1);
            }
        };
        v0 = file.listFiles();
        Intrinsics.checkNotNull((Object)v0);
        $this$filter$iv /* !! */  = v0;
        $i$f$filter = false;
        var9_9 = $this$filter$iv /* !! */ ;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            it = element$iv$iv;
            $i$a$-filter-DirectoryContentSpecImplKt$assertDirectoryMatches$actualChildrenNames$1 = false;
            v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (v1.isDirectory()) ** GOTO lbl-1000
            v2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.name");
            if ($fun$childNameFilter$1.invoke(v2)) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv /* !! */  = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var14_19 = (File)item$iv$iv;
            var18_27 = destination$iv$iv;
            $i$a$-map-DirectoryContentSpecImplKt$assertDirectoryMatches$actualChildrenNames$2 = false;
            v4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
            var19_28 = v4.getName();
            var18_27.add(var19_28);
        }
        actualChildrenNames = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        children = spec.getChildren();
        $this$filter$iv = children.entrySet();
        $i$f$filter = false;
        $i$f$mapTo = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            $i$a$-filter-DirectoryContentSpecImplKt$assertDirectoryMatches$expectedChildrenNames$1 = false;
            if (!(it.getValue() instanceof FileSpec == false || $fun$childNameFilter$1.invoke((String)it.getKey()) != false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            var18_27 = destination$iv$iv;
            $i$a$-map-DirectoryContentSpecImplKt$assertDirectoryMatches$expectedChildrenNames$2 = false;
            var19_28 = (String)it.getKey();
            var18_27.add(var19_28);
        }
        expectedChildrenNames = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Assert.assertEquals((String)("Directory content mismatch" + ((Intrinsics.areEqual((Object)relativePath, (Object)"") ^ true) != false ? " at " + relativePath : "") + ':'), (Object)CollectionsKt.joinToString$default((Iterable)expectedChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)actualChildrenNames, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        for (String child : actualChildrenNames) {
            v5 = new File(file, child);
            v6 = children.get(child);
            Intrinsics.checkNotNull((Object)v6);
            DirectoryContentSpecImplKt.assertDirectoryContentMatches(v5, v6, relativePath + '/' + child, fileTextMatcher, filePathFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DirectorySpec createSpecByDirectory(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        DirectorySpec spec = new DirectorySpec();
        Path $this$directoryStreamIfExists$iv = dir;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                DirectoryStream children = (DirectoryStream)closeable;
                boolean bl3 = false;
                Iterable $this$forEach$iv = children;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl4 = false;
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    spec.addChild(((Object)path.getFileName()).toString(), DirectoryContentSpecImplKt.createSpecByPath(it));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        return spec;
    }

    private static final DirectoryContentSpecImpl createSpecByPath(Path path) {
        if (PathKt.isFile((Path)path)) {
            return new FileSpec(Files.readAllBytes(path));
        }
        return DirectoryContentSpecImplKt.createSpecByDirectory(path);
    }
}

