/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.inlays;

import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsSinkImpl;
import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.testFramework.utils.inlays.InlayHintsProviderTestCase$InlayData$WhenMappings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\b\b\u0002\u0010\f\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase;", "Lcom/intellij/testFramework/fixtures/BasePlatformTestCase;", "()V", "testProvider", "", "T", "", "fileName", "", "expectedText", "provider", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "settings", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/codeInsight/hints/InlayHintsProvider;Ljava/lang/Object;)V", "InlayData", "InlayType", "intellij.platform.testFramework"})
public abstract class InlayHintsProviderTestCase
extends BasePlatformTestCase {
    public final <T> void testProvider(@NotNull String fileName, @NotNull String expectedText, @NotNull InlayHintsProvider<T> provider, @NotNull T settings) {
        InlayData inlayData;
        Inlay it;
        Collection collection;
        TextRange range;
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        String sourceText = InlayData.Companion.getPattern().matcher(expectedText).replaceAll("");
        this.myFixture.configureByText(fileName, sourceText);
        CodeInsightTestFixture codeInsightTestFixture = this.myFixture;
        Intrinsics.checkNotNullExpressionValue((Object)codeInsightTestFixture, (String)"myFixture");
        PsiFile psiFile = codeInsightTestFixture.getFile();
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file2 = psiFile;
        CodeInsightTestFixture codeInsightTestFixture2 = this.myFixture;
        Intrinsics.checkNotNullExpressionValue((Object)codeInsightTestFixture2, (String)"myFixture");
        Editor editor2 = editor = codeInsightTestFixture2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor");
        InlayHintsSinkImpl sink = new InlayHintsSinkImpl(editor2);
        InlayHintsCollector inlayHintsCollector = provider.getCollectorFor(file2, editor, settings, (InlayHintsSink)sink);
        if (inlayHintsCollector == null) {
            String string = "Collector is expected";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        InlayHintsCollector collector = inlayHintsCollector;
        SettingsKey settingsKey = provider.getKey();
        Language language = file2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.language");
        CollectorWithSettings collectorWithSettings = new CollectorWithSettings(collector, settingsKey, language, sink);
        collectorWithSettings.collectTraversingAndApply(editor, file2, true);
        InlayModel inlayModel = editor.getInlayModel();
        Intrinsics.checkNotNullExpressionValue((Object)inlayModel, (String)"editor.inlayModel");
        InlayModel model = inlayModel;
        TextRange textRange = range = file2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
        List list = model.getInlineElementsInRange(textRange.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"model.getInlineElementsI\u2026tOffset, range.endOffset)");
        List inlineElements = list;
        List list2 = model.getAfterLineEndElementsInRange(range.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"model.getAfterLineEndEle\u2026tOffset, range.endOffset)");
        List afterLineElements = list2;
        List list3 = model.getBlockElementsInRange(range.getStartOffset(), range.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"model.getBlockElementsIn\u2026tOffset, range.endOffset)");
        List blockElements = list3;
        boolean bl = false;
        List inlays = new ArrayList();
        Iterable $this$mapTo$iv = inlineElements;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            Inlay inlay = (Inlay)item$iv;
            collection = inlays;
            boolean bl2 = false;
            void v12 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"it");
            inlayData = new InlayData((Inlay<?>)v12, InlayType.Inline);
            collection.add(inlayData);
        }
        $this$mapTo$iv = afterLineElements;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (Inlay)item$iv;
            collection = inlays;
            boolean bl3 = false;
            Inlay inlay = it;
            Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"it");
            inlayData = new InlayData(inlay, InlayType.Inline);
            collection.add(inlayData);
        }
        $this$mapTo$iv = blockElements;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (Inlay)item$iv;
            collection = inlays;
            boolean bl4 = false;
            Inlay inlay = it;
            Intrinsics.checkNotNullExpressionValue((Object)inlay, (String)"it");
            inlayData = new InlayData(inlay, InlayType.Block);
            collection.add(inlayData);
        }
        Document document = this.myFixture.getDocument(file2);
        List $this$sortBy$iv = inlays;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            boolean bl5 = false;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator<T>(document){
                final /* synthetic */ Document $document$inlined;
                {
                    this.$document$inlined = document;
                }

                public final int compare(T a, T b) {
                    boolean bl = false;
                    InlayData it = (InlayData)a;
                    boolean bl2 = false;
                    Document document = this.$document$inlined;
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
                    Comparable comparable = Integer.valueOf(it.effectiveOffset(document));
                    it = (InlayData)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Document document2 = this.$document$inlined;
                    Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
                    Integer n = it.effectiveOffset(document2);
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            });
        }
        boolean bl6 = false;
        boolean bl7 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl8 = false;
        boolean bl9 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl10 = false;
        int currentOffset = 0;
        for (InlayData inlay : inlays) {
            Document document2 = document;
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
            int nextOffset = inlay.effectiveOffset(document2);
            $this$buildString.append(sourceText.subSequence(currentOffset, nextOffset));
            $this$buildString.append(inlay);
            currentOffset = nextOffset;
        }
        String string = sourceText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceText");
        String string2 = string;
        int n = sourceText.length();
        boolean bl11 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(currentOffset, n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$buildString.append(string4);
        String string5 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        String actualText = string5;
        BasePlatformTestCase.assertEquals((String)expectedText, (String)actualText);
    }

    public static /* synthetic */ void testProvider$default(InlayHintsProviderTestCase inlayHintsProviderTestCase, String string, String string2, InlayHintsProvider inlayHintsProvider, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: testProvider");
        }
        if ((n & 8) != 0) {
            object = inlayHintsProvider.createSettings();
        }
        inlayHintsProviderTestCase.testProvider(string, string2, inlayHintsProvider, object);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u000fH\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayData;", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "type", "Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;", "(Lcom/intellij/openapi/editor/Inlay;Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;)V", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "getType", "()Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;", "component1", "component2", "copy", "effectiveOffset", "", "document", "Lcom/intellij/openapi/editor/Document;", "equals", "", "other", "hashCode", "toString", "", "Companion", "intellij.platform.testFramework"})
    private static final class InlayData {
        @NotNull
        private final Inlay<?> inlay;
        @NotNull
        private final InlayType type;
        @NotNull
        private static final Pattern pattern;
        @NotNull
        public static final Companion Companion;

        public final int effectiveOffset(@NotNull Document document) {
            int n;
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            switch (InlayHintsProviderTestCase$InlayData$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1: {
                    n = this.inlay.getOffset();
                    break;
                }
                case 2: {
                    int offset = this.inlay.getOffset();
                    int lineNumber = document.getLineNumber(offset);
                    n = document.getLineStartOffset(lineNumber);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        @NotNull
        public String toString() {
            EditorCustomElementRenderer renderer = this.inlay.getRenderer();
            if (!(renderer instanceof PresentationRenderer) && !(renderer instanceof LinearOrderInlayRenderer)) {
                String string = "renderer not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append("<# ");
            if (this.type == InlayType.Block) {
                $this$buildString.append("block ");
            }
            $this$buildString.append(renderer.toString());
            $this$buildString.append(" #>");
            if (this.type == InlayType.Block) {
                $this$buildString.append('\n');
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        @NotNull
        public final Inlay<?> getInlay() {
            return this.inlay;
        }

        @NotNull
        public final InlayType getType() {
            return this.type;
        }

        public InlayData(@NotNull Inlay<?> inlay, @NotNull InlayType type) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.inlay = inlay;
            this.type = type;
        }

        static {
            Companion = new Companion(null);
            Pattern pattern = Pattern.compile("<# block ([^#]*)#>(\r\n|\r|\n)|<#([^#]*)#>");
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"<# bloc\u2026\\r\\n|\\r|\\n)|<#([^#]*)#>\")");
            InlayData.pattern = pattern;
        }

        @NotNull
        public final Inlay<?> component1() {
            return this.inlay;
        }

        @NotNull
        public final InlayType component2() {
            return this.type;
        }

        @NotNull
        public final InlayData copy(@NotNull Inlay<?> inlay, @NotNull InlayType type) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new InlayData(inlay, type);
        }

        public static /* synthetic */ InlayData copy$default(InlayData inlayData, Inlay inlay, InlayType inlayType, int n, Object object) {
            if ((n & 1) != 0) {
                inlay = inlayData.inlay;
            }
            if ((n & 2) != 0) {
                inlayType = inlayData.type;
            }
            return inlayData.copy(inlay, inlayType);
        }

        public int hashCode() {
            Inlay<?> inlay = this.inlay;
            InlayType inlayType = this.type;
            return (inlay != null ? inlay.hashCode() : 0) * 31 + (inlayType != null ? ((Object)((Object)inlayType)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof InlayData)) break block3;
                    InlayData inlayData = (InlayData)object;
                    if (!Intrinsics.areEqual(this.inlay, inlayData.inlay) || !Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)inlayData.type))) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayData$Companion;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "intellij.platform.testFramework"})
        public static final class Companion {
            @NotNull
            public final Pattern getPattern() {
                return pattern;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/testFramework/utils/inlays/InlayHintsProviderTestCase$InlayType;", "", "(Ljava/lang/String;I)V", "Inline", "Block", "intellij.platform.testFramework"})
    private static final class InlayType
    extends Enum<InlayType> {
        public static final /* enum */ InlayType Inline;
        public static final /* enum */ InlayType Block;
        private static final /* synthetic */ InlayType[] $VALUES;

        static {
            InlayType[] inlayTypeArray = new InlayType[2];
            InlayType[] inlayTypeArray2 = inlayTypeArray;
            inlayTypeArray[0] = Inline = new InlayType();
            inlayTypeArray[1] = Block = new InlayType();
            $VALUES = inlayTypeArray;
        }

        public static InlayType[] values() {
            return (InlayType[])$VALUES.clone();
        }

        public static InlayType valueOf(String string) {
            return Enum.valueOf(InlayType.class, string);
        }
    }
}

