/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.TestCaseLoader;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.TestModeFlagListener;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.SkipWithExecutionPolicy;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.LightTempDirTestFixtureImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaTestExecutionPolicy
implements TestModeFlagListener {
    private static IdeaTestExecutionPolicy ourCurrent;

    protected IdeaTestExecutionPolicy() {
        TestModeFlags.addListener((TestModeFlagListener)this);
    }

    public void setUp(Project project2, Disposable testRootDisposable, String testDataPath) {
    }

    public TempDirTestFixture createTempDirTestFixture() {
        return new LightTempDirTestFixtureImpl(true);
    }

    public boolean runInDispatchThread() {
        return true;
    }

    public void testFileConfigured(@NotNull PsiFile file2) {
        if (file2 == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(0);
        }
    }

    public void testDirectoryConfigured(@NotNull PsiDirectory directory) {
        if (directory == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(1);
        }
    }

    public void beforeCheckResult(@NotNull PsiFile file2) {
        if (file2 == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(2);
        }
    }

    public String getHomePath() {
        return null;
    }

    @Nullable
    public String getPerTestTempDirName() {
        return null;
    }

    public void waitForHighlighting(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(4);
        }
    }

    public void inspectionToolEnabled(@NotNull Project project2, @NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull Disposable disposable) {
        if (project2 == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(5);
        }
        if (toolWrapper == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(7);
        }
    }

    public void testModeFlagChanged(@NotNull Key<?> key, @Nullable Object value) {
        if (key == null) {
            IdeaTestExecutionPolicy.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    public static IdeaTestExecutionPolicy current() {
        if (ourCurrent != null) {
            return ourCurrent;
        }
        String policyClassName = System.getProperty("idea.test.execution.policy");
        if (policyClassName == null) {
            return null;
        }
        try {
            Class<?> policyClass = Class.forName(policyClassName);
            ourCurrent = (IdeaTestExecutionPolicy)policyClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return ourCurrent;
    }

    public static String getHomePathWithPolicy() {
        String policyHomePath;
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && (policyHomePath = policy.getHomePath()) != null) {
            return policyHomePath;
        }
        return PathManager.getHomePath();
    }

    public boolean canRun(Class<? extends UsefulTestCase> testCaseClass) {
        IdeaTestExecutionPolicy current = IdeaTestExecutionPolicy.current();
        if (current == null) {
            return true;
        }
        SkipWithExecutionPolicy annotation = TestCaseLoader.getAnnotationInHierarchy(testCaseClass, SkipWithExecutionPolicy.class);
        return annotation == null || !annotation.value().equals(current.getName());
    }

    protected abstract String getName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/fixtures/IdeaTestExecutionPolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "testFileConfigured";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "testDirectoryConfigured";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCheckResult";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForHighlighting";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "inspectionToolEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "testModeFlagChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

