/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HierarchyViewTestFixture {
    private static final String NODE_ELEMENT_NAME = "node";
    private static final String ANY_NODES_ELEMENT_NAME = "any";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String BASE_ATTR_NAME = "base";

    public static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull String expectedStructure) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(0);
        }
        if (expectedStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(1);
        }
        HierarchyViewTestFixture.doHierarchyTest(treeStructure, expectedStructure, null);
    }

    public static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull File expectedFile) throws IOException {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(2);
        }
        if (expectedFile == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(3);
        }
        HierarchyViewTestFixture.doHierarchyTest(treeStructure, FileUtil.loadFile((File)expectedFile), expectedFile);
    }

    private static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull String expectedStructure, @Nullable File expectedFile) {
        Element element;
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(4);
        }
        if (expectedStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(5);
        }
        try {
            element = JDOMUtil.load((CharSequence)expectedStructure);
        }
        catch (Throwable e) {
            String actual = HierarchyViewTestFixture.dump(treeStructure, null, 0);
            if (!expectedStructure.equals(actual)) {
                throw new FileComparisonFailure("XML structure comparison for your convenience, actual failure details BELOW", expectedStructure, actual, expectedFile == null ? null : expectedFile.getAbsolutePath());
            }
            throw new RuntimeException(e);
        }
        HierarchyViewTestFixture.checkHierarchyTreeStructure(treeStructure, element);
    }

    @NotNull
    public static String dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor, int level) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(6);
        }
        StringBuilder s = new StringBuilder();
        HierarchyViewTestFixture.dump(treeStructure, descriptor, level, s);
        String string = s.toString();
        if (string == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static void dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor, int level, @NotNull StringBuilder b) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(8);
        }
        if (b == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(9);
        }
        if (level > 10) {
            b.append("  ".repeat(level));
            b.append("<Probably infinite part skipped>\n");
            return;
        }
        if (descriptor == null) {
            descriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        }
        b.append("  ".repeat(level));
        descriptor.update();
        b.append("<node text=\"").append(descriptor.getHighlightedText().getText()).append("\"").append(treeStructure.getBaseDescriptor() == descriptor ? " base=\"true\"" : "");
        Object[] children = treeStructure.getChildElements((Object)descriptor);
        if (children.length > 0) {
            b.append(">\n");
            for (Object o : children) {
                HierarchyNodeDescriptor d = (HierarchyNodeDescriptor)o;
                HierarchyViewTestFixture.dump(treeStructure, d, level + 1, b);
            }
            b.append("  ".repeat(level));
            b.append("</node>\n");
        } else {
            b.append("/>\n");
        }
    }

    private static void checkHierarchyTreeStructure(@NotNull HierarchyTreeStructure treeStructure, @Nullable Element rootElement) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(10);
        }
        HierarchyNodeDescriptor rootNodeDescriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        rootNodeDescriptor.update();
        if (rootElement == null || !NODE_ELEMENT_NAME.equals(rootElement.getName())) {
            throw new IllegalArgumentException("Incorrect root element in verification resource");
        }
        HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, rootNodeDescriptor, rootElement);
    }

    private static void checkNodeDescriptorRecursively(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor, @NotNull Element expectedElement) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(11);
        }
        if (descriptor == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(12);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(13);
        }
        HierarchyViewTestFixture.checkBaseNode(treeStructure, descriptor, expectedElement);
        HierarchyViewTestFixture.checkContent(descriptor, expectedElement);
        HierarchyViewTestFixture.checkChildren(treeStructure, descriptor, expectedElement);
    }

    private static void checkBaseNode(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor, @NotNull Element expectedElement) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(14);
        }
        if (descriptor == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(15);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(16);
        }
        String baseAttrValue = expectedElement.getAttributeValue(BASE_ATTR_NAME);
        HierarchyNodeDescriptor baseDescriptor = treeStructure.getBaseDescriptor();
        boolean mustBeBase = "true".equalsIgnoreCase(baseAttrValue);
        TestCase.assertEquals((String)"Incorrect base node", (boolean)mustBeBase, (baseDescriptor == descriptor ? 1 : 0) != 0);
    }

    private static void checkContent(@NotNull HierarchyNodeDescriptor descriptor, @NotNull Element expectedElement) {
        if (descriptor == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(17);
        }
        if (expectedElement == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(18);
        }
        TestCase.assertEquals((String)expectedElement.getAttributeValue(TEXT_ATTR_NAME), (String)descriptor.getHighlightedText().getText());
    }

    private static void checkChildren(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor, @NotNull Element element) {
        if (treeStructure == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(19);
        }
        if (descriptor == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(20);
        }
        if (element == null) {
            HierarchyViewTestFixture.$$$reportNull$$$0(21);
        }
        if (element.getChild(ANY_NODES_ELEMENT_NAME) != null) {
            return;
        }
        Object[] children = treeStructure.getChildElements((Object)descriptor);
        ArrayList<Element> expectedChildren = new ArrayList<Element>(element.getChildren(NODE_ELEMENT_NAME));
        StringBuilder messageBuilder = new StringBuilder("Actual children of [" + descriptor.getHighlightedText().getText() + "]:\n");
        for (Object child2 : children) {
            HierarchyNodeDescriptor nodeDescriptor = (HierarchyNodeDescriptor)child2;
            nodeDescriptor.update();
            messageBuilder.append("    [").append(nodeDescriptor.getHighlightedText().getText()).append("]\n");
        }
        TestCase.assertEquals((String)messageBuilder.toString(), (int)expectedChildren.size(), (int)children.length);
        Arrays.sort(children, Comparator.comparing(child -> ((HierarchyNodeDescriptor)child).getHighlightedText().getText()));
        expectedChildren.sort(Comparator.comparing(child -> child.getAttributeValue(TEXT_ATTR_NAME)));
        Iterator iterator = expectedChildren.iterator();
        for (Object child3 : children) {
            HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, (HierarchyNodeDescriptor)child3, (Element)iterator.next());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/codeInsight/hierarchy/HierarchyViewTestFixture";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/codeInsight/hierarchy/HierarchyViewTestFixture";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doHierarchyTest";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkHierarchyTreeStructure";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkNodeDescriptorRecursively";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkBaseNode";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkContent";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

