/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.ide.GeneratedSourceFileChangeTrackerImpl;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.impl.StructureViewFactoryImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LeakHunter;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.ui.UiInterceptors;
import com.intellij.util.ErrorKt;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.workspaceModel.ide.impl.legacyBridge.LegacyBridgeTestFrameworkUtils;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import junit.framework.AssertionFailedError;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.awt.AWTAutoShutdown;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0006\u0010\b\u001a\u00020\u0003\u001a\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a$\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007\u001a,\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\n\b\u0000\u0010\u0013\u0018\u0001*\u00020\u0014\"\n\b\u0001\u0010\u0012\u0018\u0001*\u00020\u0014*\u00020\u0015H\u0086\b\u00a2\u0006\u0002\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"testCounter", "", "checkJavaSwingTimersAreDisposed", "", "disposeApplicationAndCheckForLeaks", "publishHeapDump", "", "fileNamePrefix", "replaceIdeEventQueueSafely", "tearDownProjectAndApp", "project", "Lcom/intellij/openapi/project/Project;", "waitForProjectLeakingThreads", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "serviceIfCreated", "TI", "T", "", "Lcom/intellij/openapi/application/Application;", "(Lcom/intellij/openapi/application/Application;)Ljava/lang/Object;", "intellij.platform.testFramework"})
public final class TestApplicationManagerKt {
    private static int testCounter;

    public static final void replaceIdeEventQueueSafely() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Intrinsics.checkNotNullExpressionValue((Object)toolkit, (String)"Toolkit.getDefaultToolkit()");
        if (toolkit.getSystemEventQueue() instanceof IdeEventQueue) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            throw (Throwable)new IllegalStateException("must not call under EDT");
        }
        AWTAutoShutdown.getInstance().notifyThreadBusy(Thread.currentThread());
        UIUtil.pump();
        EventQueue.invokeAndWait(replaceIdeEventQueueSafely.1.INSTANCE);
        EventQueue.invokeAndWait(EmptyRunnable.getInstance());
        EventQueue.invokeAndWait(EmptyRunnable.getInstance());
    }

    public static final /* synthetic */ <T, TI> TI serviceIfCreated(Application $this$serviceIfCreated) {
        int $i$f$serviceIfCreated = 0;
        Intrinsics.checkNotNullParameter((Object)$this$serviceIfCreated, (String)"$this$serviceIfCreated");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = $this$serviceIfCreated.getServiceIfCreated(Object.class);
        Intrinsics.reifiedOperationMarker((int)1, (String)"TI?");
        return (TI)object;
    }

    @ApiStatus.Internal
    public static final void tearDownProjectAndApp(@NotNull Project project2) {
        boolean $i$f$serviceIfCreated;
        Application $this$serviceIfCreated$iv;
        boolean $i$f$catchAndStoreExceptions;
        List $this$catchAndStoreExceptions$iv;
        Application app;
        List l;
        block114: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            if (project2.isDisposed()) {
                return;
            }
            boolean isLightProject = ProjectManagerImpl.isLight((Project)project2);
            boolean bl = false;
            l = new ArrayList();
            app = ApplicationManager.getApplication();
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                Unit unit;
                boolean bl2 = false;
                Application application = app;
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                $this$serviceIfCreated$iv = application;
                $i$f$serviceIfCreated = false;
                FileTypeManagerImpl fileTypeManagerImpl = (FileTypeManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(FileTypeManager.class);
                if (fileTypeManagerImpl != null) {
                    fileTypeManagerImpl.drainReDetectQueue();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl3 = false;
                if (isLightProject) {
                    Unit unit;
                    $this$serviceIfCreated$iv = project2;
                    $i$f$serviceIfCreated = false;
                    AutoPopupController autoPopupController = (AutoPopupController)$this$serviceIfCreated$iv.getServiceIfCreated(AutoPopupController.class);
                    if (autoPopupController != null) {
                        autoPopupController.cancelAllRequests();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl4 = false;
                CodeStyle.dropTemporarySettings((Project)project2);
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl5 = false;
                TestApplicationManagerKt.checkJavaSwingTimersAreDisposed();
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl6 = false;
                UsefulTestCase.doPostponedFormatting(project2);
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl7 = false;
                LookupManager.hideActiveLookup((Project)project2);
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl8 = false;
                if (isLightProject) {
                    Unit unit;
                    $this$serviceIfCreated$iv = project2;
                    $i$f$serviceIfCreated = false;
                    StartupManagerImpl startupManagerImpl = (StartupManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(StartupManager.class);
                    if (startupManagerImpl != null) {
                        startupManagerImpl.prepareForNextTest();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl9 = false;
                if (isLightProject) {
                    LightPlatformTestCase.tearDownSourceRoot(project2);
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl10 = false;
                WriteCommandAction.runWriteCommandAction((Project)project2, (Runnable)new Runnable(project2, app){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ Application $app$inlined;
                    {
                        this.$project$inlined = project2;
                        this.$app$inlined = application;
                    }

                    public final void run() {
                        block0: {
                            Application application = this.$app$inlined;
                            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
                            Application $this$serviceIfCreated$iv = application;
                            boolean $i$f$serviceIfCreated = false;
                            FileDocumentManagerImpl fileDocumentManagerImpl = (FileDocumentManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(FileDocumentManager.class);
                            if (fileDocumentManagerImpl == null) break block0;
                            fileDocumentManagerImpl.dropAllUnsavedDocuments();
                        }
                    }
                });
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                Unit unit;
                boolean bl11 = false;
                $this$serviceIfCreated$iv = project2;
                $i$f$serviceIfCreated = false;
                EditorHistoryManager editorHistoryManager = (EditorHistoryManager)$this$serviceIfCreated$iv.getServiceIfCreated(EditorHistoryManager.class);
                if (editorHistoryManager != null) {
                    editorHistoryManager.removeAllFiles();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
            $this$catchAndStoreExceptions$iv = l;
            $i$f$catchAndStoreExceptions = false;
            try {
                boolean bl12 = false;
                $this$serviceIfCreated$iv = project2;
                $i$f$serviceIfCreated = false;
                PsiManager psiManager = (PsiManager)$this$serviceIfCreated$iv.getServiceIfCreated(PsiManager.class);
                if (psiManager == null) break block114;
                if (!psiManager.isDisposed()) break block114;
                throw (Throwable)new IllegalStateException("PsiManager must be not disposed");
            }
            catch (CompoundRuntimeException e$iv) {
                List list = e$iv.getExceptions();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                $this$catchAndStoreExceptions$iv.addAll(list);
            }
            catch (Throwable e$iv) {
                $this$catchAndStoreExceptions$iv.add(e$iv);
            }
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            LightPlatformTestCase.clearEncodingManagerDocumentQueue();
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            LightPlatformTestCase.checkAssertions();
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            LightPlatformTestCase.clearUncommittedDocuments(project2);
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            Application application = app;
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            $this$serviceIfCreated$iv = application;
            $i$f$serviceIfCreated = false;
            HintManagerImpl hintManagerImpl = (HintManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(HintManager.class);
            if (hintManagerImpl != null) {
                hintManagerImpl.cleanup();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            UndoManager undoManager = UndoManager.getGlobalInstance();
            if (undoManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
            }
            ((UndoManagerImpl)undoManager).dropHistoryInTests();
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            UndoManager undoManager = UndoManager.getInstance((Project)project2);
            if (undoManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
            }
            ((UndoManagerImpl)undoManager).dropHistoryInTests();
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            Application application = app;
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            $this$serviceIfCreated$iv = application;
            $i$f$serviceIfCreated = false;
            DocumentReferenceManagerImpl documentReferenceManagerImpl = (DocumentReferenceManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(DocumentReferenceManager.class);
            if (documentReferenceManagerImpl != null) {
                documentReferenceManagerImpl.cleanupForNextTest();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            $this$serviceIfCreated$iv = project2;
            $i$f$serviceIfCreated = false;
            TemplateDataLanguageMappings templateDataLanguageMappings = (TemplateDataLanguageMappings)$this$serviceIfCreated$iv.getServiceIfCreated(TemplateDataLanguageMappings.class);
            if (templateDataLanguageMappings != null) {
                templateDataLanguageMappings.cleanupForNextTest();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            $this$serviceIfCreated$iv = project2;
            $i$f$serviceIfCreated = false;
            PsiManagerImpl psiManagerImpl = (PsiManagerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(PsiManager.class);
            if (psiManagerImpl != null) {
                psiManagerImpl.cleanupForNextTest();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            $this$serviceIfCreated$iv = project2;
            $i$f$serviceIfCreated = false;
            StructureViewFactoryImpl structureViewFactoryImpl = (StructureViewFactoryImpl)$this$serviceIfCreated$iv.getServiceIfCreated(StructureViewFactory.class);
            if (structureViewFactoryImpl != null) {
                structureViewFactoryImpl.cleanupForNextTest();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            TestApplicationManagerKt.waitForProjectLeakingThreads$default(project2, 0L, null, 6, null);
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            LegacyBridgeTestFrameworkUtils.INSTANCE.dropCachesOnTeardown(project2);
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            Unit unit;
            boolean bl = false;
            TestApplicationManager testApplicationManager = TestApplicationManager.Companion.getInstanceIfCreated();
            if (testApplicationManager != null) {
                testApplicationManager.setDataProvider(null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            ProjectManagerEx.getInstanceEx().forceCloseProject(project2);
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            UiInterceptors.clear();
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            CompletionProgressIndicator.cleanupForNextTest();
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        $this$catchAndStoreExceptions$iv = l;
        $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl = false;
            int n = testCounter;
            testCounter = n + 1;
            if (n % 100 == 0) {
                GCUtil.clearBeanInfoCache();
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        ErrorKt.throwIfNotEmpty((List)l);
    }

    public static final void disposeApplicationAndCheckForLeaks() {
        boolean bl = false;
        List l = new ArrayList();
        boolean $i$f$runInEdtAndWait = false;
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable)new ThrowableRunnable<Throwable>(l){
            final /* synthetic */ List $l$inlined;
            {
                this.$l$inlined = list;
            }

            public final void run() {
                boolean bl = false;
                List $this$catchAndStoreExceptions$iv = this.$l$inlined;
                boolean $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl2 = false;
                    PlatformTestUtil.cleanupAllProjects();
                }
                catch (CompoundRuntimeException e$iv) {
                    List list = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll(list);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl3 = false;
                    UIUtil.dispatchAllInvocationEvents();
                }
                catch (CompoundRuntimeException e$iv) {
                    List list = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll(list);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl4 = false;
                    ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
                    if (scheduledExecutorService == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.concurrency.AppScheduledExecutorService");
                    }
                    String string = ((AppScheduledExecutorService)scheduledExecutorService).statistics();
                    boolean bl5 = false;
                    System.out.println((Object)string);
                    ExecutorService executorService = ProcessIOExecutorService.INSTANCE;
                    if (executorService == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.process.ProcessIOExecutorService");
                    }
                    string = "ProcessIOExecutorService threads created: " + ((ProcessIOExecutorService)executorService).getThreadCounter();
                    bl5 = false;
                    System.out.println((Object)string);
                }
                catch (CompoundRuntimeException e$iv) {
                    List list = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll(list);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    ApplicationImpl app;
                    ApplicationImpl applicationImpl;
                    boolean bl6 = false;
                    Application application = ApplicationManager.getApplication();
                    if (!(application instanceof ApplicationImpl)) {
                        application = null;
                    }
                    if ((applicationImpl = (app = (ApplicationImpl)application)) != null && (applicationImpl = applicationImpl.getMessageBus()) != null && (applicationImpl = (AppLifecycleListener)applicationImpl.syncPublisher(AppLifecycleListener.TOPIC)) != null) {
                        applicationImpl.appWillBeClosed(false);
                    }
                }
                catch (CompoundRuntimeException e$iv) {
                    List list = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll(list);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl7 = false;
                    UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS);
                }
                catch (CompoundRuntimeException e$iv) {
                    List list = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll(list);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl8 = false;
                    try {
                        LeakHunter.checkNonDefaultProjectLeak();
                    }
                    catch (AssertionError e) {
                        TestApplicationManagerKt.publishHeapDump("leakedProjects");
                        throw (Throwable)((Object)e);
                    }
                    catch (Exception e) {
                        TestApplicationManagerKt.publishHeapDump("leakedProjects");
                        throw (Throwable)e;
                    }
                }
                catch (CompoundRuntimeException e$iv) {
                    List list = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll(list);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl9 = false;
                    TestApplicationManager testApplicationManager = TestApplicationManager.Companion.getInstanceIfCreated();
                    if (testApplicationManager != null) {
                        testApplicationManager.dispose();
                    }
                }
                catch (CompoundRuntimeException e$iv) {
                    List list = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll(list);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
                $this$catchAndStoreExceptions$iv = this.$l$inlined;
                $i$f$catchAndStoreExceptions = false;
                try {
                    boolean bl10 = false;
                    UIUtil.dispatchAllInvocationEvents();
                }
                catch (CompoundRuntimeException e$iv) {
                    List list = e$iv.getExceptions();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
                    $this$catchAndStoreExceptions$iv.addAll(list);
                }
                catch (Throwable e$iv) {
                    $this$catchAndStoreExceptions$iv.add(e$iv);
                }
            }
        });
        List $this$catchAndStoreExceptions$iv = l;
        boolean $i$f$catchAndStoreExceptions = false;
        try {
            boolean bl2 = false;
            try {
                Disposer.assertIsEmpty((boolean)true);
            }
            catch (AssertionError e) {
                TestApplicationManagerKt.publishHeapDump("disposerNonEmpty");
                throw (Throwable)((Object)e);
            }
            catch (Exception e) {
                TestApplicationManagerKt.publishHeapDump("disposerNonEmpty");
                throw (Throwable)e;
            }
        }
        catch (CompoundRuntimeException e$iv) {
            List list = e$iv.getExceptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"e.exceptions");
            $this$catchAndStoreExceptions$iv.addAll(list);
        }
        catch (Throwable e$iv) {
            $this$catchAndStoreExceptions$iv.add(e$iv);
        }
        ErrorKt.throwIfNotEmpty((List)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void checkJavaSwingTimersAreDisposed() {
        Method getTimer;
        Method sharedInstance;
        Class<?> timerQueueClass = Class.forName("javax.swing.TimerQueue");
        Method method = sharedInstance = timerQueueClass.getMethod("sharedInstance", new Class[0]);
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"sharedInstance");
        method.setAccessible(true);
        Object timerQueue = sharedInstance.invoke(null, new Object[0]);
        DelayQueue delayQueue = (DelayQueue)ReflectionUtil.getField(timerQueueClass, (Object)timerQueue, DelayQueue.class, (String)"queue");
        Object timer = delayQueue.peek();
        if (timer == null) {
            return;
        }
        long delay = timer.getDelay(TimeUnit.MILLISECONDS);
        String text = "(delayed for " + delay + "ms)";
        Method method2 = getTimer = ReflectionUtil.getDeclaredMethod(timer.getClass(), (String)"getTimer", (Class[])new Class[0]);
        Intrinsics.checkNotNull((Object)method2);
        Object object = method2.invoke(timer, new Object[0]);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.Timer");
        }
        Timer swingTimer = (Timer)object;
        StringBuilder stringBuilder = new StringBuilder().append("Timer (listeners: ");
        ActionListener[] actionListenerArray = swingTimer.getActionListeners();
        Intrinsics.checkNotNullExpressionValue((Object)actionListenerArray, (String)"swingTimer.actionListeners");
        text = stringBuilder.append(CollectionsKt.listOf((Object[])Arrays.copyOf(actionListenerArray, actionListenerArray.length))).append(") ").append(text).toString();
        try {
            throw (Throwable)new AssertionFailedError("Not disposed javax.swing.Timer: " + text + "; queue:" + timerQueue);
        }
        catch (Throwable throwable) {
            swingTimer.stop();
            throw throwable;
        }
    }

    @ApiStatus.Internal
    @JvmOverloads
    public static final void waitForProjectLeakingThreads(@NotNull Project project2, long timeout, @NotNull TimeUnit timeUnit) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
            if (project2 instanceof ComponentManagerImpl) {
                ((ComponentManagerImpl)project2).stopServicePreloading();
            }
            Project $this$serviceIfCreated$iv = project2;
            boolean $i$f$serviceIfCreated = false;
            GeneratedSourceFileChangeTrackerImpl generatedSourceFileChangeTrackerImpl = (GeneratedSourceFileChangeTrackerImpl)$this$serviceIfCreated$iv.getServiceIfCreated(GeneratedSourceFileChangeTracker.class);
            if (generatedSourceFileChangeTrackerImpl == null) break block1;
            generatedSourceFileChangeTrackerImpl.cancelAllAndWait(timeout, timeUnit);
        }
    }

    public static /* synthetic */ void waitForProjectLeakingThreads$default(Project project2, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 2) != 0) {
            l = 10L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        TestApplicationManagerKt.waitForProjectLeakingThreads(project2, l, timeUnit);
    }

    @ApiStatus.Internal
    @JvmOverloads
    public static final void waitForProjectLeakingThreads(@NotNull Project project2, long timeout) {
        TestApplicationManagerKt.waitForProjectLeakingThreads$default(project2, timeout, null, 4, null);
    }

    @ApiStatus.Internal
    @JvmOverloads
    public static final void waitForProjectLeakingThreads(@NotNull Project project2) {
        TestApplicationManagerKt.waitForProjectLeakingThreads$default(project2, 0L, null, 6, null);
    }

    @NotNull
    public static final String publishHeapDump(@NotNull String fileNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)fileNamePrefix, (String)"fileNamePrefix");
        String fileName = fileNamePrefix + ".hprof.zip";
        Path dumpFile = Paths.get(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir")), fileName);
        try {
            Files.deleteIfExists(dumpFile);
            MemoryDumpHelper.captureMemoryDumpZipped((Path)dumpFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dumpPath = ((Object)dumpFile.toAbsolutePath()).toString();
        String string = "##teamcity[publishArtifacts '" + dumpPath + "']";
        boolean bl = false;
        System.out.println((Object)string);
        return dumpPath;
    }
}

