/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowablePairConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CompoundRuntimeException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunAll
implements Runnable {
    private final List<? extends ThrowableRunnable<?>> myActions;

    @SafeVarargs
    public static void runAll(ThrowableRunnable<Throwable> ... actions) {
        if (actions == null) {
            RunAll.$$$reportNull$$$0(0);
        }
        new RunAll(actions).run();
    }

    public static <T> void runAll(@NotNull Collection<? extends T> input, @NotNull ThrowableConsumer<? super T, Throwable> action) {
        if (input == null) {
            RunAll.$$$reportNull$$$0(1);
        }
        if (action == null) {
            RunAll.$$$reportNull$$$0(2);
        }
        new RunAll(ContainerUtil.map(input, it -> () -> action.consume(it))).run();
    }

    public static <K, V> void runAll(@NotNull Map<? extends K, ? extends V> input, @NotNull ThrowablePairConsumer<? super K, ? super V, Throwable> action) {
        if (input == null) {
            RunAll.$$$reportNull$$$0(3);
        }
        if (action == null) {
            RunAll.$$$reportNull$$$0(4);
        }
        RunAll.runAll(input.entrySet(), e -> action.consume(e.getKey(), e.getValue()));
    }

    @SafeVarargs
    public RunAll(ThrowableRunnable<Throwable> ... actions) {
        if (actions == null) {
            RunAll.$$$reportNull$$$0(5);
        }
        this(Arrays.asList(actions));
    }

    public RunAll(@NotNull List<? extends ThrowableRunnable<?>> actions) {
        if (actions == null) {
            RunAll.$$$reportNull$$$0(6);
        }
        this.myActions = actions;
    }

    @Override
    public void run() {
        this.run(null);
    }

    public void run(@Nullable List<Throwable> earlierExceptions) {
        SmartList exceptions = earlierExceptions != null ? new SmartList(earlierExceptions) : new SmartList();
        for (ThrowableRunnable<?> action : this.myActions) {
            try {
                action.run();
            }
            catch (CompoundRuntimeException e) {
                exceptions.addAll(e.getExceptions());
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() == 1) {
            ExceptionUtil.rethrow((Throwable)((Throwable)exceptions.get(0)));
        } else if (exceptions.size() > 0) {
            throw new CompoundRuntimeException((List)exceptions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/RunAll";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

