/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.Pair;
import com.intellij.testFramework.PerformanceTestInfo;
import com.intellij.util.ThrowableRunnable;
import com.sun.management.OperatingSystemMXBean;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class CpuUsageData {
    private static final ThreadMXBean ourThreadMXBean = ManagementFactory.getThreadMXBean();
    private static final List<GarbageCollectorMXBean> ourGcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private static final CompilationMXBean ourCompilationMXBean = ManagementFactory.getCompilationMXBean();
    private static final OperatingSystemMXBean ourOSBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    public final long durationMs;
    private final FreeMemorySnapshot myMemStart;
    private final FreeMemorySnapshot myMemEnd;
    private final long myCompilationTimeMs;
    private final long myProcessTimeMs;
    private final List<Pair<Long, String>> myGcTimes;
    private final List<Pair<Long, String>> myThreadTimes;

    /*
     * WARNING - void declaration
     */
    private CpuUsageData(long durationMs, @NotNull Object2LongMap<GarbageCollectorMXBean> gcTimes, @NotNull Long2ObjectMap<Pair<ThreadInfo, Long>> threadTimes, long compilationTimeMs, long processTimeMs, @NotNull FreeMemorySnapshot freeMemorySnapshot, @NotNull FreeMemorySnapshot freeMemorySnapshot2) {
        void memEnd;
        void memStart;
        if (gcTimes == null) {
            CpuUsageData.$$$reportNull$$$0(0);
        }
        if (threadTimes == null) {
            CpuUsageData.$$$reportNull$$$0(1);
        }
        if (freeMemorySnapshot == null) {
            CpuUsageData.$$$reportNull$$$0(2);
        }
        if (freeMemorySnapshot2 == null) {
            CpuUsageData.$$$reportNull$$$0(3);
        }
        this.myGcTimes = new ArrayList<Pair<Long, String>>();
        this.myThreadTimes = new ArrayList<Pair<Long, String>>();
        this.durationMs = durationMs;
        this.myMemStart = memStart;
        this.myMemEnd = memEnd;
        this.myCompilationTimeMs = compilationTimeMs;
        this.myProcessTimeMs = processTimeMs;
        gcTimes.forEach((bean, value) -> this.myGcTimes.add((Pair<Long, String>)Pair.create((Object)value, (Object)bean.getName())));
        threadTimes.forEach((id, pair) -> {
            ThreadInfo info = (ThreadInfo)pair.first;
            Long nanos = (Long)pair.second;
            this.myThreadTimes.add((Pair<Long, String>)Pair.create((Object)TimeUnit.NANOSECONDS.toMillis(nanos), (Object)info.getThreadName()));
        });
        assert (durationMs >= 0L) : durationMs;
        assert (compilationTimeMs >= 0L) : compilationTimeMs;
        assert (processTimeMs >= 0L) : processTimeMs;
    }

    public String getGcStats() {
        return CpuUsageData.printLongestNames(this.myGcTimes) + "; free " + this.myMemStart + " -> " + this.myMemEnd + " MB";
    }

    @NotNull
    String getProcessCpuStats() {
        long gcTotal = this.myGcTimes.stream().mapToLong(p -> (Long)p.first).sum();
        String string = this.myCompilationTimeMs + "ms (" + this.myCompilationTimeMs * 100L / (this.myProcessTimeMs == 0L ? 1000000L : this.myProcessTimeMs) + "%) JITc" + (String)(gcTotal > 0L ? " and " + gcTotal + "ms (" + gcTotal * 100L / (this.myProcessTimeMs == 0L ? 1000000L : this.myProcessTimeMs) + "%) GC" : "") + " of " + this.myProcessTimeMs + "ms total";
        if (string == null) {
            CpuUsageData.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getThreadStats() {
        return CpuUsageData.printLongestNames(this.myThreadTimes);
    }

    public long getMemDelta() {
        long usedBefore = this.myMemStart.total - this.myMemStart.free;
        long usedAfter = this.myMemEnd.total - this.myMemEnd.free;
        return usedAfter - usedBefore;
    }

    @NotNull
    public String getSummary(@NotNull String indent) {
        if (indent == null) {
            CpuUsageData.$$$reportNull$$$0(5);
        }
        String string = indent + "GC: " + this.getGcStats() + "\n" + indent + "Threads: " + this.getThreadStats() + "\n" + indent + "Process: " + this.getProcessCpuStats();
        if (string == null) {
            CpuUsageData.$$$reportNull$$$0(6);
        }
        return string;
    }

    boolean hasAnyActivityBesides(@NotNull Thread thread) {
        if (thread == null) {
            CpuUsageData.$$$reportNull$$$0(7);
        }
        return this.myCompilationTimeMs > 0L || this.myThreadTimes.stream().anyMatch(pair -> (Long)pair.first > 0L && !((String)pair.second).equals(thread.getName())) || this.myGcTimes.stream().anyMatch(pair -> (Long)pair.first > 0L);
    }

    @NotNull
    PerformanceTestInfo.IterationResult getIterationResult(int expectedOnMyMachine) {
        if (this.durationMs < (long)expectedOnMyMachine) {
            PerformanceTestInfo.IterationResult iterationResult = PerformanceTestInfo.IterationResult.ACCEPTABLE;
            if (iterationResult == null) {
                CpuUsageData.$$$reportNull$$$0(8);
            }
            return iterationResult;
        }
        if ((double)this.durationMs < (double)expectedOnMyMachine * 1.1) {
            PerformanceTestInfo.IterationResult iterationResult = PerformanceTestInfo.IterationResult.BORDERLINE;
            if (iterationResult == null) {
                CpuUsageData.$$$reportNull$$$0(9);
            }
            return iterationResult;
        }
        if (this.myCompilationTimeMs >= this.durationMs) {
            PerformanceTestInfo.IterationResult iterationResult = PerformanceTestInfo.IterationResult.DISTRACTED;
            if (iterationResult == null) {
                CpuUsageData.$$$reportNull$$$0(10);
            }
            return iterationResult;
        }
        PerformanceTestInfo.IterationResult iterationResult = PerformanceTestInfo.IterationResult.SLOW;
        if (iterationResult == null) {
            CpuUsageData.$$$reportNull$$$0(11);
        }
        return iterationResult;
    }

    @NotNull
    private static String printLongestNames(@NotNull List<? extends Pair<Long, String>> times) {
        String stats;
        if (times == null) {
            CpuUsageData.$$$reportNull$$$0(12);
        }
        String string = (stats = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(times).sortedBy(p -> -((Long)p.first).longValue())).filter(p -> (Long)p.first > 10L)).limit(10L)).map(p -> "\"" + (String)p.second + "\" took " + p.first + "ms").joining((CharSequence)", ")).isEmpty() ? "insignificant" : stats;
        if (string == null) {
            CpuUsageData.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static <E extends Throwable> CpuUsageData measureCpuUsage(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            CpuUsageData.$$$reportNull$$$0(14);
        }
        FreeMemorySnapshot memStart = new FreeMemorySnapshot();
        Object2LongOpenHashMap gcTimes = new Object2LongOpenHashMap();
        for (GarbageCollectorMXBean garbageCollectorMXBean : ourGcBeans) {
            gcTimes.put((Object)garbageCollectorMXBean, garbageCollectorMXBean.getCollectionTime());
        }
        Long2ObjectOpenHashMap startTimes = new Long2ObjectOpenHashMap();
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            ThreadInfo threadInfo = ourThreadMXBean.getThreadInfo(id);
            long start = ourThreadMXBean.getThreadUserTime(id);
            if (threadInfo == null || start == -1L) continue;
            startTimes.put(id, (Object)Pair.create((Object)threadInfo, (Object)start));
        }
        long l = CpuUsageData.getTotalCompilationMillis();
        long processStart = ourOSBean.getProcessCpuTime();
        long start = System.nanoTime();
        runnable.run();
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        long processTime = TimeUnit.NANOSECONDS.toMillis(ourOSBean.getProcessCpuTime() - processStart);
        long compilationTime = CpuUsageData.getTotalCompilationMillis() - l;
        FreeMemorySnapshot memEnd = new FreeMemorySnapshot();
        Long2ObjectOpenHashMap threadTimes = new Long2ObjectOpenHashMap(startTimes.size());
        for (long id : ourThreadMXBean.getAllThreadIds()) {
            Pair old = (Pair)startTimes.get(id);
            long end = ourThreadMXBean.getThreadUserTime(id);
            if (old == null || end == -1L) continue;
            threadTimes.put(id, (Object)Pair.create((Object)((ThreadInfo)old.first), (Object)(end - (Long)old.second)));
        }
        Object object = ourGcBeans.iterator();
        while (object.hasNext()) {
            GarbageCollectorMXBean bean = (GarbageCollectorMXBean)object.next();
            gcTimes.put((Object)bean, bean.getCollectionTime() - gcTimes.getLong((Object)bean));
        }
        return new CpuUsageData(duration, (Object2LongMap<GarbageCollectorMXBean>)gcTimes, (Long2ObjectMap<Pair<ThreadInfo, Long>>)threadTimes, compilationTime, processTime, memStart, memEnd);
    }

    static long getTotalCompilationMillis() {
        return ourCompilationMXBean.getTotalCompilationTime();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gcTimes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadTimes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memStart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memEnd";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/CpuUsageData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "times";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/CpuUsageData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessCpuStats";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterationResult";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "printLongestNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSummary";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyActivityBesides";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "printLongestNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "measureCpuUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FreeMemorySnapshot {
        final long free = FreeMemorySnapshot.toMb(Runtime.getRuntime().freeMemory());
        final long total = FreeMemorySnapshot.toMb(Runtime.getRuntime().totalMemory());

        private FreeMemorySnapshot() {
        }

        private static long toMb(long bytes) {
            return bytes / 1024L / 1024L;
        }

        public String toString() {
            return this.free + "/" + this.total;
        }
    }
}

