/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.lang.ref.WeakReference;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.jetbrains.annotations.NotNull;

public class WeakRefFileListener
implements FileListener {
    private final FileSystem fs;
    @NotNull
    private final FileName name;
    private final WeakReference<FileListener> listener;

    protected WeakRefFileListener(FileObject file, FileListener listener) {
        this.fs = file.getFileSystem();
        this.name = file.getName();
        this.listener = new WeakReference<FileListener>(listener);
    }

    public static void installListener(FileObject file, FileListener listener) {
        WeakRefFileListener weakListener = new WeakRefFileListener(file, listener);
        file.getFileSystem().addListener(file, new WeakRefFileListener(file, weakListener));
    }

    protected FileListener getListener() throws Exception {
        FileListener listener = (FileListener)this.listener.get();
        if (listener == null) {
            FileObject file = this.fs.resolveFile(this.name);
            file.getFileSystem().removeListener(file, this);
        }
        return listener;
    }

    @Override
    public void fileCreated(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileCreated(event);
    }

    @Override
    public void fileDeleted(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileDeleted(event);
    }

    @Override
    public void fileChanged(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileChanged(event);
    }
}

