/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.psi.schema;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NotNullLazyValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.Nullable;

public final class ACDirectiveIndex {
    private static List<String> modules = null;
    private final NotNullLazyValue<Map<String, DirectiveEntry>> myDirectives = NotNullLazyValue.lazy(ACDirectiveIndex::parseKnownDirectives);
    private final NotNullLazyValue<Set<String>> myModules = NotNullLazyValue.lazy(() -> {
        HashSet<String> result = new HashSet<String>();
        for (DirectiveEntry directiveEntry : this.getAllDirectives().values()) {
            result.add(directiveEntry.getModule());
        }
        return result;
    });

    private static Map<String, DirectiveEntry> parseKnownDirectives() {
        HashMap<String, DirectiveEntry> result = new HashMap<String, DirectiveEntry>();
        InputStream inputStream = ACDirectiveIndex.class.getResourceAsStream("knownDirectives.xml");
        SAXBuilder parser = new SAXBuilder();
        try {
            Document doc = parser.build(inputStream);
            boolean buildModules = modules == null;
            modules = new ArrayList<String>();
            for (Element module : doc.getRootElement().getChildren()) {
                if (!module.getName().equals("module")) continue;
                String moduleName = module.getAttributeValue("name");
                if (moduleName != null && buildModules) {
                    modules.add(moduleName);
                }
                for (Element directive : module.getChildren()) {
                    DirectiveEntry directiveEntry = DirectiveEntry.create(directive, moduleName);
                    if (directiveEntry == null) continue;
                    result.put(directiveEntry.getName(), directiveEntry);
                }
            }
        }
        catch (JDOMException e) {
            return Collections.emptyMap();
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        return result;
    }

    public static ACDirectiveIndex shared() {
        return (ACDirectiveIndex)ApplicationManager.getApplication().getService(ACDirectiveIndex.class);
    }

    public DirectiveEntry resolve(String name) {
        return (DirectiveEntry)((Map)this.myDirectives.getValue()).get(name);
    }

    public Map<String, DirectiveEntry> getAllDirectives() {
        return (Map)this.myDirectives.getValue();
    }

    public Set<String> getModules() {
        return (Set)this.myModules.getValue();
    }

    public static class DirectiveEntry {
        private String myName;
        private boolean isSection;
        private String myModule;
        private String myDescription;
        private List<String> myContext;
        private String mySyntax;
        private String myStatus;

        public String getStatus() {
            return this.myStatus;
        }

        public String getName() {
            return this.myName;
        }

        public boolean isSection() {
            return this.isSection;
        }

        public String getModule() {
            return this.myModule;
        }

        public String getDescription() {
            return this.myDescription;
        }

        public List<String> getContext() {
            return this.myContext;
        }

        public String getSyntax() {
            return this.mySyntax;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public void setSection(boolean section) {
            this.isSection = section;
        }

        public void setModule(String module) {
            this.myModule = module;
        }

        public void setDescription(String description) {
            this.myDescription = description;
        }

        public void setContext(String[] context) {
            this.myContext = new ArrayList<String>();
            for (String s : context) {
                this.myContext.add(s.trim());
            }
        }

        public void setSyntax(String syntax) {
            this.mySyntax = syntax;
        }

        public void setStatus(String status) {
            this.myStatus = status;
        }

        @Nullable
        public static DirectiveEntry create(Element directive, String moduleName) {
            String name = directive.getAttributeValue("name");
            if (name != null) {
                String syntax = DirectiveEntry.valueForKey(directive, "Syntax");
                String context = DirectiveEntry.valueForKey(directive, "Context");
                String override = DirectiveEntry.valueForKey(directive, "Override");
                String desc = DirectiveEntry.valueForKey(directive, "Description");
                String status = DirectiveEntry.valueForKey(directive, "Status");
                if (syntax != null && context != null && override != null && desc != null) {
                    DirectiveEntry res = new DirectiveEntry();
                    res.setName(name);
                    res.setSection(DirectiveEntry.valueForKey(directive, "isSection") != null);
                    res.setModule(moduleName);
                    res.setDescription(desc);
                    res.setContext(context.split(","));
                    res.setStatus(status);
                    res.setSyntax(syntax);
                    return res;
                }
            }
            return null;
        }

        @Nullable
        private static String valueForKey(Element directive, String key) {
            Element child = directive.getChild(key);
            if (child != null) {
                return child.getText();
            }
            return null;
        }
    }
}

