/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.apacheConfig.parser.ApacheConfigElementTypes;
import com.intellij.lang.apacheConfig.parser.ParserErrors;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ApacheConfigParser
implements PsiParser {
    @NotNull
    public ASTNode parse(@NotNull IElementType root, PsiBuilder builder) {
        if (root == null) {
            ApacheConfigParser.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker rootMarker = builder.mark();
        while (!builder.eof()) {
            if (builder.getTokenType() == ApacheConfigElementTypes.IDENTIFIER) {
                this.parseDirective(builder);
                continue;
            }
            if (builder.getTokenType() == ApacheConfigElementTypes.BEGIN_SECTION_START) {
                this.parseSection(builder);
                continue;
            }
            if (builder.getTokenType() == ApacheConfigElementTypes.WHITE_SPACE) {
                builder.advanceLexer();
                continue;
            }
            builder.error(ParserErrors.directiveOrSectionBeginExpected());
            builder.advanceLexer();
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            ApacheConfigParser.$$$reportNull$$$0(1);
        }
        return aSTNode;
    }

    private void parseSection(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        String sectionNameInHeader = ApacheConfigParser.parseSectionHeader(builder);
        while (builder.getTokenType() != ApacheConfigElementTypes.END_SECTION_START && !builder.eof()) {
            ApacheConfigParser.eatWhiteSpaces(builder);
            if (builder.getTokenType() == ApacheConfigElementTypes.IDENTIFIER) {
                this.parseDirective(builder);
                continue;
            }
            if (builder.getTokenType() == ApacheConfigElementTypes.BEGIN_SECTION_START) {
                this.parseSection(builder);
                continue;
            }
            builder.advanceLexer();
        }
        String sectionNameInFooter = ApacheConfigParser.parseSectionFooter(builder);
        if (sectionNameInHeader == null || !sectionNameInHeader.equals(sectionNameInFooter)) {
            builder.error(ParserErrors.sectionEndExpected());
        }
        marker.done((IElementType)ApacheConfigElementTypes.SECTION);
    }

    private static String parseSectionFooter(PsiBuilder builder) {
        String result = null;
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        ApacheConfigParser.eatWhiteSpaces(builder);
        if (builder.getTokenType() != ApacheConfigElementTypes.IDENTIFIER) {
            builder.error(ParserErrors.sectionNameExpected());
        } else {
            result = builder.getTokenText();
        }
        ApacheConfigParser.eatWhiteSpaces(builder);
        builder.advanceLexer();
        if (builder.getTokenType() != ApacheConfigElementTypes.SECTION_STOP) {
            builder.error(ParserErrors.sectionHeaderEndExpected());
        }
        builder.advanceLexer();
        ApacheConfigParser.eatWhiteSpaces(builder);
        marker.done((IElementType)ApacheConfigElementTypes.SECTION_FOOTER);
        return result;
    }

    private static void eatWhiteSpaces(PsiBuilder builder) {
        while (builder.getTokenType() == ApacheConfigElementTypes.WHITE_SPACE) {
            builder.advanceLexer();
        }
    }

    private static String parseSectionHeader(PsiBuilder builder) {
        String result = null;
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        ApacheConfigParser.eatWhiteSpaces(builder);
        if (builder.getTokenType() != ApacheConfigElementTypes.IDENTIFIER) {
            builder.error(ParserErrors.sectionNameExpected());
        } else {
            result = builder.getTokenText();
        }
        builder.advanceLexer();
        while (builder.getTokenType() != ApacheConfigElementTypes.SECTION_STOP && !builder.eof() && builder.getTokenText() != null && builder.getTokenText().indexOf(10) == -1) {
            ApacheConfigParser.parseArgument(builder, true);
            if (builder.getTokenType() == ApacheConfigElementTypes.ARG_LEXEM || builder.getTokenType() == ApacheConfigElementTypes.WHITE_SPACE || builder.getTokenType() == ApacheConfigElementTypes.SECTION_STOP || builder.getTokenType() == ApacheConfigElementTypes.ARG_SEPARATOR || builder.getTokenText() == null || builder.getTokenText().indexOf(10) == -1) continue;
            builder.error(ParserErrors.argumentOrSectionHeaderEndExpected());
            break;
        }
        if (!builder.eof()) {
            builder.advanceLexer();
        }
        ApacheConfigParser.eatWhiteSpaces(builder);
        marker.done((IElementType)ApacheConfigElementTypes.SECTION_HEADER);
        return result;
    }

    private static void parseArgument(PsiBuilder builder, boolean isHeader) {
        if (ApacheConfigParser.isArgLexem(builder, isHeader)) {
            PsiBuilder.Marker argument = builder.mark();
            while (ApacheConfigParser.isArgLexem(builder, isHeader) || builder.getTokenType() == ApacheConfigElementTypes.IDENTIFIER) {
                boolean isWhitespace = builder.rawLookup(1) == ApacheConfigElementTypes.WHITE_SPACE;
                builder.advanceLexer();
                if (!isWhitespace) continue;
                break;
            }
            argument.done(ApacheConfigElementTypes.ARGUMENT);
        } else if (builder.getTokenType() == ApacheConfigElementTypes.QUOTE) {
            PsiBuilder.Marker argument = builder.mark();
            builder.advanceLexer();
            if (builder.getTokenType() != ApacheConfigElementTypes.ARG_LEXEM && builder.getTokenType() != ApacheConfigElementTypes.QUOTE && builder.getTokenType() != ApacheConfigElementTypes.ARG_SEPARATOR) {
                builder.error(ParserErrors.argumentParseError());
                argument.done(ApacheConfigElementTypes.ARGUMENT);
            } else if (builder.getTokenType() == ApacheConfigElementTypes.QUOTE) {
                builder.advanceLexer();
                argument.done(ApacheConfigElementTypes.ARGUMENT);
            } else {
                while (builder.getTokenType() == ApacheConfigElementTypes.ARG_LEXEM || builder.getTokenType() == ApacheConfigElementTypes.ARG_SEPARATOR) {
                    builder.advanceLexer();
                }
                if (builder.getTokenType() != ApacheConfigElementTypes.QUOTE) {
                    builder.error(ParserErrors.quoteExpected());
                    argument.done(ApacheConfigElementTypes.ARGUMENT);
                } else {
                    builder.advanceLexer();
                    argument.done(ApacheConfigElementTypes.ARGUMENT);
                }
            }
        } else {
            builder.advanceLexer();
        }
    }

    private static boolean isArgLexem(PsiBuilder builder, boolean isHeader) {
        IElementType type = builder.getTokenType();
        return type == ApacheConfigElementTypes.ARG_LEXEM || !isHeader && type == ApacheConfigElementTypes.SECTION_STOP;
    }

    private void parseDirective(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        do {
            ApacheConfigParser.parseArgument(builder, false);
        } while (ApacheConfigParser.isArgLexem(builder, false) || builder.getTokenType() == ApacheConfigElementTypes.QUOTE || builder.getTokenType() == ApacheConfigElementTypes.ARG_SEPARATOR || builder.getTokenType() == ApacheConfigElementTypes.WHITE_SPACE && builder.getTokenText() != null && builder.getTokenText().indexOf(10) == -1 && !builder.eof());
        ApacheConfigParser.eatWhiteSpaces(builder);
        marker.done((IElementType)ApacheConfigElementTypes.DIRECTIVE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/apacheConfig/parser/ApacheConfigParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/apacheConfig/parser/ApacheConfigParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

