/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.utils.collections.array;

import com.intellij.grazie.detector.utils.collections.array.OptimizedFloatArray;
import com.intellij.grazie.detector.utils.collections.array.TrivialOptimizedFloatArray;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J \u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/detector/utils/collections/array/ThreeOptimizedFloatArray;", "Lcom/intellij/grazie/detector/utils/collections/array/OptimizedFloatArray;", "()V", "fstIndex", "", "fstValue", "", "sndIndex", "sndValue", "thrdIndex", "thrdValue", "get", "index", "", "set", "value", "size", "language-detector"})
public final class ThreeOptimizedFloatArray
implements OptimizedFloatArray {
    private byte fstIndex = (byte)-1;
    private float fstValue = -1.0f;
    private byte sndIndex = (byte)-1;
    private float sndValue = -1.0f;
    private byte thrdIndex = (byte)-1;
    private float thrdValue = -1.0f;

    @Override
    public float get(int index) {
        if (this.fstIndex == (byte)index) {
            return this.fstValue;
        }
        if (this.sndIndex == (byte)index) {
            return this.sndValue;
        }
        if (this.thrdIndex == (byte)index) {
            return this.thrdValue;
        }
        return 0.0f;
    }

    @Override
    @NotNull
    public OptimizedFloatArray set(int index, float value, byte size) {
        if (this.fstIndex == -1) {
            this.fstIndex = (byte)index;
            this.fstValue = value;
            return this;
        }
        if (this.sndIndex == -1) {
            this.sndIndex = (byte)index;
            this.sndValue = value;
            return this;
        }
        if (this.thrdIndex == -1) {
            this.thrdIndex = (byte)index;
            this.thrdValue = value;
            return this;
        }
        TrivialOptimizedFloatArray trivial = new TrivialOptimizedFloatArray(size);
        trivial.set(this.fstIndex, this.fstValue, size);
        trivial.set(this.sndIndex, this.sndValue, size);
        trivial.set(this.thrdIndex, this.thrdValue, size);
        trivial.set(index, value, size);
        return trivial;
    }
}

